/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.KeyBindingUtility;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_337;
import net.minecraft.class_345;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.lwjgl.glfw.GLFW;

public class WellenTrackerUtility {
    private static boolean isInitialized = false;
    private static boolean isTrackingMonsters = false;
    private static boolean showOverlays = true;
    private static class_304 toggleKeyBinding;
    private static final Map<String, Integer> currentWaveMonsters;
    private static final Map<String, Map<String, Integer>> waveData;
    private static String currentWave;
    private static String currentDimension;
    private static String playerName;
    private static long waveStartTime;
    private static final Set<class_1297> trackedEntities;
    private static final Map<class_1297, String> entityTypes;
    private static final int LINE_HEIGHT = 13;
    private static final int OVERLAY_WIDTH = 200;
    private static final int OVERLAY_HEIGHT = 120;
    private static final int TEXT_PADDING = 10;
    private static final Map<String, String> CHINESE_TO_NUMBER;
    private static final String LOG_FILE_PATH = "wellen_monster_log.txt";
    private static final String DEBUG_LOG_FILE_PATH = "wellen_monster_debug.log";
    private static final boolean ENABLE_DEBUG_LOGGING = true;
    private static final boolean ENABLE_CONSOLE_LOGGING = true;

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        try {
            WellenTrackerUtility.logDebug("=== Monster Tracker Utility Initialization Started ===");
            WellenTrackerUtility.registerHotkey();
            WellenTrackerUtility.logDebug("Hotkey registered successfully");
            ClientTickEvents.END_CLIENT_TICK.register(WellenTrackerUtility::onClientTick);
            WellenTrackerUtility.logDebug("Client tick event registered");
            HudRenderCallback.EVENT.register((drawContext, tickDelta) -> WellenTrackerUtility.onHudRender(drawContext, tickDelta));
            WellenTrackerUtility.logDebug("HUD rendering event registered");
            isInitialized = true;
            WellenTrackerUtility.logDebug("=== Monster Tracker Utility Initialization Completed ===");
        }
        catch (Exception e) {
            WellenTrackerUtility.logError("Failed to initialize Monster Tracker Utility: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void registerHotkey() {
        toggleKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.cclive-utilities.wellen-toggle", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.cclive-utilities.wellen"));
        class_304 debugKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.cclive-utilities.wellen-debug", class_3675.class_307.field_1668, 298, "category.cclive-utilities.wellen"));
        WellenTrackerUtility.logDebug("Debug hotkey registered: F9");
    }

    private static void onClientTick(class_310 client) {
        WellenTrackerUtility.checkTabKey();
        WellenTrackerUtility.handleHotkey();
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).wellenTrackerEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showWellenTracker)) {
            return;
        }
        if (client.field_1724 == null) {
            if (isTrackingMonsters) {
                WellenTrackerUtility.logDebug("Player is null, stopping monster tracking");
                isTrackingMonsters = false;
            }
            return;
        }
        WellenTrackerUtility.checkTrackingConditions(client);
        if (isTrackingMonsters) {
            WellenTrackerUtility.updateMonsterTracking(client);
        }
    }

    private static void checkTabKey() {
        if (KeyBindingUtility.isPlayerListKeyPressed()) {
            if (showOverlays) {
                WellenTrackerUtility.logDebug("Tab key pressed, hiding overlays");
                showOverlays = false;
            }
        } else if (!showOverlays) {
            WellenTrackerUtility.logDebug("Tab key released, showing overlays");
            showOverlays = true;
        }
    }

    private static void handleHotkey() {
        if (toggleKeyBinding.method_1436()) {
            boolean bl = isTrackingMonsters = !isTrackingMonsters;
            if (isTrackingMonsters) {
                WellenTrackerUtility.logDebug("Hotkey pressed: Monster tracking ENABLED");
                trackedEntities.clear();
                entityTypes.clear();
                currentWaveMonsters.clear();
                if (waveStartTime == 0L) {
                    waveStartTime = System.currentTimeMillis();
                    WellenTrackerUtility.logDebug("\ud83d\ude80 Manual tracking started at " + String.valueOf(new Date(waveStartTime)));
                }
                WellenTrackerUtility.logDebug("\ud83e\uddf9 Cleared all tracking data for fresh start");
            } else {
                WellenTrackerUtility.logDebug("Hotkey pressed: Monster tracking DISABLED");
                WellenTrackerUtility.resetTrackingData();
            }
        }
        if (GLFW.glfwGetKey((long)GLFW.glfwGetCurrentContext(), (int)298) == 1) {
            WellenTrackerUtility.logDebug("Debug hotkey (F9) pressed - printing debug info");
            WellenTrackerUtility.printDebugInfo();
        }
        if (GLFW.glfwGetKey((long)GLFW.glfwGetCurrentContext(), (int)299) == 1) {
            WellenTrackerUtility.logDebug("File test hotkey (F10) pressed - testing file creation");
            WellenTrackerUtility.testFileCreation();
        }
        if (GLFW.glfwGetKey((long)GLFW.glfwGetCurrentContext(), (int)300) == 1) {
            WellenTrackerUtility.logDebug("Scoreboard debug hotkey (F11) pressed - checking scoreboard");
            WellenTrackerUtility.debugScoreboard(class_310.method_1551());
        }
    }

    private static void checkTrackingConditions(class_310 client) {
        String newDimension;
        if (client.field_1724 == null) {
            return;
        }
        String newPlayerName = client.field_1724.method_5477().getString();
        if (!newPlayerName.equals(playerName)) {
            WellenTrackerUtility.logDebug("Player name changed: '" + playerName + "' -> '" + newPlayerName + "'");
            playerName = newPlayerName;
        }
        if (!(newDimension = client.field_1687.method_27983().method_29177().toString()).equals(currentDimension)) {
            WellenTrackerUtility.logDebug("Dimension changed: '" + currentDimension + "' -> '" + newDimension + "'");
            currentDimension = newDimension;
        }
        if (isTrackingMonsters) {
            WellenTrackerUtility.logDebug("Tracking is manually enabled, checking bossbar for wave information");
            WellenTrackerUtility.updateCurrentWave(client);
        }
    }

    private static void updateCurrentWave(class_310 client) {
        try {
            WellenTrackerUtility.logDebug("=== BOSSBAR CHECK ===");
            if (client.field_1705 != null && client.field_1705.method_1740() != null) {
                class_337 bossBarHud = client.field_1705.method_1740();
                WellenTrackerUtility.logDebug("\u2705 BossBarHud found, attempting to access bossbars");
                System.out.println("[BOSSBAR] \ud83d\udd0d Checking bossbars for wave information...");
                Map bossBars = null;
                String[] possibleFieldNames = new String[]{"field_2060", "bossBars", "bossbars", "bossBars", "bars", "bossBarMap"};
                WellenTrackerUtility.logDebug("Trying to access bossbars with reflection...");
                for (String fieldName : possibleFieldNames) {
                    try {
                        Field bossBarsField = bossBarHud.getClass().getDeclaredField(fieldName);
                        bossBarsField.setAccessible(true);
                        Object fieldValue = bossBarsField.get(bossBarHud);
                        if (fieldValue instanceof Map) {
                            Map tempBars = (Map)fieldValue;
                            if (tempBars != null && !tempBars.isEmpty()) {
                                bossBars = tempBars;
                                WellenTrackerUtility.logDebug("\u2705 Successfully accessed bossbars using field: " + fieldName + " (count: " + tempBars.size() + ")");
                                break;
                            }
                            WellenTrackerUtility.logDebug("\u26a0\ufe0f Field " + fieldName + " is empty or null");
                            continue;
                        }
                        WellenTrackerUtility.logDebug("\u26a0\ufe0f Field " + fieldName + " is not a Map: " + (fieldValue != null ? fieldValue.getClass().getSimpleName() : "null"));
                    }
                    catch (Exception e) {
                        WellenTrackerUtility.logDebug("\u274c Failed to access bossbars using field: " + fieldName + " - " + e.getMessage());
                    }
                }
                if (bossBars != null) {
                    WellenTrackerUtility.logDebug("Processing " + bossBars.size() + " bossbars");
                    for (class_345 bossBar : bossBars.values()) {
                        String bossBarText = bossBar.method_5414().getString();
                        WellenTrackerUtility.logDebug("\ud83d\udcca Bossbar text: '" + bossBarText + "'");
                        boolean hasChineseChars = false;
                        for (String chineseChar : CHINESE_TO_NUMBER.keySet()) {
                            if (!bossBarText.contains(chineseChar)) continue;
                            hasChineseChars = true;
                            WellenTrackerUtility.logDebug("\ud83d\udd24 Found chinese character: '" + chineseChar + "' in bossbar");
                            break;
                        }
                        if (!hasChineseChars) {
                            WellenTrackerUtility.logDebug("\u26a0\ufe0f No chinese characters found in bossbar text");
                        }
                        String decodedWave = WellenTrackerUtility.decodeChineseWave(bossBarText);
                        WellenTrackerUtility.logDebug("\ud83d\udd22 Decoded wave from bossbar: '" + decodedWave + "' (original: '" + bossBarText + "')");
                        if (!decodedWave.isEmpty() && !decodedWave.equals(currentWave)) {
                            WellenTrackerUtility.logDebug("\ud83c\udfaf New wave detected: '" + currentWave + "' -> '" + decodedWave + "'");
                            if (!currentWave.isEmpty()) {
                                WellenTrackerUtility.logDebug("\ud83d\udcbe Saving data for previous wave: " + currentWave);
                                WellenTrackerUtility.saveWaveData();
                            }
                            currentWave = decodedWave;
                            currentWaveMonsters.clear();
                            trackedEntities.clear();
                            entityTypes.clear();
                            waveStartTime = System.currentTimeMillis();
                            WellenTrackerUtility.logDebug("\ud83d\ude80 Started tracking new wave: " + currentWave + " at " + String.valueOf(new Date(waveStartTime)));
                            continue;
                        }
                        if (decodedWave.isEmpty()) {
                            WellenTrackerUtility.logDebug("\u26a0\ufe0f Could not decode wave number from bossbar text");
                            continue;
                        }
                        WellenTrackerUtility.logDebug("\u2139\ufe0f Same wave detected: " + currentWave);
                    }
                } else {
                    WellenTrackerUtility.logDebug("\u274c No bossbars found or accessible");
                }
            } else {
                WellenTrackerUtility.logDebug("\u274c BossBarHud not available");
            }
            WellenTrackerUtility.logDebug("=== END BOSSBAR CHECK ===");
        }
        catch (Exception e) {
            WellenTrackerUtility.logError("Error updating current wave: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String decodeChineseWave(String text) {
        StringBuilder waveNumber = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String character = String.valueOf(text.charAt(i));
            if (!CHINESE_TO_NUMBER.containsKey(character)) continue;
            waveNumber.append(CHINESE_TO_NUMBER.get(character));
            WellenTrackerUtility.logDebug("Decoded chinese character: '" + character + "' -> '" + CHINESE_TO_NUMBER.get(character) + "'");
        }
        String result = waveNumber.toString();
        WellenTrackerUtility.logDebug("Final decoded wave number: '" + result + "' from text: '" + text + "'");
        return result;
    }

    private static void updateMonsterTracking(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        double radius = 64.0;
        double playerX = client.field_1724.method_23317();
        double playerY = client.field_1724.method_23318();
        double playerZ = client.field_1724.method_23321();
        int newEntitiesFound = 0;
        for (class_1297 entity : client.field_1687.method_18112()) {
            double distance;
            if (!WellenTrackerUtility.isValidMonster(entity) || !((distance = Math.sqrt(Math.pow(entity.method_23317() - playerX, 2.0) + Math.pow(entity.method_23318() - playerY, 2.0) + Math.pow(entity.method_23321() - playerZ, 2.0))) <= radius) || trackedEntities.contains(entity)) continue;
            if (waveStartTime > 0L) {
                trackedEntities.add(entity);
                String entityType = WellenTrackerUtility.getEntityTypeName(entity);
                entityTypes.put(entity, entityType);
                int oldCount = currentWaveMonsters.getOrDefault(entityType, 0);
                int newCount = oldCount + 1;
                currentWaveMonsters.put(entityType, newCount);
                WellenTrackerUtility.logDebug("New mob spawned during wave: " + entityType + " at distance " + String.format("%.1f", distance) + " blocks (count: " + oldCount + " -> " + newCount + ")");
                ++newEntitiesFound;
                continue;
            }
            WellenTrackerUtility.logDebug("Ignoring existing mob: " + WellenTrackerUtility.getEntityTypeName(entity) + " - wave not started yet");
        }
        if (newEntitiesFound > 0) {
            WellenTrackerUtility.logDebug("Mob tracking update - New: " + newEntitiesFound + " monsters spawned, Total tracked: " + trackedEntities.size());
        }
    }

    private static boolean isValidMonster(class_1297 entity) {
        if (entity == null || entity.method_31481() || !(entity instanceof class_1309)) {
            return false;
        }
        if (entity instanceof class_746 || entity instanceof class_1657) {
            return false;
        }
        return entity.method_5864() != class_1299.field_6131;
    }

    private static String getEntityTypeName(class_1297 entity) {
        if (entity.method_5864() == class_1299.field_6137) {
            return "Skelett";
        }
        if (entity.method_5864() == class_1299.field_6051) {
            return "Zombie";
        }
        if (entity.method_5864() == class_1299.field_6079) {
            return "Spinne";
        }
        if (entity.method_5864() == class_1299.field_6046) {
            return "Creeper";
        }
        if (entity.method_5864() == class_1299.field_6091) {
            return "Enderman";
        }
        if (entity.method_5864() == class_1299.field_6145) {
            return "Hexe";
        }
        if (entity.method_5864() == class_1299.field_6069) {
            return "Schleim";
        }
        if (entity.method_5864() == class_1299.field_6099) {
            return "Lohe";
        }
        if (entity.method_5864() == class_1299.field_6107) {
            return "Ghast";
        }
        if (entity.method_5864() == class_1299.field_6102) {
            return "Magma Cube";
        }
        if (entity.method_5864() == class_1299.field_6109) {
            return "Shulker";
        }
        if (entity.method_5864() == class_1299.field_6118) {
            return "W\u00e4chter";
        }
        if (entity.method_5864() == class_1299.field_6086) {
            return "Elder W\u00e4chter";
        }
        if (entity.method_5864() == class_1299.field_6076) {
            return "Wither Skelett";
        }
        if (entity.method_5864() == class_1299.field_6098) {
            return "Stray";
        }
        if (entity.method_5864() == class_1299.field_6071) {
            return "Husk";
        }
        if (entity.method_5864() == class_1299.field_6123) {
            return "Ertrunkener";
        }
        if (entity.method_5864() == class_1299.field_6078) {
            return "Phantom";
        }
        if (entity.method_5864() == class_1299.field_6059) {
            return "Vex";
        }
        if (entity.method_5864() == class_1299.field_6090) {
            return "Beschw\u00f6rer";
        }
        if (entity.method_5864() == class_1299.field_6117) {
            return "Vindicator";
        }
        if (entity.method_5864() == class_1299.field_6105) {
            return "Pl\u00fcnderer";
        }
        if (entity.method_5864() == class_1299.field_6134) {
            return "Verw\u00fcster";
        }
        if (entity.method_5864() == class_1299.field_21973) {
            return "Hoglin";
        }
        if (entity.method_5864() == class_1299.field_23696) {
            return "Zoglin";
        }
        if (entity.method_5864() == class_1299.field_22281) {
            return "Piglin";
        }
        if (entity.method_5864() == class_1299.field_25751) {
            return "Piglin Brute";
        }
        if (entity.method_5864() == class_1299.field_6050) {
            return "Zombifizierter Piglin";
        }
        if (entity.method_5864() == class_1299.field_6125) {
            return "Silberfisch";
        }
        if (entity.method_5864() == class_1299.field_6128) {
            return "Endermite";
        }
        if (entity.method_5864() == class_1299.field_6084) {
            return "H\u00f6hlenspinne";
        }
        if (entity.method_5864() == class_1299.field_6116) {
            return "Ender Drache";
        }
        if (entity.method_5864() == class_1299.field_6119) {
            return "Wither";
        }
        if (entity.method_5864() == class_1299.field_38095) {
            return "Warden";
        }
        if (entity.method_5864() == class_1299.field_6139) {
            return "Pferd";
        }
        if (entity.method_5864() == class_1299.field_6085) {
            return "Kuh";
        }
        if (entity.method_5864() == class_1299.field_6093) {
            return "Schwein";
        }
        if (entity.method_5864() == class_1299.field_6115) {
            return "Schaf";
        }
        if (entity.method_5864() == class_1299.field_6132) {
            return "Huhn";
        }
        if (entity.method_5864() == class_1299.field_20346) {
            return "Biene";
        }
        if (entity.method_5864() == class_1299.field_6077) {
            return "Dorfbewohner";
        }
        if (entity.method_5864() == class_1299.field_6147) {
            return "Eisen-Golem";
        }
        if (entity.method_5864() == class_1299.field_6047) {
            return "Schnee-Golem";
        }
        if (entity.method_5864() == class_1299.field_6074) {
            return "Llama";
        }
        if (entity.method_5864() == class_1299.field_17714) {
            return "H\u00e4ndler-Llama";
        }
        if (entity.method_5864() == class_1299.field_6055) {
            return "Wolf";
        }
        if (entity.method_5864() == class_1299.field_16281) {
            return "Katze";
        }
        if (entity.method_5864() == class_1299.field_6081) {
            return "Ozelot";
        }
        if (entity.method_5864() == class_1299.field_17943) {
            return "Fuchs";
        }
        if (entity.method_5864() == class_1299.field_6140) {
            return "Hase";
        }
        if (entity.method_5864() == class_1299.field_6042) {
            return "Eisb\u00e4r";
        }
        if (entity.method_5864() == class_1299.field_6146) {
            return "Panda";
        }
        if (entity.method_5864() == class_1299.field_6113) {
            return "Schildkr\u00f6te";
        }
        if (entity.method_5864() == class_1299.field_6087) {
            return "Delfin";
        }
        if (entity.method_5864() == class_1299.field_6114) {
            return "Tintenfisch";
        }
        if (entity.method_5864() == class_1299.field_28402) {
            return "Leucht-Tintenfisch";
        }
        if (entity.method_5864() == class_1299.field_28315) {
            return "Axolotl";
        }
        if (entity.method_5864() == class_1299.field_30052) {
            return "Ziege";
        }
        if (entity.method_5864() == class_1299.field_37419) {
            return "Frosch";
        }
        if (entity.method_5864() == class_1299.field_37420) {
            return "Kaulquappe";
        }
        if (entity.method_5864() == class_1299.field_38384) {
            return "Allay";
        }
        if (entity.method_5864() == class_1299.field_42622) {
            return "Sniffer";
        }
        if (entity.method_5864() == class_1299.field_40116) {
            return "Kamel";
        }
        if (entity.method_5864() == class_1299.field_6143) {
            return "Mooshroom";
        }
        if (entity.method_5864() == class_1299.field_23214) {
            return "Strider";
        }
        if (entity.method_5864() == class_1299.field_6108) {
            return "Fledermaus";
        }
        if (entity.method_5864() == class_1299.field_6104) {
            return "Papagei";
        }
        if (entity.method_5864() == class_1299.field_6081) {
            return "Ozelot";
        }
        if (entity.method_5864() == class_1299.field_6057) {
            return "Maultier";
        }
        if (entity.method_5864() == class_1299.field_6067) {
            return "Esel";
        }
        if (entity.method_5864() == class_1299.field_6075) {
            return "Skelett-Pferd";
        }
        if (entity.method_5864() == class_1299.field_6048) {
            return "Zombie-Pferd";
        }
        return entity.method_5864().method_35050();
    }

    private static void saveWaveData() {
        WellenTrackerUtility.logDebug("saveWaveData() called - currentWave: '" + currentWave + "', currentWaveMonsters size: " + currentWaveMonsters.size());
        if (currentWave.isEmpty()) {
            WellenTrackerUtility.logDebug("Cannot save wave data: currentWave is empty");
            return;
        }
        if (currentWaveMonsters.isEmpty()) {
            WellenTrackerUtility.logDebug("Cannot save wave data: currentWaveMonsters is empty");
            return;
        }
        WellenTrackerUtility.logDebug("Saving wave data for wave " + currentWave + " with " + currentWaveMonsters.size() + " mob types");
        for (Map.Entry<String, Integer> entry : currentWaveMonsters.entrySet()) {
            WellenTrackerUtility.logDebug("  - " + entry.getKey() + ": " + String.valueOf(entry.getValue()));
        }
        waveData.put(currentWave, new HashMap<String, Integer>(currentWaveMonsters));
        WellenTrackerUtility.logDebug("Wave data saved to memory. Total waves in memory: " + waveData.size());
        WellenTrackerUtility.writeToLogFile();
    }

    private static void writeToLogFile() {
        try {
            File logFile = new File(LOG_FILE_PATH);
            WellenTrackerUtility.logDebug("Attempting to write to file: " + logFile.getAbsolutePath());
            WellenTrackerUtility.logDebug("File exists: " + logFile.exists());
            WellenTrackerUtility.logDebug("Can write: " + logFile.canWrite());
            WellenTrackerUtility.logDebug("Parent directory exists: " + (logFile.getParentFile() == null || logFile.getParentFile().exists()));
            if (logFile.getParentFile() != null && !logFile.getParentFile().exists()) {
                boolean dirCreated = logFile.getParentFile().mkdirs();
                WellenTrackerUtility.logDebug("Created parent directories: " + dirCreated);
            }
            PrintWriter writer = new PrintWriter(new FileWriter(logFile, false));
            WellenTrackerUtility.logDebug("Writing " + waveData.size() + " waves to file");
            if (waveData.isEmpty()) {
                WellenTrackerUtility.logDebug("No wave data to write - waveData is empty");
                writer.println("Keine Wellen-Daten verf\u00fcgbar");
            } else {
                ArrayList<String> sortedWaves = new ArrayList<String>(waveData.keySet());
                sortedWaves.sort((wave1, wave2) -> {
                    try {
                        int num1 = Integer.parseInt(wave1);
                        int num2 = Integer.parseInt(wave2);
                        return Integer.compare(num1, num2);
                    }
                    catch (NumberFormatException e) {
                        return wave1.compareTo((String)wave2);
                    }
                });
                WellenTrackerUtility.logDebug("Writing " + sortedWaves.size() + " waves in sorted order: " + String.valueOf(sortedWaves));
                for (String waveKey : sortedWaves) {
                    Map<String, Integer> monsters = waveData.get(waveKey);
                    WellenTrackerUtility.logDebug("Writing wave: " + waveKey);
                    writer.println("Welle " + waveKey);
                    int mobsWritten = 0;
                    for (Map.Entry<String, Integer> monsterEntry : monsters.entrySet()) {
                        if (monsterEntry.getValue() <= 0) continue;
                        writer.println("-" + monsterEntry.getKey() + " x" + String.valueOf(monsterEntry.getValue()));
                        ++mobsWritten;
                    }
                    WellenTrackerUtility.logDebug("  - Wrote " + mobsWritten + " mob types for wave " + waveKey);
                    writer.println();
                }
            }
            writer.close();
            WellenTrackerUtility.logDebug("File write completed successfully! File size: " + logFile.length() + " bytes");
            WellenTrackerUtility.logDebug("File exists after write: " + logFile.exists());
        }
        catch (IOException e) {
            WellenTrackerUtility.logError("IOException while writing to log file: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            WellenTrackerUtility.logError("Unexpected error while writing to log file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void resetTrackingData() {
        WellenTrackerUtility.logDebug("Resetting all tracking data");
        currentWaveMonsters.clear();
        trackedEntities.clear();
        entityTypes.clear();
        currentWave = "";
        currentDimension = "";
        waveStartTime = 0L;
    }

    private static void onHudRender(class_332 context, class_9779 tickDelta) {
        if (!showOverlays || !isTrackingMonsters) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int x = screenWidth + ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).wellenTrackerX;
        int y = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).wellenTrackerY;
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).wellenTrackerShowBackground) {
            context.method_25294(x, y, x + 200, y + 120, Integer.MIN_VALUE);
        }
        WellenTrackerUtility.drawMonsterInfo(context, x + 10, y + 10, client);
    }

    private static void drawMonsterInfo(class_332 context, int x, int y, class_310 client) {
        class_5250 headerText = class_2561.method_43470((String)"Monster Tracker");
        context.method_51439(client.field_1772, (class_2561)headerText, x, y, ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).wellenTrackerHeaderColor.getRGB(), true);
        y += 13;
        if (!currentWave.isEmpty()) {
            class_5250 waveText = class_2561.method_43470((String)("Welle: " + currentWave));
            context.method_51439(client.field_1772, (class_2561)waveText, x, y, ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).wellenTrackerTextColor.getRGB(), true);
            y += 13;
        }
        if (!currentWaveMonsters.isEmpty()) {
            class_5250 statsText = class_2561.method_43470((String)"Aktuelle Monster:");
            context.method_51439(client.field_1772, (class_2561)statsText, x, y, ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).wellenTrackerTextColor.getRGB(), true);
            y += 13;
            for (Map.Entry<String, Integer> entry : currentWaveMonsters.entrySet()) {
                if (entry.getValue() <= 0) continue;
                class_5250 entryText = class_2561.method_43470((String)(entry.getKey() + ": " + String.valueOf(entry.getValue())));
                context.method_51439(client.field_1772, (class_2561)entryText, x, y, ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).wellenTrackerTextColor.getRGB(), true);
                y += 13;
            }
        }
    }

    private static void logDebug(String message) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss.SSS"));
        String logMessage = "[" + timestamp + "] [DEBUG] " + message;
        System.out.println(logMessage);
        WellenTrackerUtility.writeToDebugLog(logMessage);
    }

    private static void logError(String message) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss.SSS"));
        String logMessage = "[" + timestamp + "] [ERROR] " + message;
        System.err.println(logMessage);
        WellenTrackerUtility.writeToDebugLog(logMessage);
    }

    private static void writeToDebugLog(String message) {
        try {
            File debugFile = new File(DEBUG_LOG_FILE_PATH);
            PrintWriter writer = new PrintWriter(new FileWriter(debugFile, true));
            writer.println(message);
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isTrackingMonsters() {
        return isTrackingMonsters;
    }

    public static String getCurrentWave() {
        return currentWave;
    }

    public static Map<String, Integer> getCurrentWaveMonsters() {
        return new HashMap<String, Integer>(currentWaveMonsters);
    }

    public static Map<String, Map<String, Integer>> getWaveData() {
        return new HashMap<String, Map<String, Integer>>(waveData);
    }

    public static void printDebugInfo() {
        WellenTrackerUtility.logDebug("=== DEBUG INFO ===");
        WellenTrackerUtility.logDebug("Initialized: " + isInitialized);
        WellenTrackerUtility.logDebug("Tracking Monsters: " + isTrackingMonsters);
        WellenTrackerUtility.logDebug("Show Overlays: " + showOverlays);
        WellenTrackerUtility.logDebug("Current Wave: '" + currentWave + "'");
        WellenTrackerUtility.logDebug("Current Dimension: '" + currentDimension + "'");
        WellenTrackerUtility.logDebug("Player Name: '" + playerName + "'");
        WellenTrackerUtility.logDebug("Tracked Entities: " + trackedEntities.size());
        WellenTrackerUtility.logDebug("Current Wave Monsters: " + currentWaveMonsters.size());
        WellenTrackerUtility.logDebug("Total Wave Data: " + waveData.size());
        File logFile = new File(LOG_FILE_PATH);
        WellenTrackerUtility.logDebug("Log file path: " + logFile.getAbsolutePath());
        WellenTrackerUtility.logDebug("Log file exists: " + logFile.exists());
        if (logFile.exists()) {
            WellenTrackerUtility.logDebug("Log file size: " + logFile.length() + " bytes");
            WellenTrackerUtility.logDebug("Log file last modified: " + String.valueOf(new Date(logFile.lastModified())));
        }
        File debugLogFile = new File(DEBUG_LOG_FILE_PATH);
        WellenTrackerUtility.logDebug("Debug log file path: " + debugLogFile.getAbsolutePath());
        WellenTrackerUtility.logDebug("Debug log file exists: " + debugLogFile.exists());
        if (debugLogFile.exists()) {
            WellenTrackerUtility.logDebug("Debug log file size: " + debugLogFile.length() + " bytes");
        }
        if (!currentWaveMonsters.isEmpty()) {
            WellenTrackerUtility.logDebug("Current Mob Counts:");
            for (Map.Entry<String, Object> entry : currentWaveMonsters.entrySet()) {
                WellenTrackerUtility.logDebug("  " + entry.getKey() + ": " + String.valueOf(entry.getValue()));
            }
        }
        if (!waveData.isEmpty()) {
            WellenTrackerUtility.logDebug("Stored Wave Data:");
            for (Map.Entry<String, Object> entry : waveData.entrySet()) {
                WellenTrackerUtility.logDebug("  Welle " + entry.getKey() + ": " + ((Map)entry.getValue()).size() + " mob types");
            }
        }
        WellenTrackerUtility.logDebug("=== END DEBUG INFO ===");
    }

    public static void testFileCreation() {
        WellenTrackerUtility.logDebug("=== TESTING FILE CREATION ===");
        HashMap<String, Integer> testMobs = new HashMap<String, Integer>();
        testMobs.put("Test-Skelett", 5);
        testMobs.put("Test-Zombie", 3);
        testMobs.put("Test-Pferd", 2);
        currentWave = "TEST";
        currentWaveMonsters.clear();
        currentWaveMonsters.putAll(testMobs);
        WellenTrackerUtility.logDebug("Created test data for wave: " + currentWave);
        WellenTrackerUtility.logDebug("Test mobs: " + currentWaveMonsters.size());
        WellenTrackerUtility.saveWaveData();
        WellenTrackerUtility.logDebug("=== FILE CREATION TEST COMPLETED ===");
    }

    public static void debugScoreboard(class_310 client) {
        WellenTrackerUtility.logDebug("=== SCOREBOARD DEBUG ===");
        WellenTrackerUtility.logDebug("Scoreboard debugging removed - use hotkey to toggle tracking instead");
        WellenTrackerUtility.logDebug("=== END SCOREBOARD DEBUG ===");
    }

    static {
        currentWaveMonsters = new HashMap<String, Integer>();
        waveData = new HashMap<String, Map<String, Integer>>();
        currentWave = "";
        currentDimension = "";
        playerName = "";
        waveStartTime = 0L;
        trackedEntities = new HashSet<class_1297>();
        entityTypes = new HashMap<class_1297, String>();
        CHINESE_TO_NUMBER = new HashMap<String, String>();
        CHINESE_TO_NUMBER.put("\u3782", "0");
        CHINESE_TO_NUMBER.put("\u3783", "1");
        CHINESE_TO_NUMBER.put("\u3784", "2");
        CHINESE_TO_NUMBER.put("\u3785", "3");
        CHINESE_TO_NUMBER.put("\u3786", "4");
        CHINESE_TO_NUMBER.put("\u3787", "5");
        CHINESE_TO_NUMBER.put("\u3788", "6");
        CHINESE_TO_NUMBER.put("\u3789", "7");
        CHINESE_TO_NUMBER.put("\u378a", "8");
        CHINESE_TO_NUMBER.put("\u378b", "9");
    }
}

