/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.EquipmentDisplayUtility;
import net.felix.utilities.KeyBindingUtility;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_9779;

public class BPViewerUtility {
    private static boolean isInitialized = false;
    private static boolean isVisible = true;
    private static boolean showOverlays = true;
    private static BPViewerUtility INSTANCE;
    private String currentRarity = "common";
    private static String manualFloor;
    private final Map<String, String> foundBlueprints = new HashMap<String, String>();
    private final Map<String, Set<String>> floorProgress = new HashMap<String, Set<String>>();
    private static final String[] RARITY_ORDER;
    private static final int HUD_WIDTH = 200;
    private static final int HUD_HEIGHT = 100;
    private static final int RIGHT_MARGIN_PERCENT = 1;
    private static final int TOP_MARGIN_PERCENT = 2;
    private static final Pattern BLUEPRINT_PATTERN;
    private static final Pattern BLUEPRINT_PATTERN_ALT;
    private static final Pattern BLUEPRINT_PATTERN_ALT2;
    private static final Pattern BLUEPRINT_PATTERN_ALT3;
    private static final Pattern BLUEPRINT_PATTERN_COMBO;
    private static final Pattern BLUEPRINT_PATTERN_FLEXIBLE;
    private static final Pattern BLUEPRINT_PATTERN_COMBO_CHEST;
    private static final String SAVE_FILE_NAME = "found_blueprints.json";
    private static final String PROGRESS_FILE_NAME = "blueprint_progress.json";
    private final File saveFile;
    private final File progressFile;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static class_304 toggleKeyBinding;
    private static class_304 nextRarityKeyBinding;
    private static class_304 previousRarityKeyBinding;
    private final BlueprintConfig config = new BlueprintConfig();
    private static final String BLUEPRINTS_CONFIG_FILE = "assets/cclive-utilities/blueprints.json";
    private static String lastDebugFloor;
    private static boolean debugPrinted;
    private static boolean lastWasBlueprintShop;
    private static final int[] BLUEPRINT_SHOP_SLOTS;

    public BPViewerUtility() {
        INSTANCE = this;
        this.saveFile = new File("config", SAVE_FILE_NAME);
        this.progressFile = new File("config", PROGRESS_FILE_NAME);
        this.loadFoundBlueprints();
        this.loadProgress();
        this.loadBlueprintConfig();
    }

    public static BPViewerUtility getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("BPViewerUtility instance is null!");
        }
        return INSTANCE;
    }

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        BPViewerUtility instance = new BPViewerUtility();
        BPViewerUtility.registerKeyBindings();
        HudRenderCallback.EVENT.register((context, tickCounter) -> {
            if (isVisible && instance.getActiveFloor() != null && showOverlays && !EquipmentDisplayUtility.isEquipmentOverlayActive()) {
                instance.onHudRender(context, tickCounter);
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null) {
                String dimensionId = client.field_1687.method_27983().method_29177().toString();
                String previousFloor = BPViewerUtility.getCurrentFloor();
                String newFloor = BPViewerUtility.getCurrentFloor();
                if (toggleKeyBinding.method_1436()) {
                    BPViewerUtility.toggleVisibility();
                }
                if (nextRarityKeyBinding.method_1436()) {
                    instance.nextRarity();
                }
                if (previousRarityKeyBinding.method_1436()) {
                    instance.previousRarity();
                }
                instance.checkBlueprintShopInventory(client);
                BPViewerUtility.checkTabKey();
            }
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, isOverlay) -> {
            String messageText = message.getString();
            instance.checkForBlueprint(messageText);
            return true;
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, isOverlay) -> {
            String messageText = message.getString();
            if (messageText.contains("[Bauplan]") || messageText.contains("Kombo") || messageText.contains("Belohnungen")) {
                System.out.println("[BPViewer] Received message: " + messageText);
            }
            instance.checkForBlueprint(messageText);
            return true;
        });
        ItemTooltipCallback.EVENT.register((stack, context, tooltipType, lines) -> {
            class_310 mcClient;
            if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerEnabled) {
                return;
            }
            if (stack != null && stack.method_7909().toString().contains("name_tag")) {
                String screenTitle;
                mcClient = class_310.method_1551();
                boolean isSpecialInventory = false;
                if (mcClient != null && mcClient.field_1755 != null && (screenTitle = mcClient.field_1755.method_25440().getString()).contains("\u3b2a")) {
                    isSpecialInventory = true;
                }
                if (!isSpecialInventory) {
                    return;
                }
            } else {
                return;
            }
            mcClient = class_310.method_1551();
            boolean isInShop = false;
            if (mcClient != null && mcClient.field_1755 instanceof class_465) {
                class_465 screen = (class_465)mcClient.field_1755;
                String title = screen.method_25440().getString();
                String cleanTitle = title.replaceAll("[\\u3400-\\u4DBF\\u4E00-\\u9FFF]", "");
                boolean bl = isInShop = (cleanTitle = cleanTitle.replaceAll("\u00a7[0-9a-fk-or]", "")).contains("Bauplan [Shop]") || cleanTitle.contains("Bauplan Shop") || cleanTitle.contains("Bauplan") && cleanTitle.contains("Shop");
                if (isInShop) {
                    return;
                }
            }
            for (class_2561 line : lines) {
                boolean isInShopCheck;
                class_310 client;
                String lineText = line.getString();
                if (!lineText.contains(" - [Bauplan]")) continue;
                String blueprintName = lineText.replace(" - [Bauplan]", "");
                blueprintName = blueprintName.replaceAll("[\\u3400-\\u4DBF\\u4E00-\\u9FFF]", "");
                blueprintName = blueprintName.replaceAll("\\([^)]*\\)", "").trim();
                if (instance.foundBlueprints.containsKey(blueprintName = blueprintName.replaceAll("\\[Ebene \\d+\\]", "").trim())) {
                    int lineIndex = lines.indexOf(line);
                    if (lineIndex == -1) continue;
                    class_5250 newText = line.method_27661();
                    class_5250 coloredText = line.method_27661();
                    coloredText.method_10852((class_2561)class_2561.method_43470((String)" \u2713").method_27692(class_124.field_1060));
                    lines.set(lineIndex, coloredText);
                    continue;
                }
                if (isInShop || (client = class_310.method_1551()) == null || !(client.field_1755 instanceof class_465)) continue;
                class_465 screen = (class_465)client.field_1755;
                String title = screen.method_25440().getString();
                String cleanTitle = title.replaceAll("[\\u3400-\\u4DBF\\u4E00-\\u9FFF]", "");
                boolean bl = isInShopCheck = (cleanTitle = cleanTitle.replaceAll("\u00a7[0-9a-fk-or]", "")).contains("Bauplan [Shop]") || cleanTitle.contains("Bauplan Shop") || cleanTitle.contains("Bauplan") && cleanTitle.contains("Shop");
                if (isInShopCheck) {
                    boolean foundInAnyFloor = false;
                    for (Map.Entry<String, BlueprintConfig.FloorData> floorEntry : instance.config.floors.entrySet()) {
                        BlueprintConfig.FloorData floor = floorEntry.getValue();
                        if (floor == null || floor.blueprints == null) continue;
                        for (Map.Entry<String, BlueprintConfig.RarityData> rarityEntry : floor.blueprints.entrySet()) {
                            if (!rarityEntry.getValue().items.contains(blueprintName)) continue;
                            instance.markBlueprintAsFound(blueprintName, rarityEntry.getKey());
                            foundInAnyFloor = true;
                            break;
                        }
                        if (!foundInAnyFloor) continue;
                        break;
                    }
                    if (!foundInAnyFloor && !instance.foundBlueprints.containsKey(blueprintName)) {
                        instance.markBlueprintAsFound(blueprintName, "unknown");
                    }
                    instance.scanBlueprintShopSlots(screen);
                    continue;
                }
                if (!(client.field_1755 instanceof class_465)) continue;
                instance.scanBlueprintShopSlots((class_465)client.field_1755);
            }
        });
        BPViewerUtility.registerCommands();
        isInitialized = true;
    }

    private static void registerKeyBindings() {
        toggleKeyBinding = new class_304("key.cclive-utilities.toggle-blueprint-viewer", class_3675.class_307.field_1668, 66, "key.categories.cclive-utilities.blueprints");
        nextRarityKeyBinding = new class_304("key.cclive-utilities.next-blueprint-rarity", class_3675.class_307.field_1668, 262, "key.categories.cclive-utilities.blueprints");
        previousRarityKeyBinding = new class_304("key.cclive-utilities.previous-blueprint-rarity", class_3675.class_307.field_1668, 263, "key.categories.cclive-utilities.blueprints");
        KeyBindingHelper.registerKeyBinding((class_304)toggleKeyBinding);
        KeyBindingHelper.registerKeyBinding((class_304)nextRarityKeyBinding);
        KeyBindingHelper.registerKeyBinding((class_304)previousRarityKeyBinding);
    }

    private static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bp").then(ClientCommandManager.literal((String)"reset").executes(context -> {
            BPViewerUtility instance = BPViewerUtility.getInstance();
            instance.resetFoundBlueprints();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aAlle gefundenen Baupl\u00e4ne wurden zur\u00fcckgesetzt!"));
            return 1;
        }))));
    }

    private void onHudRender(class_332 context, class_9779 tickCounter) {
        try {
            class_310 client = class_310.method_1551();
            if (client == null) {
                return;
            }
            if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerEnabled || !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showBlueprintViewer) {
                return;
            }
            int screenWidth = client.method_22683().method_4486();
            int screenHeight = client.method_22683().method_4502();
            int x = screenWidth - 200 - ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerX;
            int y = screenHeight * ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerY / 100;
            if (!debugPrinted) {
                // empty if block
            }
            String activeFloor = this.getActiveFloor();
            BlueprintConfig.FloorData floorData = this.config.getFloorData(activeFloor);
            if (!activeFloor.equals(lastDebugFloor)) {
                if (floorData != null) {
                    // empty if block
                }
                lastDebugFloor = activeFloor;
            }
            if (floorData != null && floorData.blueprints != null && floorData.blueprints.containsKey(this.currentRarity)) {
                BlueprintConfig.RarityData rarityData = floorData.blueprints.get(this.currentRarity);
                int dynamicWidth = this.calculateRequiredWidth(rarityData.items) - 15;
                int dynamicHeight = this.calculateRequiredHeight(rarityData.items);
                int dynamicX = screenWidth - dynamicWidth - ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerX;
                if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerShowBackground) {
                    context.method_25294(dynamicX, y, dynamicX + dynamicWidth, y + dynamicHeight, Integer.MIN_VALUE);
                }
                if (!debugPrinted) {
                    debugPrinted = true;
                }
                this.renderBlueprintList(context, dynamicX + 10, y + 2, rarityData.items, rarityData.color);
            } else {
                context.method_51433(client.field_1772, "No data for floor: " + activeFloor, x + 10, y + 30, -65536, false);
                context.method_51433(client.field_1772, "Rarity: " + this.currentRarity, x + 10, y + 45, -256, false);
                if (floorData != null && floorData.blueprints != null) {
                    context.method_51433(client.field_1772, "Available: " + String.valueOf(floorData.blueprints.keySet()), x + 10, y + 60, -256, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        debugPrinted = false;
    }

    private int calculateRequiredHeight(List<String> blueprints) {
        int baseHeight = 20;
        int blueprintHeight = blueprints.size() * 12;
        int bottomPadding = 5;
        return baseHeight + blueprintHeight + bottomPadding;
    }

    private int calculateRequiredWidth(List<String> blueprints) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return 200;
        }
        int maxWidth = 200;
        for (String blueprint : blueprints) {
            String displayText = blueprint.startsWith("- ") ? blueprint.substring(2) : blueprint;
            int textWidth = client.field_1772.method_1727(displayText);
            if ((textWidth += 30) <= maxWidth) continue;
            maxWidth = textWidth;
        }
        return Math.max(maxWidth, 200);
    }

    private void renderBlueprintList(class_332 context, int x, int y, List<String> blueprints, String rarityColor) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        if (!debugPrinted) {
            // empty if block
        }
        String rarityDisplay = this.currentRarity.toUpperCase();
        int titleX = x + 50 - client.field_1772.method_1727(rarityDisplay) / 2;
        context.method_51433(client.field_1772, rarityDisplay, titleX, y + 3, switch (this.currentRarity.toLowerCase()) {
            case "common" -> -1;
            case "uncommon" -> -16711936;
            case "rare" -> -16776961;
            case "epic" -> -65281;
            case "legendary" -> -256;
            default -> -1;
        }, true);
        int blueprintY = y + 20;
        for (String blueprint : blueprints) {
            String displayText = blueprint.startsWith("- ") ? blueprint.substring(2) : blueprint;
            boolean isFound = this.foundBlueprints.containsKey(displayText) || this.isBlueprintFound(this.getActiveFloor(), displayText);
            int color = isFound ? this.getColorFromString(rarityColor) : 0x888888;
            int textWidth = client.field_1772.method_1727(displayText);
            int textColor = isFound ? -1 : -7829368;
            context.method_51433(client.field_1772, displayText, x, blueprintY, textColor, true);
            if (!debugPrinted) {
                // empty if block
            }
            blueprintY += 12;
        }
    }

    private static void checkTabKey() {
        showOverlays = !KeyBindingUtility.isPlayerListKeyPressed();
    }

    public void checkForBlueprint(String messageText) {
        Matcher matcher;
        if (messageText.contains("[Bauplan]") || messageText.contains("Kombo") || messageText.contains("Belohnungen")) {
            System.out.println("[BPViewer] Processing message: " + messageText);
        }
        if (!(matcher = BLUEPRINT_PATTERN.matcher(messageText)).matches()) {
            matcher = BLUEPRINT_PATTERN_ALT.matcher(messageText);
        }
        if (!matcher.matches()) {
            matcher = BLUEPRINT_PATTERN_ALT2.matcher(messageText);
        }
        if (!matcher.matches()) {
            matcher = BLUEPRINT_PATTERN_ALT3.matcher(messageText);
        }
        if (!matcher.matches()) {
            matcher = BLUEPRINT_PATTERN_COMBO.matcher(messageText);
        }
        if (!matcher.matches()) {
            matcher = BLUEPRINT_PATTERN_FLEXIBLE.matcher(messageText);
        }
        if (!matcher.matches()) {
            matcher = BLUEPRINT_PATTERN_COMBO_CHEST.matcher(messageText);
        }
        if (matcher.matches()) {
            String blueprintName = matcher.group(1).trim();
            System.out.println("[BPViewer] Found blueprint: " + blueprintName);
            if (this.foundBlueprints.containsKey(blueprintName)) {
                System.out.println("[BPViewer] Blueprint already found: " + blueprintName);
                return;
            }
            String activeFloor = this.getActiveFloor();
            System.out.println("[BPViewer] Active floor: " + activeFloor);
            BlueprintConfig.FloorData floorData = this.config.getFloorData(activeFloor);
            if (floorData != null && floorData.blueprints != null) {
                boolean foundInFloor = false;
                for (Map.Entry<String, BlueprintConfig.RarityData> entry : floorData.blueprints.entrySet()) {
                    if (!entry.getValue().items.contains(blueprintName)) continue;
                    System.out.println("[BPViewer] Marking blueprint as found: " + blueprintName + " (rarity: " + entry.getKey() + ")");
                    this.markBlueprintAsFound(blueprintName, entry.getKey());
                    foundInFloor = true;
                    break;
                }
                if (!foundInFloor) {
                    System.out.println("[BPViewer] Blueprint not found in current floor: " + blueprintName);
                    block1: for (Map.Entry<String, Object> entry : this.config.floors.entrySet()) {
                        if (((BlueprintConfig.FloorData)entry.getValue()).blueprints == null) continue;
                        for (Map.Entry<String, BlueprintConfig.RarityData> rarityEntry : ((BlueprintConfig.FloorData)entry.getValue()).blueprints.entrySet()) {
                            if (!rarityEntry.getValue().items.contains(blueprintName)) continue;
                            System.out.println("[BPViewer] Found blueprint in floor " + entry.getKey() + ": " + blueprintName + " (rarity: " + rarityEntry.getKey() + ")");
                            this.markBlueprintAsFound(blueprintName, rarityEntry.getKey());
                            continue block1;
                        }
                    }
                }
            } else {
                System.out.println("[BPViewer] No floor data found for current floor: " + activeFloor);
            }
        } else if (messageText.contains("[Bauplan]")) {
            System.out.println("[BPViewer] Message contains [Bauplan] but no pattern matched: " + messageText);
        }
    }

    private void checkBlueprintShopInventory(class_310 client) {
        if (client.field_1755 instanceof class_465) {
            boolean isInShop;
            class_465 screen = (class_465)client.field_1755;
            String title = screen.method_25440().getString();
            String cleanTitle = title.replaceAll("[\\u3400-\\u4DBF\\u4E00-\\u9FFF]", "");
            boolean bl = isInShop = (cleanTitle = cleanTitle.replaceAll("\u00a7[0-9a-fk-or]", "")).contains("Bauplan [Shop]") || cleanTitle.contains("Bauplan Shop") || cleanTitle.contains("Bauplan") && cleanTitle.contains("Shop");
            if (isInShop) {
                if (!lastWasBlueprintShop) {
                    lastWasBlueprintShop = true;
                }
                this.scanBlueprintShopSlots(screen);
            } else {
                lastWasBlueprintShop = false;
            }
        } else {
            lastWasBlueprintShop = false;
        }
    }

    private void scanBlueprintShopSlots(class_465<?> screen) {
        if (screen.method_17577() == null) {
            return;
        }
        int itemsFound = 0;
        for (int slotIndex : BLUEPRINT_SHOP_SLOTS) {
            class_1735 slot;
            class_1799 itemStack;
            if (slotIndex >= screen.method_17577().field_7761.size() || (itemStack = (slot = (class_1735)screen.method_17577().field_7761.get(slotIndex)).method_7677()).method_7960()) continue;
            ++itemsFound;
            String itemName = itemStack.method_7964().getString();
            if (!itemName.contains("[Bauplan]")) continue;
            String blueprintName = itemName.replaceAll("\\[Bauplan\\]", "").trim();
            blueprintName = blueprintName.replaceAll("[\\u3400-\\u4DBF\\u4E00-\\u9FFF]", "");
            blueprintName = blueprintName.replaceAll("\u00a7[0-9a-fk-or]", "");
            blueprintName = blueprintName.replaceAll("\\s*-\\s*$", "").trim();
            boolean foundInAnyFloor = false;
            for (Map.Entry<String, BlueprintConfig.FloorData> floorEntry : this.config.floors.entrySet()) {
                BlueprintConfig.FloorData floor = floorEntry.getValue();
                if (floor == null || floor.blueprints == null) continue;
                for (Map.Entry<String, BlueprintConfig.RarityData> rarityEntry : floor.blueprints.entrySet()) {
                    if (!rarityEntry.getValue().items.contains(blueprintName)) continue;
                    if (!this.foundBlueprints.containsKey(blueprintName)) {
                        this.markBlueprintAsFound(blueprintName, rarityEntry.getKey());
                    }
                    foundInAnyFloor = true;
                    break;
                }
                if (!foundInAnyFloor) continue;
                break;
            }
            if (foundInAnyFloor || this.foundBlueprints.containsKey(blueprintName)) continue;
            this.markBlueprintAsFound(blueprintName, "unknown");
        }
    }

    private void markBlueprintAsFound(String blueprintName, String rarity) {
        System.out.println("[BPViewer] markBlueprintAsFound called with: " + blueprintName + ", rarity: " + rarity);
        if (!this.foundBlueprints.containsKey(blueprintName)) {
            this.foundBlueprints.put(blueprintName, rarity);
            this.markBlueprintFound(this.getActiveFloor(), blueprintName);
            this.saveFoundBlueprints();
            System.out.println("[BPViewer] Successfully marked blueprint as found: " + blueprintName);
        } else {
            System.out.println("[BPViewer] Blueprint already in foundBlueprints: " + blueprintName);
        }
    }

    private void nextRarity() {
        int currentIndex = this.getCurrentRarityIndex();
        if (currentIndex < RARITY_ORDER.length - 1) {
            this.currentRarity = RARITY_ORDER[currentIndex + 1];
        }
    }

    private void previousRarity() {
        int currentIndex = this.getCurrentRarityIndex();
        if (currentIndex > 0) {
            this.currentRarity = RARITY_ORDER[currentIndex - 1];
        }
    }

    private int getCurrentRarityIndex() {
        for (int i = 0; i < RARITY_ORDER.length; ++i) {
            if (!RARITY_ORDER[i].equals(this.currentRarity)) continue;
            return i;
        }
        return 0;
    }

    public static void toggleVisibility() {
        boolean bl = isVisible = !isVisible;
        if (!isVisible) {
            manualFloor = null;
        }
    }

    public static void setVisibility(boolean visible, String floor) {
        isVisible = visible;
        if (!visible) {
            manualFloor = null;
        } else if (floor != null) {
            BPViewerUtility.getInstance().setManualFloor(floor);
        }
    }

    public static boolean isVisible() {
        return isVisible;
    }

    public String getActiveFloor() {
        return manualFloor != null ? manualFloor : BPViewerUtility.getCurrentFloor();
    }

    public void setManualFloor(String floor) {
        if (floor != null && !((String)floor).startsWith("floor_")) {
            floor = "floor_" + (String)floor;
        }
        manualFloor = floor;
    }

    private static String getCurrentFloor() {
        String floorPart;
        String[] parts;
        String dimensionId;
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1687 != null && (dimensionId = client.field_1687.method_27983().method_29177().toString()).startsWith("minecraft:floor_") && (parts = (floorPart = dimensionId.substring("minecraft:floor_".length())).split("_")).length >= 1) {
            String floorNumber = parts[0];
            String floorKey = "floor_" + floorNumber;
            return floorKey;
        }
        return null;
    }

    private void loadFoundBlueprints() {
        if (this.saveFile.exists()) {
            try (FileReader reader = new FileReader(this.saveFile);){
                Type type = new TypeToken<HashMap<String, String>>(this){}.getType();
                Map loaded = (Map)this.gson.fromJson((Reader)reader, type);
                if (loaded != null) {
                    this.foundBlueprints.clear();
                    this.foundBlueprints.putAll(loaded);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveFoundBlueprints() {
        try (FileWriter writer = new FileWriter(this.saveFile);){
            this.gson.toJson(this.foundBlueprints, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadProgress() {
        if (this.progressFile.exists()) {
            try (FileReader reader = new FileReader(this.progressFile);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject progress = json.getAsJsonObject("progress");
                for (String floor : progress.keySet()) {
                    HashSet floorBlueprints = new HashSet();
                    progress.getAsJsonArray(floor).forEach(element -> floorBlueprints.add(element.getAsString()));
                    this.floorProgress.put(floor, floorBlueprints);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveProgress() {
        try {
            this.progressFile.getParentFile().mkdirs();
            JsonObject json = new JsonObject();
            json.addProperty("modVersion", "1.0.0");
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1724 != null) {
                json.addProperty("username", client.field_1724.method_5477().getString());
            } else {
                json.addProperty("username", "unknown");
            }
            JsonObject progress = new JsonObject();
            for (Map.Entry<String, Set<String>> entry : this.floorProgress.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                progress.add(entry.getKey(), this.gson.toJsonTree(entry.getValue()));
            }
            json.add("progress", (JsonElement)progress);
            try (FileWriter writer = new FileWriter(this.progressFile);){
                this.gson.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void markBlueprintFound(String floor, String blueprintName) {
        if (floor != null && blueprintName != null) {
            this.floorProgress.computeIfAbsent(floor, k -> new HashSet()).add(blueprintName);
            this.saveProgress();
        }
    }

    public boolean isBlueprintFound(String floor, String blueprintName) {
        Set<String> floorBlueprints = this.floorProgress.get(floor);
        return floorBlueprints != null && floorBlueprints.contains(blueprintName);
    }

    public void resetFoundBlueprints() {
        this.foundBlueprints.clear();
        this.floorProgress.clear();
        this.saveFoundBlueprints();
        this.saveProgress();
    }

    private int getColorFromString(String colorString) {
        switch (colorString.toUpperCase()) {
            case "WHITE": {
                return 0xFFFFFF;
            }
            case "GREEN": {
                return 0x55FF55;
            }
            case "BLUE": {
                return 0x5555FF;
            }
            case "PURPLE": {
                return 0xAA00AA;
            }
            case "GOLD": {
                return 0xFFAA00;
            }
        }
        return 0xFFFFFF;
    }

    private void loadBlueprintConfig() {
        try {
            Path resource = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("cclive-utilities").orElseThrow(() -> new RuntimeException("Mod container not found"))).findPath(BLUEPRINTS_CONFIG_FILE).orElseThrow(() -> new RuntimeException("Blueprint config file not found"));
            try (InputStream inputStream = Files.newInputStream(resource, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(inputStream);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject floors = json.getAsJsonObject("floors");
                for (String floorKey : floors.keySet()) {
                    JsonObject floorData = floors.getAsJsonObject(floorKey);
                    JsonObject blueprints = floorData.getAsJsonObject("blueprints");
                    BlueprintConfig.FloorData floor = new BlueprintConfig.FloorData();
                    for (String rarityKey : blueprints.keySet()) {
                        JsonObject rarityData = blueprints.getAsJsonObject(rarityKey);
                        String color = rarityData.get("color").getAsString();
                        JsonArray itemsArray = rarityData.getAsJsonArray("items");
                        ArrayList<String> items = new ArrayList<String>();
                        itemsArray.forEach(element -> items.add(element.getAsString()));
                        floor.blueprints.put(rarityKey, new BlueprintConfig.RarityData(items, color));
                    }
                    this.config.floors.put(floorKey, floor);
                }
                int count = 0;
                for (String floorKey : this.config.floors.keySet()) {
                    if (count >= 3) continue;
                    BlueprintConfig.FloorData floor = this.config.floors.get(floorKey);
                    ++count;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load blueprint config: " + e.getMessage());
            e.printStackTrace();
            this.initializeFallbackFloors();
        }
    }

    private void initializeFallbackFloors() {
        BlueprintConfig.FloorData floor1 = new BlueprintConfig.FloorData();
        floor1.blueprints.put("common", new BlueprintConfig.RarityData(List.of("Anf\u00e4nger Hacke", "Anf\u00e4nger Axt", "Anf\u00e4nger Spitzhacke", "Gebeulte Handgelenkmanschetten", "Kopfgeldj\u00e4gerring"), "WHITE"));
        floor1.blueprints.put("uncommon", new BlueprintConfig.RarityData(List.of("Erzbrecherballiste", "Ergiebiger Langbogen", "Pelzgewand des Eiswanderers"), "GREEN"));
        floor1.blueprints.put("rare", new BlueprintConfig.RarityData(List.of("Halskette des Bezwingers", "Eroberers Schulterpanzer", "Sch\u00e4delspalter"), "BLUE"));
        this.config.floors.put("floor_1", floor1);
    }

    static {
        manualFloor = null;
        RARITY_ORDER = new String[]{"common", "uncommon", "rare", "epic", "legendary"};
        BLUEPRINT_PATTERN = Pattern.compile("\u00a7f\\[\u00a76Legend\u00a7f\\] Du erh\u00e4ltst (.+?) \u00a7f- \u00a73\\[Bauplan\\]");
        BLUEPRINT_PATTERN_ALT = Pattern.compile("\u00a7a\\+ 1x (.+?) \u00a7f- \u00a73\\[Bauplan\\]");
        BLUEPRINT_PATTERN_ALT2 = Pattern.compile("\u00a7f\\[\u00a76Legend\u00a7f\\] Du erh\u00e4ltst (.+?) - \u00a73\\[Bauplan\\]");
        BLUEPRINT_PATTERN_ALT3 = Pattern.compile("\u00a7a\\+ 1x (.+?) - \u00a73\\[Bauplan\\]");
        BLUEPRINT_PATTERN_COMBO = Pattern.compile("\u00a7a\\+ 1x (.+?) \u00a7f- \u00a73\\[Bauplan\\]");
        BLUEPRINT_PATTERN_FLEXIBLE = Pattern.compile(".*?\\+ 1x (.+?) .*?\\[Bauplan\\]");
        BLUEPRINT_PATTERN_COMBO_CHEST = Pattern.compile(".*?\\+ 1x (.+?) .*?\\[Bauplan\\].*?\\(\\d+\\)");
        lastDebugFloor = null;
        debugPrinted = false;
        lastWasBlueprintShop = false;
        BLUEPRINT_SHOP_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    }

    public static class BlueprintConfig {
        public final Map<String, FloorData> floors = new HashMap<String, FloorData>();

        public FloorData getFloorData(String floor) {
            return this.floors.get(floor);
        }

        public static class FloorData {
            public Map<String, RarityData> blueprints = new HashMap<String, RarityData>();
        }

        public static class RarityData {
            public List<String> items;
            public String color;

            public RarityData(List<String> items, String color) {
                this.items = items;
                this.color = color;
            }
        }
    }
}

