/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.felix.CCLiveUtilitiesConfig;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class AnimationBlockerUtility {
    private static boolean isInitialized = false;
    private static boolean animationBlockingEnabled = false;
    private static final Set<String> EPIC_DROPS_CHARACTERS = new HashSet<String>();
    private static final Set<String> LEGENDARY_DROPS_CHARACTERS = new HashSet<String>();
    private static final Set<String> LOGGING_LEVEL_UP_CHARACTERS = new HashSet<String>();
    private static final Set<String> MOBLEXICON_CHARACTERS = new HashSet<String>();
    private static final Set<String> MINING_LEVEL_UP_CHARACTERS = new HashSet<String>();
    private static final Set<String> AIRSHIP_CHARACTERS = new HashSet<String>();
    private static final Set<String> BLOCKED_CHARACTERS = new HashSet<String>();

    private static void addCharactersFromString(String charString, Set<String> targetSet) {
        for (int i = 0; i < charString.length(); ++i) {
            String singleChar = String.valueOf(charString.charAt(i));
            targetSet.add(singleChar);
        }
    }

    private static void updateBlockedCharacters() {
        BLOCKED_CHARACTERS.clear();
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).epicDropsBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(EPIC_DROPS_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).legendaryDropsBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(LEGENDARY_DROPS_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).loggingLevelUpBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(LOGGING_LEVEL_UP_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).moblexiconBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(MOBLEXICON_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).miningLevelUpBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(MINING_LEVEL_UP_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).airshipBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(AIRSHIP_CHARACTERS);
        }
    }

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        try {
            ClientTickEvents.END_CLIENT_TICK.register(AnimationBlockerUtility::onClientTick);
            ClientReceiveMessageEvents.GAME.register(AnimationBlockerUtility::onGameMessage);
            isInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void onGameMessage(class_2561 message, boolean overlay) {
        if (!animationBlockingEnabled) {
            return;
        }
        if (message == null) {
            return;
        }
        String messageString = message.getString();
        if (messageString.trim().isEmpty()) {
            return;
        }
        boolean foundBlockedChar = false;
        for (int i = 0; i < messageString.length(); ++i) {
            String messageChar = String.valueOf(messageString.charAt(i));
            if (!BLOCKED_CHARACTERS.contains(messageChar)) continue;
            foundBlockedChar = true;
            break;
        }
        if (foundBlockedChar) {
            return;
        }
    }

    private static void onClientTick(class_310 client) {
        AnimationBlockerUtility.updateBlockedCharacters();
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod || !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).animationBlockerEnabled) {
            animationBlockingEnabled = false;
            return;
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            animationBlockingEnabled = false;
            return;
        }
        animationBlockingEnabled = true;
    }

    public static void reset() {
        animationBlockingEnabled = false;
    }

    public static boolean isAnimationBlockingEnabled() {
        return animationBlockingEnabled;
    }

    public static Set<String> getBlockedCharacters() {
        return new HashSet<String>(BLOCKED_CHARACTERS);
    }

    static {
        AnimationBlockerUtility.addCharactersFromString("\u3a8d\u3a8e\u3a8f\u3a90\u3a91\u3a92\u3a93\u3a94", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a95\u3a96\u3a97\u3a98\u3a99\u3a9a\u3a9b\u3a9c", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a9d\u3a9e\u3a9f\u3aa0\u3aa1\u3aa2\u3aa3\u3aa4", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3aa5\u3aa6\u3aa7\u3aa8\u3aa9\u3aaa\u3aab\u3aac", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3aad\u3aae\u3aaf\u3ab0\u3ab1\u3ab2\u3ab3\u3ab4", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a65\u3a66\u3a67\u3a68\u3a69\u3a6a\u3a6b\u3a6c", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a6d\u3a6e\u3a6f\u3a70\u3a71\u3a72\u3a73\u3a74", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a75\u3a76\u3a77\u3a78\u3a79\u3a7a\u3a7b\u3a7c", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a7d\u3a7e\u3a7f\u3a80\u3a81\u3a82\u3a83\u3a84", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a85\u3a86\u3a87\u3a88\u3a89\u3a8a\u3a8b\u3a8c", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ac4\u3ac5\u3ac6\u3ac7", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ac8\u3ac9\u3aca\u3acb", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3acc\u3acd\u3ace\u3acf", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ad0\u3ad1\u3ad2\u3ad3", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ad4\u3ad5\u3ad6\u3ad7", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ad8\u3ad9\u3ada\u3adb", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3adc\u3add\u3ade\u3adf", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ae0\u3ae1\u3ae2\u3ae3", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ae4\u3ae5\u3ae6\u3ae7", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ae8\u3ae9\u3aea\u3aeb", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3526\u3520", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b2b\u3b2c\u3b2d\u3b2e\u3b2f\u3b30", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b31\u3b32\u3b33\u3b34\u3b35\u3b36", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b37\u3b38\u3b39\u3b3a\u3b3b\u3b3c", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b3d\u3b3e\u3b3f\u3b40\u3b41\u3b42", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b43\u3b44\u3b45\u3b46\u3b47\u3b48", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b49\u3b4a\u3b4b\u3b4c\u3b4d\u3b4e", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3afb\u3afc\u3afd\u3afe", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3aff\u3b00\u3b01\u3b02", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b03\u3b04\u3b05\u3b06", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b07\u3b08\u3b09\u3b0a", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b0b\u3b0c\u3b0d\u3b0e", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b0f\u3b10\u3b11\u3b12", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b13\u3b14\u3b15\u3b16", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b17\u3b18\u3b19\u3b1a", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b1b\u3b1c\u3b1d\u3b1e", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b1f\u3b20\u3b21\u3b22", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b69\u3b6a\u3b6b\u3b6c\u3b6d\u3b6e\u3b6f", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b70\u3b71\u3b72\u3b73\u3b74\u3b75\u3b76", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b77\u3b78\u3b79\u3b7a\u3b7b\u3b7c\u3b7d", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b7e\u3b7f\u3b80\u3b81\u3b82\u3b83\u3b84", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b85\u3b86\u3b87\u3b88\u3b89\u3b8a\u3b8b", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b8c\u3b8d\u3b8e\u3b8f\u3b90\u3b91\u3b92", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b93\u3b94\u3b95\u3b96\u3b97\u3b98\u3b99", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b9a\u3b9b\u3b9c\u3b9d\u3b9e\u3b9f\u3ba0", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.updateBlockedCharacters();
    }
}

