/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.SearchBarUtility;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9779;

public class EquipmentDisplayUtility {
    private static boolean isInEquipmentChest = false;
    private static boolean showOverlays = true;
    private static Map<String, Double> percentageStats = new HashMap<String, Double>();
    private static Map<String, Double> absoluteStats = new HashMap<String, Double>();
    private static double totalArmor = 0.0;
    private static final int[] EQUIPMENT_SLOTS = new int[]{1, 2, 6, 10, 11, 15, 19, 20, 24, 29, 33, 38, 42, 48, 50};
    private static final Pattern STAT_PATTERN = Pattern.compile("([+-]?\\d+(?:\\.\\d+)?)");
    private static final Pattern ARMOR_PATTERN = Pattern.compile("R\u00fcstung\\s*([+-]?\\d+(?:\\.\\d+)?)");
    private static int leftScrollOffset = 0;
    private static int rightScrollOffset = 0;
    private static boolean leftOverlayHovered = false;
    private static boolean rightOverlayHovered = false;

    public static void onMouseScroll(double vertical) {
        int maxScroll;
        int baseVisibleEntries;
        if (!isInEquipmentChest) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        int scrollAmount = (int)(vertical * 12.0);
        if (leftOverlayHovered) {
            leftScrollOffset -= scrollAmount;
            leftScrollOffset = Math.max(0, leftScrollOffset);
            baseVisibleEntries = 14;
            maxScroll = Math.max(0, percentageStats.size() - baseVisibleEntries) * 12;
            leftScrollOffset = Math.min(leftScrollOffset, maxScroll);
        }
        if (rightOverlayHovered) {
            rightScrollOffset -= scrollAmount;
            rightScrollOffset = Math.max(0, rightScrollOffset);
            baseVisibleEntries = 14;
            maxScroll = Math.max(0, absoluteStats.size() - baseVisibleEntries) * 12;
            rightScrollOffset = Math.min(rightScrollOffset, maxScroll);
        }
    }

    public static boolean isEquipmentOverlayActive() {
        return isInEquipmentChest && showOverlays;
    }

    public static boolean isInEquipmentChest() {
        return isInEquipmentChest;
    }

    public static void initialize() {
        ClientTickEvents.END_CLIENT_TICK.register(EquipmentDisplayUtility::onClientTick);
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> EquipmentDisplayUtility.onHudRender(drawContext, tickDelta));
        SearchBarUtility.initialize();
    }

    private static void onClientTick(class_310 client) {
        EquipmentDisplayUtility.checkTabKey();
        if (client.field_1724 == null || client.field_1755 == null) {
            isInEquipmentChest = false;
            return;
        }
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof class_465) {
            class_465 handledScreen = (class_465)class_4372;
            String title = handledScreen.method_25440().getString();
            if (title.contains("\u3b25") || title.contains("\u3b26") || title.contains("\u3b27") || title.contains("\u3b28")) {
                isInEquipmentChest = true;
                EquipmentDisplayUtility.updateEquipmentStats(handledScreen, client);
                EquipmentDisplayUtility.handleScrolling(client);
            } else {
                isInEquipmentChest = false;
            }
        } else {
            isInEquipmentChest = false;
        }
    }

    private static void checkTabKey() {
        showOverlays = !class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)258);
    }

    private static void handleScrolling(class_310 client) {
        int mouseX = (int)client.field_1729.method_1603() * client.method_22683().method_4486() / client.method_22683().method_4480();
        int mouseY = (int)client.field_1729.method_1604() * client.method_22683().method_4502() / client.method_22683().method_4507();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int inventoryWidth = 176;
        int inventoryHeight = 166;
        int inventoryX = (screenWidth - inventoryWidth) / 2;
        int inventoryY = (screenHeight - inventoryHeight) / 2;
        int overlayWidth = 170;
        int overlayHeight = inventoryHeight + 55;
        int overlaySpacing = 5;
        int leftOverlayX = inventoryX - overlayWidth - overlaySpacing;
        int rightOverlayX = inventoryX + inventoryWidth + overlaySpacing;
        int overlayY = inventoryY - 28;
        leftOverlayHovered = mouseX >= leftOverlayX && mouseX <= leftOverlayX + overlayWidth && mouseY >= overlayY && mouseY <= overlayY + overlayHeight;
        rightOverlayHovered = mouseX >= rightOverlayX && mouseX <= rightOverlayX + overlayWidth && mouseY >= overlayY && mouseY <= overlayY + overlayHeight;
    }

    private static void updateEquipmentStats(class_465<?> screen, class_310 client) {
        percentageStats.clear();
        absoluteStats.clear();
        totalArmor = 0.0;
        for (int slotIndex : EQUIPMENT_SLOTS) {
            class_1735 slot;
            class_1799 itemStack;
            if (slotIndex >= screen.method_17577().field_7761.size() || (itemStack = (slot = (class_1735)screen.method_17577().field_7761.get(slotIndex)).method_7677()).method_7960()) continue;
            List<class_2561> lore = EquipmentDisplayUtility.getItemTooltip(itemStack, (class_1657)client.field_1724);
            boolean inStatistics = false;
            for (class_2561 text : lore) {
                String line = text.getString();
                Matcher armorMatcher = ARMOR_PATTERN.matcher(line);
                if (armorMatcher.find()) {
                    try {
                        double armorValue = Double.parseDouble(armorMatcher.group(1));
                        totalArmor += armorValue;
                    }
                    catch (NumberFormatException armorValue) {
                        // empty catch block
                    }
                }
                if (line.contains("Statistik")) {
                    inStatistics = true;
                    continue;
                }
                if (!inStatistics || !line.contains("+") && !line.contains("-")) continue;
                Map<String, Double> stats = EquipmentDisplayUtility.extractStatsFromLine(line);
                for (Map.Entry<String, Double> entry : stats.entrySet()) {
                    String statName = entry.getKey();
                    Double value = entry.getValue();
                    if (line.contains("%")) {
                        percentageStats.merge(statName, value, Double::sum);
                        continue;
                    }
                    absoluteStats.merge(statName, value, Double::sum);
                }
            }
        }
    }

    private static Map<String, Double> extractStatsFromLine(String line) {
        HashMap<String, Double> stats = new HashMap<String, Double>();
        Matcher matcher = STAT_PATTERN.matcher(line);
        while (matcher.find()) {
            String number = matcher.group(1);
            try {
                double value = Double.parseDouble(number);
                String statName = EquipmentDisplayUtility.extractStatName(line, matcher.start());
                if (statName == null || statName.isEmpty()) continue;
                stats.put(statName, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return stats;
    }

    private static String extractStatName(String line, int numberStart) {
        String afterNumber;
        String[] afterWords;
        String lineWithoutNumber = line.replaceAll("[+-]?\\d+(?:\\.\\d+)?%?", "").trim();
        lineWithoutNumber = lineWithoutNumber.replaceAll("(?i)\\b(statistik|bonus|malus|wert|erh\u00f6hung|reduzierung|zusatz|extra)\\b", "").trim();
        lineWithoutNumber = lineWithoutNumber.replaceAll("[^a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df\\s]", " ").trim();
        if (!(lineWithoutNumber = lineWithoutNumber.replaceAll("\\s+", " ").trim()).isEmpty()) {
            return lineWithoutNumber;
        }
        String beforeNumber = line.substring(0, numberStart).trim();
        String[] words = beforeNumber.split("\\s+");
        if (words.length > 0) {
            String lastWord = words[words.length - 1];
            if (!(lastWord = lastWord.replaceAll("[^a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df]", "")).isEmpty()) {
                return lastWord;
            }
        }
        if ((afterWords = (afterNumber = line.substring(numberStart).trim()).split("\\s+")).length > 0) {
            String firstWord = afterWords[0];
            if (!(firstWord = firstWord.replaceAll("[^a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df]", "")).isEmpty()) {
                return firstWord;
            }
        }
        return "Unbekannt";
    }

    private static void onHudRender(class_332 context, class_9779 tickCounter) {
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showEquipmentDisplay)) {
            return;
        }
        if (!isInEquipmentChest) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int inventoryWidth = 176;
        int inventoryHeight = 166;
        int inventoryX = (screenWidth - inventoryWidth) / 2;
        int inventoryY = (screenHeight - inventoryHeight) / 2;
        int baseOverlayWidth = 160;
        int overlayHeight = inventoryHeight + 55;
        int overlaySpacing = 5;
        int leftOverlayWidth = EquipmentDisplayUtility.calculateRequiredWidth(percentageStats, baseOverlayWidth, true);
        int rightOverlayWidth = EquipmentDisplayUtility.calculateRequiredWidth(absoluteStats, baseOverlayWidth, false);
        int leftOverlayX = inventoryX - leftOverlayWidth - overlaySpacing;
        int rightOverlayX = inventoryX + inventoryWidth + overlaySpacing;
        int overlayY = inventoryY - 28;
        int screenMargin = 5;
        if (leftOverlayX < screenMargin) {
            leftOverlayWidth = Math.min(leftOverlayWidth, inventoryX - overlaySpacing - screenMargin);
            leftOverlayX = inventoryX - leftOverlayWidth - overlaySpacing;
        }
        if (rightOverlayX + rightOverlayWidth > screenWidth - screenMargin) {
            rightOverlayWidth = Math.min(rightOverlayWidth, screenWidth - rightOverlayX - screenMargin);
        }
        if (overlayY < screenMargin) {
            overlayY = screenMargin;
        }
        if (overlayY + overlayHeight > screenHeight - screenMargin) {
            overlayY = screenHeight - overlayHeight - screenMargin;
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayShowBackground) {
            context.method_25294(leftOverlayX, overlayY, leftOverlayX + leftOverlayWidth, overlayY + overlayHeight, Integer.MIN_VALUE);
            context.method_25294(rightOverlayX, overlayY, rightOverlayX + rightOverlayWidth, overlayY + overlayHeight, Integer.MIN_VALUE);
        }
        if (showOverlays) {
            if (totalArmor > 0.0) {
                String armorText = String.format("R\u00fcstung: %s", EquipmentDisplayUtility.formatNumber(totalArmor));
                int armorTextWidth = client.field_1772.method_1727(armorText);
                int armorX = (screenWidth - armorTextWidth) / 2 + ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayArmorX;
                int armorY = screenHeight - ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayArmorY;
                int padding = 4;
                int armorOverlayWidth = armorTextWidth + padding * 2;
                int armorOverlayHeight = 12 + padding * 2;
                int armorOverlayX = armorX - padding;
                int armorOverlayY = armorY - padding;
                if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayShowBackground) {
                    context.method_25294(armorOverlayX, armorOverlayY, armorOverlayX + armorOverlayWidth, armorOverlayY + armorOverlayHeight, Integer.MIN_VALUE);
                }
                context.method_51433(client.field_1772, armorText, armorX, armorY, -1, true);
            }
            EquipmentDisplayUtility.drawStatsInOverlay(context, client.field_1772, percentageStats, leftOverlayX, overlayY, leftOverlayWidth, overlayHeight, true, leftScrollOffset);
            EquipmentDisplayUtility.drawStatsInOverlay(context, client.field_1772, absoluteStats, rightOverlayX, overlayY, rightOverlayWidth, overlayHeight, false, rightScrollOffset);
        }
    }

    private static String formatNumber(double value) {
        if (value == (double)((int)value)) {
            return String.valueOf((int)value);
        }
        return String.format("%.1f", value);
    }

    private static int calculateRequiredWidth(Map<String, Double> stats, int baseWidth, boolean isPercentage) {
        if (stats.isEmpty()) {
            return baseWidth;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return baseWidth;
        }
        class_327 textRenderer = client.field_1772;
        int maxTextWidth = 0;
        for (Map.Entry<String, Double> entry : stats.entrySet()) {
            double value = entry.getValue();
            Object formattedValue = EquipmentDisplayUtility.formatNumber(value);
            if (value > 0.0) {
                formattedValue = "+" + (String)formattedValue;
            }
            String text = isPercentage ? String.format("%s%% %s", formattedValue, entry.getKey()) : String.format("%s %s", formattedValue, entry.getKey());
            text = EquipmentDisplayUtility.truncateText(text, 40);
            int textWidth = textRenderer.method_1727(text);
            maxTextWidth = Math.max(maxTextWidth, textWidth);
        }
        String header = isPercentage ? "Prozentwerte" : "Flatwerte";
        header = EquipmentDisplayUtility.truncateText(header, 40);
        int headerWidth = textRenderer.method_1727(header);
        maxTextWidth = Math.max(maxTextWidth, headerWidth);
        int requiredWidth = maxTextWidth + 3;
        return Math.max(requiredWidth, baseWidth);
    }

    private static void drawStatsInOverlay(class_332 context, class_327 textRenderer, Map<String, Double> stats, int overlayX, int overlayY, int overlayWidth, int overlayHeight, boolean isPercentage, int scrollOffset) {
        int textX = overlayX + 3;
        int yOffset = overlayY + 5;
        int maxY = overlayY + overlayHeight - 10;
        if (overlayWidth < 80) {
            context.method_51433(textRenderer, "Zu schmal", textX, yOffset, -65536, true);
            return;
        }
        String header = isPercentage ? "Prozentwerte" : "Flatwerte";
        int headerColor = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayHeaderColor.getRGB();
        context.method_51433(textRenderer, header, textX, yOffset, headerColor, true);
        yOffset += 15;
        int totalEntries = stats.size();
        if (totalEntries > 0) {
            ArrayList<Map.Entry<String, Double>> entriesList = new ArrayList<Map.Entry<String, Double>>(stats.entrySet());
            int startIndex = scrollOffset / 12;
            int baseVisibleEntries = (overlayHeight - 50) / 12;
            int maxVisibleEntries = baseVisibleEntries + (startIndex == 0 ? 1 : 0);
            if (startIndex > 0) {
                String moreText = String.format("\u2191 %d weitere (Scrollen)", startIndex);
                context.method_51433(textRenderer, moreText, textX, yOffset, -2130706433, true);
                yOffset += 12;
            }
            int currentIndex = startIndex;
            for (int visibleCount = 0; currentIndex < totalEntries && visibleCount < maxVisibleEntries && yOffset < maxY; yOffset += 12, ++currentIndex, ++visibleCount) {
                Map.Entry entry = (Map.Entry)entriesList.get(currentIndex);
                EquipmentDisplayUtility.drawStatEntrySimple(context, textRenderer, entry, textX, yOffset, isPercentage);
            }
            if (currentIndex < totalEntries) {
                String moreText = String.format("\u2193 %d weitere (Scrollen)", totalEntries - currentIndex);
                context.method_51433(textRenderer, moreText, textX, yOffset, -2130706433, true);
            }
        }
    }

    private static String truncateText(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength - 3) + "...";
    }

    private static void drawStatEntrySimple(class_332 context, class_327 textRenderer, Map.Entry<String, Double> entry, int x, int y, boolean isPercentage) {
        Object text;
        double value = entry.getValue();
        Object formattedValue = EquipmentDisplayUtility.formatNumber(value);
        if (!isPercentage && value > 0.0) {
            formattedValue = "+" + (String)formattedValue;
        }
        Object object = text = isPercentage ? String.format("%s%% %s", formattedValue, entry.getKey()) : String.format("%s %s", formattedValue, entry.getKey());
        if (((String)text).length() >= 40) {
            text = ((String)text).substring(0, 37) + "...";
        }
        int textColor = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayTextColor.getRGB();
        context.method_51433(textRenderer, (String)text, x, y, textColor, true);
    }

    private static List<class_2561> getItemTooltip(class_1799 itemStack, class_1657 player) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add(itemStack.method_7964());
        class_9290 loreComponent = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (loreComponent != null) {
            tooltip.addAll(loreComponent.comp_2400());
        }
        return tooltip;
    }
}

