/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.ActionBarData;
import net.felix.utilities.EquipmentDisplayUtility;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5348;
import net.minecraft.class_9779;

public class MaterialTrackerUtility {
    private static boolean isInitialized = false;
    private static boolean isTrackingMaterials = false;
    private static boolean showOverlays = true;
    private static class_304 toggleKeyBinding;
    private static final int LINE_HEIGHT = 13;
    private static final int OVERLAY_WIDTH = 128;
    private static final int OVERLAY_HEIGHT = 96;
    private static final int TEXT_PADDING = 15;
    private static final int MIN_TEXT_WIDTH = 100;

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        try {
            MaterialTrackerUtility.registerHotkey();
            ClientTickEvents.END_CLIENT_TICK.register(MaterialTrackerUtility::onClientTick);
            HudRenderCallback.EVENT.register((drawContext, tickDelta) -> MaterialTrackerUtility.onHudRender(drawContext, tickDelta));
            isInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void registerHotkey() {
        toggleKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.cclive-utilities.material-toggle", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.cclive-utilities.material"));
    }

    private static void onClientTick(class_310 client) {
        MaterialTrackerUtility.checkTabKey();
        MaterialTrackerUtility.handleHotkey();
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showMaterialTracker)) {
            return;
        }
        if (client.field_1724 == null) {
            isTrackingMaterials = false;
            return;
        }
        ActionBarData.checkDimensionChange();
        boolean hasMaterials = ActionBarData.hasMaterials();
        if (hasMaterials != isTrackingMaterials) {
            isTrackingMaterials = hasMaterials;
        }
    }

    private static void checkTabKey() {
        showOverlays = !class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)258);
    }

    private static void handleHotkey() {
        if (toggleKeyBinding != null && toggleKeyBinding.method_1436()) {
            boolean currentShow = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showMaterialTracker;
            ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showMaterialTracker = !currentShow;
            CCLiveUtilitiesConfig.HANDLER.save();
        }
    }

    private static void onHudRender(class_332 context, class_9779 tickCounter) {
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showMaterialTracker)) {
            return;
        }
        if (!isTrackingMaterials) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (showOverlays && !EquipmentDisplayUtility.isEquipmentOverlayActive()) {
            MaterialTrackerUtility.renderMaterialDisplay(context, client);
        }
    }

    private static void renderMaterialDisplay(class_332 context, class_310 client) {
        if (client.method_22683() == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int xOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerX;
        int yOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerY;
        int xPosition = screenWidth - 128 - xOffset;
        int yPosition = yOffset;
        List<Object> texts = ActionBarData.getFilteredTexts();
        int dynamicWidth = MaterialTrackerUtility.calculateRequiredWidth(context, texts);
        int actualOverlayWidth = Math.max(128, dynamicWidth);
        int adjustedXPosition = xPosition - (actualOverlayWidth - 128);
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerShowBackground) {
            context.method_25294(adjustedXPosition, yPosition, adjustedXPosition + actualOverlayWidth, yPosition + 96 - 23, Integer.MIN_VALUE);
        }
        int currentY = yPosition + 15;
        for (Object textObj : texts) {
            Object textComponent = textObj instanceof class_2561 ? (class_2561)textObj : class_2561.method_43470((String)textObj.toString());
            context.method_51439(class_310.method_1551().field_1772, textComponent, adjustedXPosition + 2, currentY - 8, -1, true);
            currentY += 13;
        }
    }

    private static int calculateRequiredWidth(class_332 context, List<Object> texts) {
        int maxWidth = 100;
        for (Object textObj : texts) {
            Object textComponent = textObj instanceof class_2561 ? (class_2561)textObj : class_2561.method_43470((String)textObj.toString());
            int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)textComponent);
            int totalWidth = textWidth + 15;
            maxWidth = Math.max(maxWidth, totalWidth);
        }
        return maxWidth;
    }
}

