/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.felix.CCLiveUtilitiesConfig;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class AnimationBlockerUtility {
    private static boolean isInitialized = false;
    private static boolean animationBlockingEnabled = false;
    private static final Set<String> EPIC_DROPS_CHARACTERS = new HashSet<String>();
    private static final Set<String> LEGENDARY_DROPS_CHARACTERS = new HashSet<String>();
    private static final Set<String> LOGGING_LEVEL_UP_CHARACTERS = new HashSet<String>();
    private static final Set<String> MOBLEXICON_CHARACTERS = new HashSet<String>();
    private static final Set<String> MINING_LEVEL_UP_CHARACTERS = new HashSet<String>();
    private static final Set<String> AIRSHIP_CHARACTERS = new HashSet<String>();
    private static final Set<String> BLOCKED_CHARACTERS = new HashSet<String>();

    private static void addCharactersFromString(String charString, Set<String> targetSet) {
        for (int i = 0; i < charString.length(); ++i) {
            String singleChar = String.valueOf(charString.charAt(i));
            targetSet.add(singleChar);
        }
    }

    private static void updateBlockedCharacters() {
        BLOCKED_CHARACTERS.clear();
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).epicDropsBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(EPIC_DROPS_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).legendaryDropsBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(LEGENDARY_DROPS_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).loggingLevelUpBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(LOGGING_LEVEL_UP_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).moblexiconBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(MOBLEXICON_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).miningLevelUpBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(MINING_LEVEL_UP_CHARACTERS);
        }
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).airshipBlockingEnabled) {
            BLOCKED_CHARACTERS.addAll(AIRSHIP_CHARACTERS);
        }
    }

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        try {
            ClientTickEvents.END_CLIENT_TICK.register(AnimationBlockerUtility::onClientTick);
            ClientReceiveMessageEvents.GAME.register(AnimationBlockerUtility::onGameMessage);
            isInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void onGameMessage(class_2561 message, boolean overlay) {
        if (!animationBlockingEnabled) {
            return;
        }
        if (message == null) {
            return;
        }
        String messageString = message.getString();
        if (messageString.trim().isEmpty()) {
            return;
        }
        boolean foundBlockedChar = false;
        for (int i = 0; i < messageString.length(); ++i) {
            String messageChar = String.valueOf(messageString.charAt(i));
            if (!BLOCKED_CHARACTERS.contains(messageChar)) continue;
            foundBlockedChar = true;
            break;
        }
        if (foundBlockedChar) {
            return;
        }
    }

    private static void onClientTick(class_310 client) {
        AnimationBlockerUtility.updateBlockedCharacters();
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod || !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).animationBlockerEnabled) {
            animationBlockingEnabled = false;
            return;
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            animationBlockingEnabled = false;
            return;
        }
        animationBlockingEnabled = true;
    }

    public static void reset() {
        animationBlockingEnabled = false;
    }

    public static boolean isAnimationBlockingEnabled() {
        return animationBlockingEnabled;
    }

    public static Set<String> getBlockedCharacters() {
        return new HashSet<String>(BLOCKED_CHARACTERS);
    }

    static {
        AnimationBlockerUtility.addCharactersFromString("\u3a6b\u3a6c\u3a6d\u3a6e\u3a6f\u3a70\u3a71\u3a72", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a73\u3a74\u3a75\u3a76\u3a77\u3a78\u3a79\u3a7a", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a7b\u3a7c\u3a7d\u3a7e\u3a7f\u3a80\u3a81\u3a82", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a5b\u3a5c\u3a5d\u3a5e\u3a5f\u3a60\u3a61\u3a62", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a63\u3a64\u3a65\u3a66\u3a67\u3a68\u3a69\u3a6a", EPIC_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a43\u3a44\u3a45\u3a46\u3a47\u3a48\u3a49\u3a4a", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a4b\u3a4c\u3a4d\u3a4e\u3a4f\u3a50\u3a51\u3a52", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a53\u3a54\u3a55\u3a56\u3a57\u3a58\u3a59\u3a5a", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a7d\u3a7e\u3a7f\u3a80\u3a81\u3a82\u3a83\u3a84", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3a85\u3a86\u3a87\u3a88\u3a89\u3a8a\u3a8b\u3a8c", LEGENDARY_DROPS_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3aa2\u3aa3\u3aa4\u3aa5", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3aa6\u3aa7\u3aa8\u3aa9", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3aaa\u3aab\u3aac\u3aad", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3aae\u3aaf\u3ab0\u3ab1", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ab2\u3ab3\u3ab4\u3ab5", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ab6\u3ab7\u3ab8\u3ab9", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3aba\u3abb\u3abc\u3abd", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3abe\u3abf\u3ac0\u3ac1", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ac2\u3ac3\u3ac4\u3ac5", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ac6\u3ac7\u3ac8\u3ac9", LOGGING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3504\u34fe", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b0a\u3b0b\u3b0c\u3b0d\u3b0e\u3b0f", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b10\u3b11\u3b12\u3b13\u3b14\u3b15", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b16\u3b17\u3b18\u3b19\u3b1a\u3b1b", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b1c\u3b1d\u3b1e\u3b1f\u3b20\u3b21", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b22\u3b23\u3b24\u3b25\u3b26\u3b27", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b28\u3b29\u3b2a\u3b2b\u3b2c\u3b2d", MOBLEXICON_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ad9\u3ada\u3adb\u3adc", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3add\u3ade\u3adf\u3ae0", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ae1\u3ae2\u3ae3\u3ae4", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ae5\u3ae6\u3ae7\u3ae8", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3ae9\u3aea\u3aeb\u3aec", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3aed\u3aee\u3aef\u3af0", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3af1\u3af2\u3af3\u3af4", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3af5\u3af6\u3af7\u3af8", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3af9\u3afa\u3afb\u3afc", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3afd\u3afe\u3aff\u3b00", MINING_LEVEL_UP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b48\u3b49\u3b4a\u3b4b\u3b4c\u3b4d\u3b4e", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b4f\u3b50\u3b51\u3b52\u3b53\u3b54\u3b55", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b56\u3b57\u3b58\u3b59\u3b5a\u3b5b\u3b5c", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b5d\u3b5e\u3b5f\u3b60\u3b61\u3b62\u3b63", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b64\u3b65\u3b66\u3b67\u3b68\u3b69\u3b6a", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b6b\u3b6c\u3b6d\u3b6e\u3b6f\u3b70\u3b71", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b72\u3b73\u3b74\u3b75\u3b76\u3b77\u3b78", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.addCharactersFromString("\u3b79\u3b7a\u3b7b\u3b7c\u3b7d\u3b7e\u3b7f", AIRSHIP_CHARACTERS);
        AnimationBlockerUtility.updateBlockedCharacters();
    }
}

