/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.felix.CCLiveUtilitiesConfig;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import org.joml.Matrix3x2fStack;

public class AspectOverlay {
    private static boolean shouldShow = false;
    private static boolean isCurrentlyHovering = false;
    private static String currentAspectName = "";
    private static String currentAspectDescription = "";
    private static String currentItemName = "";
    private static Map<String, AspectInfo> aspectsDatabase = new HashMap<String, AspectInfo>();
    private static final String ASPECTS_CONFIG_FILE = "assets/cclive-utilities/Aspekte.json";

    public static void initialize() {
        AspectOverlay.loadAspectsDatabase();
    }

    public static void updateAspectInfo(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            shouldShow = false;
            isCurrentlyHovering = false;
            currentAspectName = "";
            currentAspectDescription = "";
            currentItemName = "";
            return;
        }
        String itemName = AspectOverlay.getItemName(itemStack);
        if (itemName == null || !itemName.contains("[Bauplan]")) {
            shouldShow = false;
            isCurrentlyHovering = false;
            currentAspectName = "";
            currentAspectDescription = "";
            currentItemName = "";
            return;
        }
        String cleanItemName = itemName.substring(0, itemName.indexOf("[Bauplan]")).trim();
        if (cleanItemName.startsWith("-")) {
            cleanItemName = cleanItemName.substring(1).trim();
        }
        if (cleanItemName.endsWith("-")) {
            cleanItemName = cleanItemName.substring(0, cleanItemName.length() - 1).trim();
        }
        cleanItemName = cleanItemName.replaceAll("\u00a7[0-9a-fk-or]", "");
        cleanItemName = cleanItemName.replaceAll("[\\u3400-\\u4DBF]", "");
        AspectInfo aspectInfo = aspectsDatabase.get(cleanItemName = cleanItemName.replaceAll("[^a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\\s-]", "").trim());
        if (aspectInfo != null) {
            currentAspectName = aspectInfo.aspectName;
            currentAspectDescription = aspectInfo.aspectDescription;
            currentItemName = cleanItemName;
            isCurrentlyHovering = true;
        } else {
            shouldShow = false;
            isCurrentlyHovering = false;
            currentAspectName = "";
            currentAspectDescription = "";
            currentItemName = "";
        }
    }

    public static void hideOverlay() {
        shouldShow = false;
        isCurrentlyHovering = false;
        currentAspectName = "";
        currentAspectDescription = "";
        currentItemName = "";
    }

    public static void onHoverStopped() {
        isCurrentlyHovering = false;
    }

    public static void updateFromBlueprintName(String blueprintName) {
        if (blueprintName == null || !blueprintName.contains("[Bauplan]")) {
            shouldShow = false;
            isCurrentlyHovering = false;
            currentAspectName = "";
            currentAspectDescription = "";
            currentItemName = "";
            return;
        }
        String cleanItemName = blueprintName.substring(0, blueprintName.indexOf("[Bauplan]")).trim();
        if (cleanItemName.startsWith("-")) {
            cleanItemName = cleanItemName.substring(1).trim();
        }
        if (cleanItemName.endsWith("-")) {
            cleanItemName = cleanItemName.substring(0, cleanItemName.length() - 1).trim();
        }
        cleanItemName = cleanItemName.replaceAll("\u00a7[0-9a-fk-or]", "");
        cleanItemName = cleanItemName.replaceAll("[\\u3400-\\u4DBF]", "");
        AspectInfo aspectInfo = aspectsDatabase.get(cleanItemName = cleanItemName.replaceAll("[^a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\\s-]", "").trim());
        if (aspectInfo != null) {
            currentAspectName = aspectInfo.aspectName;
            currentAspectDescription = aspectInfo.aspectDescription;
            currentItemName = cleanItemName;
            isCurrentlyHovering = true;
        } else {
            shouldShow = false;
            isCurrentlyHovering = false;
            currentAspectName = "";
            currentAspectDescription = "";
            currentItemName = "";
        }
    }

    private static String getItemName(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return null;
        }
        class_2561 displayName = itemStack.method_7964();
        if (displayName != null) {
            return displayName.getString();
        }
        return null;
    }

    public static void render(class_332 context) {
        boolean isShiftPressed;
        if (currentAspectName.isEmpty() || currentItemName.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1772 == null) {
            return;
        }
        boolean bl = isShiftPressed = class_3675.method_15987((long)client.method_22683().method_4490(), (int)340) || class_3675.method_15987((long)client.method_22683().method_4490(), (int)344);
        if (!isShiftPressed) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int overlayWidth = 300;
        int overlayHeight = 150;
        int overlayX = 15;
        int overlayY = (screenHeight - overlayHeight) / 2;
        context.method_25294(overlayX, overlayY, overlayX + overlayWidth, overlayY + overlayHeight, -872415232);
        context.method_25294(overlayX, overlayY, overlayX + 2, overlayY + overlayHeight, -256);
        context.method_25294(overlayX + overlayWidth - 2, overlayY, overlayX + overlayWidth, overlayY + overlayHeight, -256);
        context.method_25294(overlayX, overlayY, overlayX + overlayWidth, overlayY + 2, -256);
        context.method_25294(overlayX, overlayY + overlayHeight - 2, overlayX + overlayWidth, overlayY + overlayHeight, -256);
        context.method_25294(overlayX, overlayY, overlayX + overlayWidth, overlayY + 30, -855648512);
        try {
            class_5250 titleText = class_2561.method_43470((String)"Aspekt Information");
            class_5250 itemText = class_2561.method_43470((String)("Item: " + currentItemName));
            class_5250 aspectText = class_2561.method_43470((String)("Aspekt: " + currentAspectName));
            class_5250 instructionText = class_2561.method_43470((String)"Halte SHIFT gedr\u00fcckt");
            context.method_51439(client.field_1772, (class_2561)titleText, overlayX + 10, overlayY + 8, -1, false);
            context.method_51439(client.field_1772, (class_2561)itemText, overlayX + 10, overlayY + 40, -1, false);
            context.method_51439(client.field_1772, (class_2561)aspectText, overlayX + 10, overlayY + 60, 0xFF00FF, false);
            String[] descriptionLines = AspectOverlay.wrapText(currentAspectDescription, 40);
            for (int i = 0; i < descriptionLines.length; ++i) {
                class_5250 descText = class_2561.method_43470((String)descriptionLines[i]);
                context.method_51439(client.field_1772, (class_2561)descText, overlayX + 10, overlayY + 85 + i * 14, -1, false);
            }
            context.method_51439(client.field_1772, (class_2561)instructionText, overlayX + 10, overlayY + overlayHeight - 20, -1, false);
        }
        catch (Exception e) {
            System.err.println("Error rendering text: " + e.getMessage());
            e.printStackTrace();
            try {
                context.method_51433(client.field_1772, "Aspekt Information", overlayX + 10, overlayY + 8, -1, false);
                context.method_51433(client.field_1772, "Item: " + currentItemName, overlayX + 10, overlayY + 40, -1, false);
                context.method_51433(client.field_1772, "Aspekt: " + currentAspectName, overlayX + 10, overlayY + 60, 0xFF00FF, false);
            }
            catch (Exception e2) {
                System.err.println("Fallback text rendering also failed: " + e2.getMessage());
            }
        }
        try {
            context.method_51433(client.field_1772, "TEST TEXT VISIBLE", overlayX + 10, overlayY + 100, 0xFF0000, false);
        }
        catch (Exception e) {
            System.err.println("Alternative text rendering failed: " + e.getMessage());
        }
    }

    public static void renderForeground(class_332 context) {
        boolean isShiftPressed;
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).aspectOverlayEnabled || !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showAspectOverlay) {
            return;
        }
        if (currentAspectName.isEmpty() || currentItemName.isEmpty() || !isCurrentlyHovering) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1772 == null) {
            return;
        }
        boolean bl = isShiftPressed = class_3675.method_15987((long)client.method_22683().method_4490(), (int)340) || class_3675.method_15987((long)client.method_22683().method_4490(), (int)344);
        if (!isShiftPressed) {
            return;
        }
        if (!isCurrentlyHovering) {
            return;
        }
        int configX = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).aspectOverlayX;
        int configY = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).aspectOverlayY;
        boolean showBackground = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).aspectOverlayShowBackground;
        float overlayScale = 1.0f;
        if (overlayScale <= 0.0f) {
            overlayScale = 1.0f;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int baseOverlayWidth = 210;
        String[] descriptionLines = AspectOverlay.wrapText(currentAspectDescription, 30);
        int descriptionHeight = descriptionLines.length * 12;
        int baseHeight = 45;
        int baseOverlayHeight = baseHeight + descriptionHeight;
        baseOverlayHeight = Math.max(baseOverlayHeight, 110);
        int overlayWidth = baseOverlayWidth;
        int overlayHeight = baseOverlayHeight;
        int overlayX = screenWidth - configX - overlayWidth;
        int overlayY = configY;
        if (configX == 0) {
            overlayX = screenWidth - overlayWidth;
        } else if (configX > 0) {
            overlayX = screenWidth - configX - overlayWidth;
        }
        if (overlayX + overlayWidth > screenWidth) {
            overlayX = screenWidth - overlayWidth;
        }
        if (overlayY < 0) {
            overlayY = 0;
        }
        if (overlayY + overlayHeight > screenHeight) {
            overlayY = screenHeight - overlayHeight;
        }
        int scaledWidth = (int)((float)overlayWidth * overlayScale);
        int scaledHeight = (int)((float)overlayHeight * overlayScale);
        int offsetX = (scaledWidth - overlayWidth) / 2;
        int offsetY = (scaledHeight - overlayHeight) / 2;
        if (showBackground) {
            context.method_25294(overlayX - offsetX, overlayY - offsetY, overlayX - offsetX + scaledWidth, overlayY - offsetY + scaledHeight, -872415232);
        }
        context.method_25294(overlayX - offsetX, overlayY - offsetY, overlayX - offsetX + 1, overlayY - offsetY + scaledHeight, -1);
        context.method_25294(overlayX - offsetX + scaledWidth - 1, overlayY - offsetY, overlayX - offsetX + scaledWidth, overlayY - offsetY + scaledHeight, -1);
        context.method_25294(overlayX - offsetX, overlayY - offsetY, overlayX - offsetX + scaledWidth, overlayY - offsetY + 1, -1);
        context.method_25294(overlayX - offsetX, overlayY - offsetY + scaledHeight - 1, overlayX - offsetX + scaledWidth, overlayY - offsetY + scaledHeight, -1);
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)(overlayX - offsetX), (float)(overlayY - offsetY));
        matrices.scale(overlayScale, overlayScale);
        context.method_51433(client.field_1772, currentAspectName, 10, 10, -219136, false);
        for (int i = 0; i < descriptionLines.length; ++i) {
            AspectOverlay.drawColoredText(context, client.field_1772, descriptionLines[i], 10, 35 + i * 12);
        }
        context.method_51433(client.field_1772, "Halte SHIFT gedr\u00fcckt", 10, overlayHeight - 15, 0xCCCCCC, false);
        matrices.popMatrix();
    }

    private static String[] wrapText(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return new String[]{text};
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxLength) {
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString().trim());
                    currentLine = new StringBuilder(word);
                    continue;
                }
                if (word.length() > maxLength) {
                    int remainingLength;
                    for (remainingLength = maxLength; remainingLength < word.length(); remainingLength += maxLength) {
                        lines.add(word.substring(remainingLength - maxLength, remainingLength));
                    }
                    if (remainingLength - maxLength >= word.length()) continue;
                    currentLine = new StringBuilder(word.substring(remainingLength - maxLength));
                    continue;
                }
                lines.add(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString().trim());
        }
        return lines.toArray(new String[0]);
    }

    private static void loadAspectsDatabase() {
        try {
            Path resource = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("cclive-utilities").orElseThrow(() -> new RuntimeException("Mod container not found"))).findPath(ASPECTS_CONFIG_FILE).orElseThrow(() -> new RuntimeException("Aspects config file not found"));
            try (InputStream inputStream = Files.newInputStream(resource, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                int loadedCount = 0;
                for (String itemName : json.keySet()) {
                    try {
                        JsonObject itemData = json.getAsJsonObject(itemName);
                        String aspectName = itemData.get("aspect_name").getAsString();
                        String aspectDescription = itemData.get("aspect_description").getAsString();
                        if (aspectName.isEmpty() || aspectDescription.isEmpty()) continue;
                        aspectsDatabase.put(itemName, new AspectInfo(aspectName, aspectDescription));
                        ++loadedCount;
                    }
                    catch (Exception e) {
                        System.err.println("Failed to parse aspect data for item: " + itemName + " - " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load aspects database for overlay: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void drawColoredText(class_332 context, class_327 textRenderer, String text, int x, int y) {
        String[] words;
        int currentX = x;
        int mainColor = -11207596;
        int whiteColor = -1;
        String[] whiteWords = new String[]{"Block", "Bl\u00f6cke", "Bl\u00f6cken", "Sekunde", "Sekunden"};
        for (String word : words = text.split(" ")) {
            boolean isWhiteWord = false;
            for (String whiteWord : whiteWords) {
                if (!word.equals(whiteWord)) continue;
                isWhiteWord = true;
                break;
            }
            if (isWhiteWord) {
                context.method_51433(textRenderer, word, currentX, y, whiteColor, false);
                currentX += textRenderer.method_1727(word + " ");
                continue;
            }
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                String charStr = String.valueOf(c);
                boolean isSpecial = Character.isDigit(c) || c == '%' || c == '+' || c == '-' || c == '.' || c == ',' || c == ':' || c == '[' || c == ']';
                int charColor = isSpecial ? whiteColor : mainColor;
                context.method_51433(textRenderer, charStr, currentX, y, charColor, false);
                currentX += textRenderer.method_1727(charStr);
            }
            currentX += textRenderer.method_1727(" ");
        }
    }

    private static class AspectInfo {
        public final String aspectName;
        public final String aspectDescription;

        public AspectInfo(String aspectName, String aspectDescription) {
            this.aspectName = aspectName;
            this.aspectDescription = aspectDescription;
        }
    }
}

