/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities.DragOverlay;

import java.lang.reflect.Field;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.OverlayType;
import net.felix.utilities.BPViewerUtility;
import net.felix.utilities.DragOverlay.DraggableOverlay;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class BlueprintViewerDraggableOverlay
implements DraggableOverlay {
    private static final int DEFAULT_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 100;
    private static final class_2960 BLUEPRINT_BACKGROUND_TEXTURE = class_2960.method_60655((String)"cclive-utilities", (String)"textures/gui/blueprint_background.png");

    @Override
    public String getOverlayName() {
        return "Blueprint Viewer";
    }

    @Override
    public int getX() {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return 0;
        }
        int screenWidth = client.method_22683().method_4486();
        int xOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerX;
        int dynamicWidth = this.getWidth();
        return screenWidth - dynamicWidth - xOffset;
    }

    @Override
    public int getY() {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return 0;
        }
        int screenHeight = client.method_22683().method_4502();
        int yPercent = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerY;
        int y = screenHeight * yPercent / 100;
        if (yPercent >= 90) {
            y = screenHeight - this.getHeight();
        }
        return Math.max(0, y);
    }

    @Override
    public int getWidth() {
        return this.calculateDynamicWidth();
    }

    @Override
    public int getHeight() {
        return this.calculateDynamicHeight();
    }

    @Override
    public void setPosition(int x, int y) {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int dynamicWidth = this.getWidth();
        int xOffset = screenWidth - dynamicWidth - x;
        int yPercent = Math.round((float)y * 100.0f / (float)screenHeight);
        yPercent = Math.max(0, Math.min(100, yPercent));
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerX = xOffset;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerY = yPercent;
    }

    @Override
    public void renderInEditMode(class_332 context, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        OverlayType overlayType = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerOverlayType;
        if (overlayType == OverlayType.CUSTOM) {
            try {
                context.method_25290(class_10799.field_56883, BLUEPRINT_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, width, height, width, height);
            }
            catch (Exception e) {
                context.method_25294(x, y, x + width, y + height, Integer.MIN_VALUE);
            }
        } else if (overlayType == OverlayType.BLACK) {
            context.method_25294(x, y, x + width, y + height, Integer.MIN_VALUE);
        }
        context.method_49601(x, y, width, height, -65536);
        context.method_51433(class_310.method_1551().field_1772, this.getOverlayName(), x + 5, y + 5, -1, true);
        this.renderBlueprintData(context, x, y, width, height);
    }

    @Override
    public void savePosition() {
    }

    @Override
    public boolean isEnabled() {
        return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showBlueprintViewer;
    }

    @Override
    public class_2561 getTooltip() {
        return class_2561.method_43470((String)"Blueprint Viewer - Shows blueprint information and materials");
    }

    @Override
    public void resetToDefault() {
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerX = 1;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerY = 2;
    }

    private int calculateDynamicWidth() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return 200;
        }
        try {
            BPViewerUtility instance = BPViewerUtility.getInstance();
            String activeFloor = instance.getActiveFloor();
            if (activeFloor == null) {
                return 200;
            }
            Field configField = BPViewerUtility.class.getDeclaredField("config");
            configField.setAccessible(true);
            BPViewerUtility.BlueprintConfig config = (BPViewerUtility.BlueprintConfig)configField.get(instance);
            BPViewerUtility.BlueprintConfig.FloorData floorData = config.getFloorData(activeFloor);
            if (floorData == null || floorData.blueprints == null) {
                return 200;
            }
            String currentRarity = this.getCurrentRarity();
            BPViewerUtility.BlueprintConfig.RarityData rarityData = floorData.blueprints.get(currentRarity);
            if (rarityData == null || rarityData.items == null) {
                return 200;
            }
            int maxWidth = 200;
            for (String blueprint : rarityData.items) {
                String displayText = blueprint.startsWith("- ") ? blueprint.substring(2) : blueprint;
                int textWidth = client.field_1772.method_1727(displayText);
                if ((textWidth += 45) <= maxWidth) continue;
                maxWidth = textWidth;
            }
            int baseWidth = maxWidth - 15;
            float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerScale;
            if (scale <= 0.0f) {
                scale = 1.0f;
            }
            return (int)((float)baseWidth * scale);
        }
        catch (Exception e) {
            return 200;
        }
    }

    private int calculateDynamicHeight() {
        try {
            BPViewerUtility instance = BPViewerUtility.getInstance();
            String activeFloor = instance.getActiveFloor();
            if (activeFloor == null) {
                return 100;
            }
            Field configField = BPViewerUtility.class.getDeclaredField("config");
            configField.setAccessible(true);
            BPViewerUtility.BlueprintConfig config = (BPViewerUtility.BlueprintConfig)configField.get(instance);
            BPViewerUtility.BlueprintConfig.FloorData floorData = config.getFloorData(activeFloor);
            if (floorData == null || floorData.blueprints == null) {
                return 100;
            }
            String currentRarity = this.getCurrentRarity();
            BPViewerUtility.BlueprintConfig.RarityData rarityData = floorData.blueprints.get(currentRarity);
            if (rarityData == null || rarityData.items == null) {
                return 100;
            }
            int baseHeight = 20;
            int blueprintHeight = rarityData.items.size() * 12;
            int bottomPadding = 5;
            int totalHeight = baseHeight + blueprintHeight + bottomPadding;
            float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blueprintViewerScale;
            if (scale <= 0.0f) {
                scale = 1.0f;
            }
            return (int)((float)totalHeight * scale);
        }
        catch (Exception e) {
            return 100;
        }
    }

    private String getCurrentRarity() {
        try {
            BPViewerUtility instance = BPViewerUtility.getInstance();
            Field field = BPViewerUtility.class.getDeclaredField("currentRarity");
            field.setAccessible(true);
            return (String)field.get(instance);
        }
        catch (Exception e) {
            return "common";
        }
    }

    private void renderBlueprintData(class_332 context, int x, int y, int width, int height) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        try {
            BPViewerUtility instance = BPViewerUtility.getInstance();
            String activeFloor = instance.getActiveFloor();
            if (activeFloor != null) {
                String currentRarity;
                BPViewerUtility.BlueprintConfig.RarityData rarityData;
                Field configField = BPViewerUtility.class.getDeclaredField("config");
                configField.setAccessible(true);
                BPViewerUtility.BlueprintConfig config = (BPViewerUtility.BlueprintConfig)configField.get(instance);
                BPViewerUtility.BlueprintConfig.FloorData floorData = config.getFloorData(activeFloor);
                if (floorData != null && floorData.blueprints != null && (rarityData = floorData.blueprints.get(currentRarity = this.getCurrentRarity())) != null && rarityData.items != null && !rarityData.items.isEmpty()) {
                    String rarityDisplay = currentRarity.toUpperCase();
                    context.method_51433(client.field_1772, rarityDisplay, x + 8, y + 20, this.getRarityColor(currentRarity), true);
                    int blueprintY = y + 25;
                    int count = 0;
                    int maxItems = Math.min(3, (height - 30) / 12);
                    for (String blueprint : rarityData.items) {
                        if (count >= maxItems) break;
                        Object displayText = blueprint.startsWith("- ") ? blueprint.substring(2) : blueprint;
                        int availableWidth = width - 16;
                        int textWidth = client.field_1772.method_1727((String)displayText);
                        if (textWidth > availableWidth) {
                            int maxChars = (int)((double)availableWidth / (double)textWidth * (double)((String)displayText).length());
                            displayText = maxChars > 3 ? ((String)displayText).substring(0, maxChars - 3) + "..." : "...";
                        }
                        context.method_51433(client.field_1772, (String)displayText, x + 8, blueprintY, -1, true);
                        blueprintY += 12;
                        ++count;
                    }
                    if (rarityData.items.size() > maxItems) {
                        context.method_51433(client.field_1772, "... and " + (rarityData.items.size() - maxItems) + " more", x + 8, blueprintY, -7829368, true);
                    }
                    return;
                }
            }
        }
        catch (Exception instance) {
            // empty catch block
        }
        context.method_51433(client.field_1772, "COMMON", x + 8, y + 5, -1, true);
        int blueprintY = y + 25;
        int maxItems = Math.min(3, (height - 30) / 12);
        if (maxItems >= 1) {
            Object text1 = "Anf\u00e4nger Hacke";
            int availableWidth = width - 16;
            int textWidth = client.field_1772.method_1727((String)text1);
            if (textWidth > availableWidth) {
                int maxChars = (int)((double)availableWidth / (double)textWidth * (double)((String)text1).length());
                text1 = maxChars > 3 ? ((String)text1).substring(0, maxChars - 3) + "..." : "...";
            }
            context.method_51433(client.field_1772, (String)text1, x + 8, blueprintY, -1, true);
            blueprintY += 12;
        }
        if (maxItems >= 2) {
            Object text2 = "Anf\u00e4nger Axt";
            int availableWidth = width - 16;
            int textWidth = client.field_1772.method_1727((String)text2);
            if (textWidth > availableWidth) {
                int maxChars = (int)((double)availableWidth / (double)textWidth * (double)((String)text2).length());
                text2 = maxChars > 3 ? ((String)text2).substring(0, maxChars - 3) + "..." : "...";
            }
            context.method_51433(client.field_1772, (String)text2, x + 8, blueprintY, -1, true);
            blueprintY += 12;
        }
        if (maxItems >= 3) {
            context.method_51433(client.field_1772, "... and more", x + 8, blueprintY, -7829368, true);
        }
    }

    private int getRarityColor(String rarity) {
        switch (rarity.toLowerCase()) {
            case "common": {
                return -1;
            }
            case "uncommon": {
                return -16711936;
            }
            case "rare": {
                return -16776961;
            }
            case "epic": {
                return -65281;
            }
            case "legendary": {
                return -256;
            }
        }
        return -1;
    }
}

