/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities.DragOverlay;

import java.lang.reflect.Field;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.OverlayType;
import net.felix.utilities.DragOverlay.DraggableOverlay;
import net.felix.utilities.EquipmentDisplayUtility;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class EquipmentDisplayDraggableOverlay
implements DraggableOverlay {
    private static final int DEFAULT_WIDTH = 80;

    @Override
    public String getOverlayName() {
        return "R\u00fcstungs Wert";
    }

    @Override
    public int getX() {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return 0;
        }
        int screenWidth = client.method_22683().method_4486();
        int xOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayArmorX;
        String armorText = String.format("R\u00fcstung: %s", this.formatNumber(this.getArmorValueFromEquipmentDisplay()));
        int armorTextWidth = client.field_1772.method_1727(armorText);
        int armorX = (screenWidth - armorTextWidth) / 2 + xOffset;
        return armorX;
    }

    @Override
    public int getY() {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return 0;
        }
        int screenHeight = client.method_22683().method_4502();
        int yOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayArmorY;
        int armorY = screenHeight - yOffset;
        return armorY;
    }

    @Override
    public int getWidth() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return 80;
        }
        String armorText = String.format("R\u00fcstung: %s", this.formatNumber(this.getArmorValueFromEquipmentDisplay()));
        int armorTextWidth = client.field_1772.method_1727(armorText);
        int padding = 4;
        return armorTextWidth + padding * 2;
    }

    @Override
    public int getHeight() {
        int textHeight = 12;
        int padding = 4;
        return textHeight + padding * 2;
    }

    @Override
    public void setPosition(int x, int y) {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        String armorText = String.format("R\u00fcstung: %s", this.formatNumber(this.getArmorValueFromEquipmentDisplay()));
        int armorTextWidth = client.field_1772.method_1727(armorText);
        int baseX = (screenWidth - armorTextWidth) / 2;
        int baseY = screenHeight;
        int xOffset = x - baseX;
        int yOffset = baseY - y;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayArmorX = xOffset;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayArmorY = yOffset;
    }

    @Override
    public void renderInEditMode(class_332 context, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        this.renderArmorDisplay(context, x, y);
        context.method_49601(x - 1, y - 1, width + 2, height + 2, -65536);
        context.method_51433(class_310.method_1551().field_1772, this.getOverlayName(), x + 2, y - 12, -1, true);
    }

    @Override
    public void savePosition() {
    }

    @Override
    public boolean isEnabled() {
        return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showEquipmentDisplay;
    }

    @Override
    public class_2561 getTooltip() {
        return class_2561.method_43470((String)"Equipment Display - Shows equipment statistics and armor values");
    }

    @Override
    public void resetToDefault() {
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayArmorX = -134;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayArmorY = 300;
    }

    private void renderArmorDisplay(class_332 context, int x, int y) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        double armorValue = this.getArmorValueFromEquipmentDisplay();
        String armorText = String.format("R\u00fcstung: %s", this.formatNumber(armorValue));
        OverlayType overlayType = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).equipmentDisplayOverlayType;
        if (overlayType != OverlayType.NONE) {
            context.method_25294(x, y, x + this.getWidth(), y + this.getHeight(), Integer.MIN_VALUE);
        }
        int padding = 4;
        context.method_51433(client.field_1772, armorText, x + padding, y + padding, -1, true);
    }

    private double getArmorValueFromEquipmentDisplay() {
        try {
            Field totalArmorField = EquipmentDisplayUtility.class.getDeclaredField("totalArmor");
            totalArmorField.setAccessible(true);
            return (Double)totalArmorField.get(null);
        }
        catch (Exception e) {
            return 100.0;
        }
    }

    private String formatNumber(double value) {
        if (value == (double)((int)value)) {
            return String.valueOf((int)value);
        }
        return String.format("%.1f", value);
    }
}

