/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities.DragOverlay;

import java.util.List;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.OverlayType;
import net.felix.utilities.ActionBarData;
import net.felix.utilities.DragOverlay.DraggableOverlay;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.joml.Matrix3x2fStack;

public class MaterialTrackerDraggableOverlay
implements DraggableOverlay {
    private static final int DEFAULT_WIDTH = 155;
    private static final int DEFAULT_HEIGHT = 103;
    private static final class_2960 MATERIALS_BACKGROUND_TEXTURE = class_2960.method_60655((String)"cclive-utilities", (String)"textures/gui/materials_background.png");

    @Override
    public String getOverlayName() {
        return "Material Tracker";
    }

    @Override
    public int getX() {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return 0;
        }
        int screenWidth = client.method_22683().method_4486();
        int xOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerX;
        int dynamicWidth = this.getWidth();
        return screenWidth - dynamicWidth - xOffset;
    }

    @Override
    public int getY() {
        return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerY;
    }

    @Override
    public int getWidth() {
        return this.calculateDynamicWidth();
    }

    @Override
    public int getHeight() {
        return this.calculateDynamicHeight();
    }

    @Override
    public void setPosition(int x, int y) {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int dynamicWidth = this.getWidth();
        int xOffset = screenWidth - dynamicWidth - x;
        int yOffset = y;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerX = xOffset;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerY = yOffset;
    }

    @Override
    public void renderInEditMode(class_332 context, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerScale;
        if (scale <= 0.0f) {
            scale = 1.0f;
        }
        matrices.translate((float)x, (float)y);
        matrices.scale(scale, scale);
        int unscaledWidth = (int)((float)width / scale);
        int unscaledHeight = (int)((float)height / scale);
        OverlayType overlayType = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerOverlayType;
        switch (overlayType) {
            case CUSTOM: {
                try {
                    context.method_25290(class_10799.field_56883, MATERIALS_BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, unscaledWidth, unscaledHeight, unscaledWidth, unscaledHeight);
                }
                catch (Exception e) {
                    context.method_25294(0, 0, unscaledWidth, unscaledHeight, Integer.MIN_VALUE);
                }
                break;
            }
            case BLACK: {
                context.method_25294(0, 0, unscaledWidth, unscaledHeight, Integer.MIN_VALUE);
                break;
            }
        }
        context.method_49601(0, 0, unscaledWidth, unscaledHeight, -65536);
        context.method_51433(class_310.method_1551().field_1772, this.getOverlayName(), 5, 5, -1, true);
        this.renderMaterialData(context, 0, 0, unscaledWidth, unscaledHeight);
        matrices.popMatrix();
    }

    @Override
    public void savePosition() {
    }

    @Override
    public boolean isEnabled() {
        return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showMaterialTracker;
    }

    @Override
    public class_2561 getTooltip() {
        return class_2561.method_43470((String)"Material Tracker - Shows collected materials from action bar");
    }

    @Override
    public void resetToDefault() {
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerX = 1;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerY = 35;
    }

    private void renderMaterialData(class_332 context, int x, int y, int width, int height) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        try {
            List<Object> materials = ActionBarData.getFilteredTexts();
            if (materials != null && !materials.isEmpty()) {
                int materialY = 20;
                int count = 0;
                for (Object materialObj : materials) {
                    if (count >= 3) break;
                    Object materialText = materialObj instanceof class_2561 ? ((class_2561)materialObj).getString() : materialObj.toString();
                    int availableWidth = width - 16;
                    int textWidth = client.field_1772.method_1727((String)materialText);
                    if (textWidth > availableWidth) {
                        int maxChars = (int)((double)availableWidth / (double)textWidth * (double)((String)materialText).length());
                        materialText = maxChars > 3 ? ((String)materialText).substring(0, maxChars - 3) + "..." : "...";
                    }
                    context.method_51433(client.field_1772, (String)materialText, 8, materialY, -1, true);
                    materialY += 12;
                    ++count;
                }
                if (materials.size() > 3) {
                    context.method_51433(client.field_1772, "... and " + (materials.size() - 3) + " more", 8, materialY, -7829368, true);
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        context.method_51433(client.field_1772, "Pr\u00e4chtiges Eselhaar [1067]", 8, 20, -1, true);
        context.method_51433(client.field_1772, "Goldener Drache [234]", 8, 32, -1, true);
        context.method_51433(client.field_1772, "Mystisches Holz [89]", 8, 44, -1, true);
    }

    private int calculateDynamicWidth() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return 155;
        }
        try {
            List<Object> texts = ActionBarData.getFilteredTexts();
            if (texts == null || texts.isEmpty()) {
                float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerScale;
                if (scale <= 0.0f) {
                    scale = 1.0f;
                }
                return (int)(155.0f * scale);
            }
            int dynamicWidth = this.calculateRequiredWidth(client, texts);
            float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerScale;
            if (scale <= 0.0f) {
                scale = 1.0f;
            }
            int baseWidth = Math.max(155, dynamicWidth);
            return (int)((float)baseWidth * scale);
        }
        catch (Exception e) {
            float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerScale;
            if (scale <= 0.0f) {
                scale = 1.0f;
            }
            return (int)(155.0f * scale);
        }
    }

    private int calculateRequiredWidth(class_310 client, List<Object> texts) {
        int maxWidth = 100;
        for (Object textObj : texts) {
            Object textComponent = textObj instanceof class_2561 ? (class_2561)textObj : class_2561.method_43470((String)textObj.toString());
            int textWidth = client.field_1772.method_27525((class_5348)textComponent);
            int totalWidth = textWidth + 15;
            maxWidth = Math.max(maxWidth, totalWidth);
        }
        return maxWidth;
    }

    private int calculateDynamicHeight() {
        try {
            List<Object> texts = ActionBarData.getFilteredTexts();
            if (texts == null || texts.isEmpty()) {
                float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerScale;
                if (scale <= 0.0f) {
                    scale = 1.0f;
                }
                return (int)(80.0f * scale);
            }
            int baseHeight = 20;
            int materialHeight = texts.size() * 13;
            int bottomPadding = 10;
            int totalHeight = baseHeight + materialHeight + bottomPadding;
            float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerScale;
            if (scale <= 0.0f) {
                scale = 1.0f;
            }
            return (int)((float)totalHeight * scale);
        }
        catch (Exception e) {
            float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerScale;
            if (scale <= 0.0f) {
                scale = 1.0f;
            }
            return (int)(80.0f * scale);
        }
    }
}

