/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities.DragOverlay;

import java.util.ArrayList;
import java.util.List;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.DragOverlay.AspectOverlayDraggableOverlay;
import net.felix.utilities.DragOverlay.BlueprintViewerDraggableOverlay;
import net.felix.utilities.DragOverlay.BossHPDraggableOverlay;
import net.felix.utilities.DragOverlay.CardsDraggableOverlay;
import net.felix.utilities.DragOverlay.DraggableOverlay;
import net.felix.utilities.DragOverlay.EquipmentDisplayDraggableOverlay;
import net.felix.utilities.DragOverlay.HideUncraftableButtonDraggableOverlay;
import net.felix.utilities.DragOverlay.KillsUtilityDraggableOverlay;
import net.felix.utilities.DragOverlay.MaterialTrackerDraggableOverlay;
import net.felix.utilities.DragOverlay.OverlayEditorUtility;
import net.felix.utilities.DragOverlay.StatuesDraggableOverlay;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_7842;

public class OverlayEditorScreen
extends class_437 {
    private final List<DraggableOverlay> overlays = new ArrayList<DraggableOverlay>();
    private DraggableOverlay draggingOverlay = null;
    private DraggableOverlay resizingOverlay = null;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private int resizeStartX = 0;
    private int resizeStartY = 0;
    private int resizeStartWidth = 0;
    private int resizeStartHeight = 0;
    private class_4185 doneButton;
    private class_4185 resetButton;
    private class_7842 titleWidget;
    private class_437 previousScreen;

    public OverlayEditorScreen() {
        super((class_2561)class_2561.method_43470((String)"Overlay Editor"));
        this.previousScreen = class_310.method_1551().field_1755;
        this.initializeOverlays();
    }

    private void initializeOverlays() {
        boolean isInBlueprintInventory = this.isInInventoryScreen();
        if (this.isInPlayerNameDimension()) {
            this.overlays.add(new BossHPDraggableOverlay());
        }
        if (isInBlueprintInventory) {
            this.overlays.add(new AspectOverlayDraggableOverlay());
            this.overlays.add(new HideUncraftableButtonDraggableOverlay());
        } else {
            boolean isInFloorDimension = this.isInFloorDimension();
            if (isInFloorDimension) {
                this.overlays.add(new CardsDraggableOverlay());
                this.overlays.add(new StatuesDraggableOverlay());
                this.overlays.add(new BlueprintViewerDraggableOverlay());
                this.overlays.add(new MaterialTrackerDraggableOverlay());
                this.overlays.add(new KillsUtilityDraggableOverlay());
            } else {
                boolean isInEquipmentChest = this.isInEquipmentChestInventory();
                if (isInEquipmentChest) {
                    this.overlays.add(new EquipmentDisplayDraggableOverlay());
                }
            }
        }
    }

    private boolean isInInventoryScreen() {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1755 == null) {
            return false;
        }
        if (!(client.field_1755 instanceof class_465)) {
            return false;
        }
        class_465 handledScreen = (class_465)client.field_1755;
        String title = handledScreen.method_25440().getString();
        String cleanTitle = title.replaceAll("\u00a7[0-9a-fk-or]", "").replaceAll("[\\u3400-\\u4DBF]", "");
        return cleanTitle.contains("Baupl\u00e4ne [Waffen]") || cleanTitle.contains("Baupl\u00e4ne [R\u00fcstung]") || cleanTitle.contains("Baupl\u00e4ne [Werkzeuge]") || cleanTitle.contains("Bauplan [Shop]") || cleanTitle.contains("Favorisierte [R\u00fcstungsbaupl\u00e4ne]") || cleanTitle.contains("Favorisierte [Waffenbaupl\u00e4ne]") || cleanTitle.contains("Favorisierte [Werkzeugbaupl\u00e4ne]") || cleanTitle.contains("Favorisierte [Shop-Baupl\u00e4ne]");
    }

    private boolean isInEquipmentChestInventory() {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1755 == null) {
            return false;
        }
        if (!(client.field_1755 instanceof class_465)) {
            return false;
        }
        class_465 handledScreen = (class_465)client.field_1755;
        String title = handledScreen.method_25440().getString();
        return title.contains("\u3b03") || title.contains("\u3b04") || title.contains("\u3b05") || title.contains("\u3b06");
    }

    private boolean isInFloorDimension() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        String dimensionId = client.field_1687.method_27983().method_29177().toString();
        return dimensionId.contains("floor") || dimensionId.contains("dungeon");
    }

    protected void method_25426() {
        super.method_25426();
        this.titleWidget = new class_7842((class_2561)class_2561.method_43470((String)"Overlay Editor - Drag & Drop to reposition overlays"), this.field_22793);
        this.titleWidget.method_48229(this.field_22789 / 2 - this.titleWidget.method_25368() / 2, 20);
        this.method_37063((class_364)this.titleWidget);
        this.doneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 30, 80, 20).method_46431();
        this.method_37063((class_364)this.doneButton);
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset All"), button -> this.resetAllOverlays()).method_46434(this.field_22789 / 2 + 20, this.field_22790 - 30, 80, 20).method_46431();
        this.method_37063((class_364)this.resetButton);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.previousScreen != null) {
            this.previousScreen.method_25394(context, mouseX, mouseY, delta);
        }
        context.method_25294(0, 0, this.field_22789, this.field_22790, 0x20000000);
        this.titleWidget.method_25394(context, mouseX, mouseY, delta);
        for (DraggableOverlay overlay : this.overlays) {
            if (!overlay.isEnabled()) continue;
            overlay.renderInEditMode(context, mouseX, mouseY, delta);
            if (!overlay.isResizeArea(mouseX, mouseY)) continue;
            this.renderResizeHandle(context, overlay);
        }
        this.renderInstructions(context);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void renderResizeHandle(class_332 context, DraggableOverlay overlay) {
        int handleSize = 8;
        int x = overlay.getX() + overlay.getWidth() - handleSize;
        int y = overlay.getY() + overlay.getHeight() - handleSize;
        context.method_25294(x, y, x + handleSize, y + handleSize, -1);
        context.method_25294(x + 1, y + 1, x + handleSize - 1, y + handleSize - 1, -16777216);
    }

    private void renderInstructions(class_332 context) {
        String[] instructions;
        int y = this.field_22790 - 80;
        for (String instruction : instructions = new String[]{"Left Click + Drag: Move overlay", "ESC: Close editor"}) {
            context.method_51433(this.field_22793, instruction, 10, y, -1, false);
            y += 12;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (DraggableOverlay overlay : this.overlays) {
                if (!overlay.isEnabled() || !overlay.isResizeArea((int)mouseX, (int)mouseY)) continue;
                this.resizingOverlay = overlay;
                this.resizeStartX = (int)mouseX;
                this.resizeStartY = (int)mouseY;
                this.resizeStartWidth = overlay.getWidth();
                this.resizeStartHeight = overlay.getHeight();
                return true;
            }
            for (DraggableOverlay overlay : this.overlays) {
                if (!overlay.isEnabled() || !overlay.isHovered((int)mouseX, (int)mouseY)) continue;
                this.draggingOverlay = overlay;
                this.dragOffsetX = (int)mouseX - overlay.getX();
                this.dragOffsetY = (int)mouseY - overlay.getY();
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            if (this.draggingOverlay != null) {
                int newX = (int)mouseX - this.dragOffsetX;
                int newY = (int)mouseY - this.dragOffsetY;
                newX = Math.max(0, Math.min(newX, this.field_22789 - this.draggingOverlay.getWidth()));
                newY = Math.max(0, Math.min(newY, this.field_22790 - this.draggingOverlay.getHeight()));
                this.draggingOverlay.setPosition(newX, newY);
                this.draggingOverlay.savePosition();
                return true;
            }
            if (this.resizingOverlay != null) {
                int deltaWidth = (int)mouseX - this.resizeStartX;
                int deltaHeight = (int)mouseY - this.resizeStartY;
                int newWidth = Math.max(50, this.resizeStartWidth + deltaWidth);
                int newHeight = Math.max(20, this.resizeStartHeight + deltaHeight);
                this.resizingOverlay.setSize(newWidth, newHeight);
                this.resizingOverlay.savePosition();
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.draggingOverlay != null) {
                this.draggingOverlay.savePosition();
                this.draggingOverlay = null;
                return true;
            }
            if (this.resizingOverlay != null) {
                this.resizingOverlay.savePosition();
                this.resizingOverlay = null;
                return true;
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (keyCode == 295) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void resetAllOverlays() {
        for (DraggableOverlay overlay : this.overlays) {
            if (!overlay.isEnabled()) continue;
            overlay.resetToDefault();
        }
    }

    public void method_25419() {
        for (DraggableOverlay overlay : this.overlays) {
            overlay.savePosition();
        }
        CCLiveUtilitiesConfig.HANDLER.save();
        OverlayEditorUtility.setOverlayEditorOpen(false);
        class_310 client = class_310.method_1551();
        if (client != null && this.previousScreen != null) {
            client.method_1507(this.previousScreen);
        } else {
            super.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }

    private boolean isInPlayerNameDimension() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        String playerName = client.field_1724.method_5477().getString().toLowerCase();
        String dimensionPath = client.field_1687.method_27983().method_29177().method_12832();
        return dimensionPath.equals(playerName);
    }
}

