/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.AspectOverlay;
import net.felix.utilities.AspectOverlayRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;

public class InformationenUtility {
    private static boolean isInitialized = false;
    private static Map<String, MaterialInfo> materialsDatabase = new HashMap<String, MaterialInfo>();
    private static final String MATERIALS_CONFIG_FILE = "assets/cclive-utilities/Aincraft.json";
    private static Map<String, EssenceInfo> essencesDatabase = new HashMap<String, EssenceInfo>();
    private static final String ESSENCES_CONFIG_FILE = "assets/cclive-utilities/Essenz.json";
    private static Map<String, AspectInfo> aspectsDatabase = new HashMap<String, AspectInfo>();
    private static final String ASPECTS_CONFIG_FILE = "assets/cclive-utilities/Aspekte.json";

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        InformationenUtility.loadMaterialsDatabase();
        InformationenUtility.loadEssencesDatabase();
        InformationenUtility.loadAspectsDatabase();
        AspectOverlay.initialize();
        AspectOverlayRenderer.initialize();
        ItemTooltipCallback.EVENT.register((stack, context, tooltipType, lines) -> {
            if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod || !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).informationenUtilityEnabled) {
                return;
            }
            class_310 client = class_310.method_1551();
            boolean isSpecialInventory = false;
            String screenTitle = "";
            if (client.field_1755 != null && (screenTitle = client.field_1755.method_25440().getString()).contains("\u3b09")) {
                isSpecialInventory = true;
            }
            if (isSpecialInventory && !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showEbenenInSpecialInventory) {
                return;
            }
            if (!isSpecialInventory && !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showEbenenInNormalInventories) {
                return;
            }
            int startIndex = 0;
            int endIndex = isSpecialInventory ? 1 : lines.size();
            block0: for (int i = startIndex; i < endIndex; ++i) {
                class_2561 line = (class_2561)lines.get(i);
                String lineText = line.getString();
                if (lineText == null || lineText.isEmpty()) continue;
                String cleanLineText = lineText.replaceAll("\u00a7[0-9a-fk-or]", "");
                cleanLineText = cleanLineText.replaceAll("[\\u3400-\\u4DBF]", "");
                boolean isEssenceImprovementInventory = screenTitle.contains("Machtkristalle Verbessern");
                if (isEssenceImprovementInventory && lineText.contains("[Essenz]")) {
                    String essenceNameToSearch;
                    EssenceInfo essenceInfo;
                    String textBeforeColon = cleanLineText;
                    if (cleanLineText.contains(":")) {
                        textBeforeColon = cleanLineText.substring(0, cleanLineText.indexOf(":")).trim();
                    }
                    if (textBeforeColon.startsWith("-")) {
                        textBeforeColon = textBeforeColon.substring(1).trim();
                    }
                    if ((essenceInfo = essencesDatabase.get(essenceNameToSearch = textBeforeColon)) != null && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showWaveDisplay) {
                        class_5250 class_52502 = class_2561.method_43470((String)" -> Welle: ").method_27694(style -> style.method_36139(0xC0C0C0)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(essenceInfo.wave)).method_27694(style -> style.method_36139(0x55FF55)));
                        lines.add(i + 1, class_52502);
                        ++i;
                        continue;
                    }
                }
                if (screenTitle.contains("Essenz [Auswahl]") || screenTitle.contains("Essenz-Tasche") || screenTitle.contains("Essenzernter") || screenTitle.contains("\u3a36") || screenTitle.contains("Legend+ Men\u00fc")) continue;
                String materialNamePart = cleanLineText;
                if (cleanLineText.contains("[")) {
                    materialNamePart = cleanLineText.substring(0, cleanLineText.indexOf("[")).trim();
                }
                if (materialNamePart.isEmpty() || lineText.contains("[Karte]") || lineText.contains("[Statue]")) continue;
                ArrayList<Map.Entry<String, MaterialInfo>> sortedMaterials = new ArrayList<Map.Entry<String, MaterialInfo>>(materialsDatabase.entrySet());
                sortedMaterials.sort((a, b) -> Integer.compare(((String)b.getKey()).length(), ((String)a.getKey()).length()));
                for (Map.Entry entry : sortedMaterials) {
                    String materialName = (String)entry.getKey();
                    MaterialInfo info = (MaterialInfo)entry.getValue();
                    String escapedMaterialName = Pattern.quote(materialName);
                    String pattern = "\\b" + escapedMaterialName + "\\b";
                    if (!Pattern.compile(pattern, 256).matcher(materialNamePart).find() || lineText.contains("[Bauplan]") || isSpecialInventory && !info.rarity.equals("mob")) continue;
                    int color = InformationenUtility.getRarityColor(info.rarity);
                    class_5250 materialInfo = isSpecialInventory ? class_2561.method_43470((String)(" [" + info.floor + "]")).method_27694(style -> style.method_36139(color)) : class_2561.method_43470((String)(" [Ebene " + info.floor + "]")).method_27694(style -> style.method_36139(color));
                    class_5250 combinedText = line.method_27661().method_10852((class_2561)materialInfo);
                    lines.set(i, combinedText);
                    continue block0;
                }
            }
            InformationenUtility.checkForAspectInformationAndUpdateOverlay(lines, client);
            InformationenUtility.addAspectNameToTooltip(lines, client);
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1755 != null) {
                InformationenUtility.updateAspectOverlayFromTooltip(client);
            }
        });
        isInitialized = true;
    }

    private static void updateAspectOverlayFromTooltip(class_310 client) {
        boolean isShiftPressed;
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).aspectOverlayEnabled) {
            return;
        }
        boolean bl = isShiftPressed = class_3675.method_15987((long)client.method_22683().method_4490(), (int)340) || class_3675.method_15987((long)client.method_22683().method_4490(), (int)344);
        if (!isShiftPressed) {
            AspectOverlay.hideOverlay();
            return;
        }
    }

    private static void addAspectNameToTooltip(List<class_2561> lines, class_310 client) {
        boolean isBlueprintInventory;
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).aspectOverlayEnabled) {
            return;
        }
        if (client.field_1755 == null) {
            return;
        }
        String screenTitle = client.field_1755.method_25440().getString();
        String cleanScreenTitle = screenTitle.replaceAll("\u00a7[0-9a-fk-or]", "").replaceAll("[\\u3400-\\u4DBF]", "");
        boolean bl = isBlueprintInventory = cleanScreenTitle.contains("Baupl\u00e4ne [Waffen]") || cleanScreenTitle.contains("Baupl\u00e4ne [R\u00fcstung]") || cleanScreenTitle.contains("Baupl\u00e4ne [Werkzeuge]") || cleanScreenTitle.contains("Bauplan [Shop]") || cleanScreenTitle.contains("Favorisierte [R\u00fcstungsbaupl\u00e4ne]") || cleanScreenTitle.contains("Favorisierte [Waffenbaupl\u00e4ne]") || cleanScreenTitle.contains("CACTUS_CLICKER.blueprints.favorites.title.tools");
        if (!isBlueprintInventory) {
            return;
        }
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            String lineText = line.getString();
            if (lineText == null || lineText.isEmpty() || !lineText.contains("[Bauplan]")) continue;
            String itemName = lineText.substring(0, lineText.indexOf("[Bauplan]")).trim();
            if (itemName.startsWith("-")) {
                itemName = itemName.substring(1).trim();
            }
            if (itemName.endsWith("-")) {
                itemName = itemName.substring(0, itemName.length() - 1).trim();
            }
            itemName = itemName.replaceAll("\u00a7[0-9a-fk-or]", "");
            itemName = itemName.replaceAll("[\\u3400-\\u4DBF]", "");
            AspectInfo aspectInfo = aspectsDatabase.get(itemName = itemName.replaceAll("[^a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\\s-]", "").trim());
            if (aspectInfo == null) continue;
            int targetPosition = Math.max(0, lines.size() - 5);
            class_5250 aspectNameText = class_2561.method_43470((String)"Enth\u00e4lt: ").method_27694(style -> style.method_36139(-1)).method_10852((class_2561)class_2561.method_43470((String)aspectInfo.aspectName).method_27694(style -> style.method_36139(-219136)));
            lines.add(targetPosition, (class_2561)aspectNameText);
            class_5250 shiftInfoText = class_2561.method_43470((String)"(Shift f\u00fcr mehr Info)").method_27694(style -> style.method_36139(-3355444));
            lines.add(targetPosition + 1, (class_2561)shiftInfoText);
            class_5250 emptyLineText = class_2561.method_43470((String)" ");
            lines.add(targetPosition + 2, (class_2561)emptyLineText);
            break;
        }
    }

    private static void checkForAspectInformationAndUpdateOverlay(List<class_2561> lines, class_310 client) {
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).aspectOverlayEnabled) {
            return;
        }
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            String lineText = line.getString();
            if (lineText == null || lineText.isEmpty() || !lineText.contains("[Bauplan]")) continue;
            AspectOverlay.updateFromBlueprintName(lineText);
            break;
        }
    }

    private static class_1799 getHoveredItem(class_310 client) {
        return class_1799.field_8037;
    }

    private static void checkForAspectInformation(List<class_2561> lines, class_310 client) {
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).aspectOverlayEnabled) {
            return;
        }
        for (int i = 0; i < lines.size(); ++i) {
            boolean isShiftPressed;
            class_2561 line = lines.get(i);
            String lineText = line.getString();
            if (lineText == null || lineText.isEmpty() || !lineText.contains("[Bauplan]")) continue;
            String itemName = lineText.substring(0, lineText.indexOf("[Bauplan]")).trim();
            if (itemName.startsWith("-")) {
                itemName = itemName.substring(1).trim();
            }
            if (itemName.endsWith("-")) {
                itemName = itemName.substring(0, itemName.length() - 1).trim();
            }
            itemName = itemName.replaceAll("\u00a7[0-9a-fk-or]", "");
            itemName = itemName.replaceAll("[\\u3400-\\u4DBF]", "");
            AspectInfo aspectInfo = aspectsDatabase.get(itemName = itemName.replaceAll("[^a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\\s]", "").trim());
            if (aspectInfo == null || aspectInfo.aspectName.isEmpty()) continue;
            int targetPosition = Math.max(0, lines.size() - 5);
            class_5250 aspectNameText = class_2561.method_43470((String)"Enth\u00e4lt: ").method_27694(style -> style.method_36139(-1)).method_10852((class_2561)class_2561.method_43470((String)aspectInfo.aspectName).method_27694(style -> style.method_36139(-219136)));
            lines.add(targetPosition, (class_2561)aspectNameText);
            class_5250 emptyLineText = class_2561.method_43470((String)" ");
            lines.add(targetPosition + 1, (class_2561)emptyLineText);
            boolean bl = isShiftPressed = class_3675.method_15987((long)client.method_22683().method_4490(), (int)340) || class_3675.method_15987((long)client.method_22683().method_4490(), (int)344);
            if (!isShiftPressed || aspectInfo.aspectDescription.isEmpty()) break;
            class_5250 aspectDescText = class_2561.method_43470((String)"  ").method_27694(style -> style.method_36139(0xC0C0C0)).method_10852((class_2561)class_2561.method_43470((String)aspectInfo.aspectDescription).method_27694(style -> style.method_36139(0xFFFFFF)));
            lines.add(targetPosition + 2, (class_2561)aspectDescText);
            break;
        }
    }

    private static void loadMaterialsDatabase() {
        try {
            Path resource = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("cclive-utilities").orElseThrow(() -> new RuntimeException("Mod container not found"))).findPath(MATERIALS_CONFIG_FILE).orElseThrow(() -> new RuntimeException("Materials config file not found"));
            try (InputStream inputStream = Files.newInputStream(resource, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(inputStream);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject floors = json.getAsJsonObject("floors");
                for (String floorKey : floors.keySet()) {
                    String mobName;
                    JsonObject floorData = floors.getAsJsonObject(floorKey);
                    int floorNumber = Integer.parseInt(floorKey.replace("floor_", ""));
                    if (floorData.has("mob") && !(mobName = floorData.get("mob").getAsString()).isEmpty()) {
                        materialsDatabase.put(mobName, new MaterialInfo(floorNumber, "mob", "WHITE"));
                    }
                    JsonObject materials = floorData.getAsJsonObject("materials");
                    for (String rarityKey : materials.keySet()) {
                        JsonObject rarityData = materials.getAsJsonObject(rarityKey);
                        String color = rarityData.get("color").getAsString();
                        JsonArray materialsArray = rarityData.getAsJsonArray("materials");
                        for (JsonElement element : materialsArray) {
                            String materialName = element.getAsString();
                            if (materialName.isEmpty()) continue;
                            materialsDatabase.put(materialName, new MaterialInfo(floorNumber, rarityKey, color));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load materials database: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void loadEssencesDatabase() {
        try {
            Path resource = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("cclive-utilities").orElseThrow(() -> new RuntimeException("Mod container not found"))).findPath(ESSENCES_CONFIG_FILE).orElseThrow(() -> new RuntimeException("Essences config file not found"));
            try (InputStream inputStream = Files.newInputStream(resource, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(inputStream);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonArray essencesArray = json.getAsJsonArray("essences");
                for (JsonElement element : essencesArray) {
                    JsonObject essenceData = element.getAsJsonObject();
                    String name = essenceData.get("name").getAsString();
                    int wave = essenceData.get("wave").getAsInt();
                    if (name.isEmpty()) continue;
                    essencesDatabase.put(name, new EssenceInfo(name, "Essenz", "Tier", wave));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load essences database: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void loadAspectsDatabase() {
        try {
            Path resource = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("cclive-utilities").orElseThrow(() -> new RuntimeException("Mod container not found"))).findPath(ASPECTS_CONFIG_FILE).orElseThrow(() -> new RuntimeException("Aspects config file not found"));
            try (InputStream inputStream = Files.newInputStream(resource, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(inputStream);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (String itemName : json.keySet()) {
                    JsonObject itemData = json.getAsJsonObject(itemName);
                    String aspectName = itemData.get("aspect_name").getAsString();
                    String aspectDescription = itemData.get("aspect_description").getAsString();
                    if (aspectName.isEmpty() && aspectDescription.isEmpty()) continue;
                    aspectsDatabase.put(itemName, new AspectInfo(aspectName, aspectDescription));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load aspects database: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static int getRarityColor(String rarity) {
        switch (rarity.toLowerCase()) {
            case "common": {
                return 0xFFFFFF;
            }
            case "uncommon": {
                return 2030592;
            }
            case "rare": {
                return 28634;
            }
            case "epic": {
                return 10564843;
            }
            case "legendary": {
                return 16547328;
            }
            case "mob": {
                return 0xFFFFFF;
            }
        }
        return 0x808080;
    }

    private static class_124 getRarityFormatting(String rarity) {
        switch (rarity.toLowerCase()) {
            case "common": {
                return class_124.field_1068;
            }
            case "uncommon": {
                return class_124.field_1060;
            }
            case "rare": {
                return class_124.field_1078;
            }
            case "epic": {
                return class_124.field_1076;
            }
            case "legendary": {
                return class_124.field_1065;
            }
        }
        return class_124.field_1080;
    }

    private static class AspectInfo {
        public final String aspectName;
        public final String aspectDescription;

        public AspectInfo(String aspectName, String aspectDescription) {
            this.aspectName = aspectName;
            this.aspectDescription = aspectDescription;
        }
    }

    private static class MaterialInfo {
        public final int floor;
        public final String rarity;
        public final String color;

        public MaterialInfo(int floor, String rarity, String color) {
            this.floor = floor;
            this.rarity = rarity;
            this.color = color;
        }
    }

    private static class EssenceInfo {
        public final String name;
        public final String type;
        public final String tier;
        public final int wave;

        public EssenceInfo(String name, String type, String tier, int wave) {
            this.name = name;
            this.type = type;
            this.tier = tier;
            this.wave = wave;
        }
    }
}

