/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.OverlayType;
import net.felix.utilities.ActionBarData;
import net.felix.utilities.EquipmentDisplayUtility;
import net.felix.utilities.KeyBindingUtility;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public class MaterialTrackerUtility {
    private static boolean isInitialized = false;
    private static boolean isTrackingMaterials = false;
    private static boolean showOverlays = true;
    private static boolean showTestOverlay = false;
    private static String testText = "Pr\u00e4chtiges Eselhaar [1067]";
    private static final int TEST_LINES_COUNT = 5;
    private static class_304 toggleKeyBinding;
    private static final int LINE_HEIGHT = 13;
    private static final int OVERLAY_WIDTH = 155;
    private static final int OVERLAY_HEIGHT = 103;
    private static final int TEXT_PADDING = 20;
    private static final int MIN_TEXT_WIDTH = 100;
    private static final class_2960 MATERIALS_BACKGROUND_TEXTURE;

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        try {
            MaterialTrackerUtility.registerHotkey();
            MaterialTrackerUtility.registerCommands();
            ClientTickEvents.END_CLIENT_TICK.register(MaterialTrackerUtility::onClientTick);
            HudRenderCallback.EVENT.register((drawContext, tickDelta) -> MaterialTrackerUtility.onHudRender(drawContext, tickDelta));
            isInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void registerHotkey() {
        toggleKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.cclive-utilities.material-toggle", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.cclive-utilities.material"));
    }

    private static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mats").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"test").then(ClientCommandManager.literal((String)"show").executes(context -> {
            showTestOverlay = true;
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aMaterial Tracker Test-Overlay aktiviert!"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"hide").executes(context -> {
            showTestOverlay = false;
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7cMaterial Tracker Test-Overlay deaktiviert!"));
            return 1;
        })))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String newText;
            testText = newText = StringArgumentType.getString((CommandContext)context, (String)"text");
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aTest-Text ge\u00e4ndert zu: \u00a7f" + newText)));
            return 1;
        })))));
    }

    private static void onClientTick(class_310 client) {
        MaterialTrackerUtility.checkTabKey();
        MaterialTrackerUtility.handleHotkey();
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showMaterialTracker)) {
            return;
        }
        if (client.field_1724 == null) {
            isTrackingMaterials = false;
            return;
        }
        ActionBarData.checkDimensionChange();
        boolean hasMaterials = ActionBarData.hasMaterials();
        if (hasMaterials != isTrackingMaterials) {
            isTrackingMaterials = hasMaterials;
        }
    }

    private static void checkTabKey() {
        showOverlays = !KeyBindingUtility.isPlayerListKeyPressed();
    }

    private static void handleHotkey() {
        if (toggleKeyBinding != null && toggleKeyBinding.method_1436()) {
            boolean currentShow = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showMaterialTracker;
            ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showMaterialTracker = !currentShow;
            CCLiveUtilitiesConfig.HANDLER.save();
        }
    }

    private static void onHudRender(class_332 context, class_9779 tickCounter) {
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showMaterialTracker)) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (showOverlays && !EquipmentDisplayUtility.isEquipmentOverlayActive()) {
            if (showTestOverlay) {
                MaterialTrackerUtility.renderTestOverlay(context, client);
            } else if (isTrackingMaterials) {
                MaterialTrackerUtility.renderMaterialDisplay(context, client);
            }
        }
    }

    private static void renderMaterialDisplay(class_332 context, class_310 client) {
        if (client.method_22683() == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int xOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerX;
        int yOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerY;
        float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerScale;
        List<Object> texts = ActionBarData.getFilteredTexts();
        int dynamicWidth = MaterialTrackerUtility.calculateRequiredWidth(context, texts);
        int overlayWidth = Math.max(155, dynamicWidth);
        int xPosition = screenWidth - overlayWidth - xOffset;
        int yPosition = yOffset;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        if (scale <= 0.0f) {
            scale = 1.0f;
        }
        matrices.translate((float)xPosition, (float)yPosition);
        matrices.scale(scale, scale);
        OverlayType overlayType = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerOverlayType;
        switch (overlayType) {
            case CUSTOM: {
                try {
                    context.method_25290(class_10799.field_56883, MATERIALS_BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, overlayWidth, 80, overlayWidth, 80);
                }
                catch (Exception e) {
                    context.method_25294(0, 0, overlayWidth, 80, Integer.MIN_VALUE);
                }
                break;
            }
            case BLACK: {
                context.method_25294(0, 0, overlayWidth, 80, Integer.MIN_VALUE);
                break;
            }
        }
        int currentY = 20;
        for (Object textObj : texts) {
            Object textComponent = textObj instanceof class_2561 ? (class_2561)textObj : class_2561.method_43470((String)textObj.toString());
            context.method_51439(class_310.method_1551().field_1772, textComponent, 8, currentY - 8, -1, true);
            currentY += 13;
        }
        matrices.popMatrix();
    }

    private static int calculateRequiredWidth(class_332 context, List<Object> texts) {
        int maxWidth = 100;
        for (Object textObj : texts) {
            Object textComponent = textObj instanceof class_2561 ? (class_2561)textObj : class_2561.method_43470((String)textObj.toString());
            int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)textComponent);
            int totalWidth = textWidth + 15;
            maxWidth = Math.max(maxWidth, totalWidth);
        }
        return maxWidth;
    }

    private static void renderTestOverlay(class_332 context, class_310 client) {
        if (client.method_22683() == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int xOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerX;
        int yOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerY;
        float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerScale;
        ArrayList<String> testLines = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            testLines.add(testText);
        }
        int dynamicWidth = MaterialTrackerUtility.calculateRequiredWidthForStrings(context, testLines);
        int overlayWidth = Math.max(155, dynamicWidth);
        int xPosition = screenWidth - overlayWidth - xOffset;
        int yPosition = yOffset;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        if (scale <= 0.0f) {
            scale = 1.0f;
        }
        matrices.translate((float)xPosition, (float)yPosition);
        matrices.scale(scale, scale);
        OverlayType overlayType = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).materialTrackerOverlayType;
        switch (overlayType) {
            case CUSTOM: {
                try {
                    context.method_25290(class_10799.field_56883, MATERIALS_BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, overlayWidth, 80, overlayWidth, 80);
                }
                catch (Exception e) {
                    context.method_25294(0, 0, overlayWidth, 80, Integer.MIN_VALUE);
                }
                break;
            }
            case BLACK: {
                context.method_25294(0, 0, overlayWidth, 80, Integer.MIN_VALUE);
                break;
            }
        }
        int currentY = 20;
        for (String testLine : testLines) {
            context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)testLine), 8, currentY - 8, -1, true);
            currentY += 13;
        }
        matrices.popMatrix();
    }

    private static int calculateRequiredWidthForStrings(class_332 context, List<String> strings) {
        int maxWidth = 100;
        for (String text : strings) {
            int textWidth = class_310.method_1551().field_1772.method_1727(text);
            int totalWidth = textWidth + 15;
            maxWidth = Math.max(maxWidth, totalWidth);
        }
        return maxWidth;
    }

    static {
        MATERIALS_BACKGROUND_TEXTURE = class_2960.method_60655((String)"cclive-utilities", (String)"textures/gui/materials_background.png");
    }
}

