/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.felix.CCLiveUtilitiesConfig;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9336;

public class SchmiedTrackerUtility {
    private static boolean isInitialized = false;
    private static boolean isInDisassembleChest = false;
    private static Map<Integer, Integer> slotColors = new HashMap<Integer, Integer>();
    private static boolean hideUncraftableActive = false;
    private static boolean isInBlueprintInventory = false;
    private static boolean wasInBlueprintInventory = false;
    private static int buttonX = 0;
    private static int buttonY = 0;
    private static int buttonWidth = 120;
    private static int buttonHeight = 20;
    private static Map<Integer, class_1799> originalItems = new HashMap<Integer, class_1799>();
    private static final Map<String, String> SMITHING_CONFIG_KEYS = new HashMap<String, String>();
    private static final int SLOT_SIZE = 16;

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        ClientTickEvents.END_CLIENT_TICK.register(SchmiedTrackerUtility::onClientTick);
        isInitialized = true;
    }

    private static void onClientTick(class_310 client) {
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).schmiedTrackerEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showSchmiedTracker)) {
            return;
        }
        if (client.field_1724 == null || client.field_1755 == null) {
            isInDisassembleChest = false;
            slotColors.clear();
            return;
        }
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof class_465) {
            class_465 handledScreen = (class_465)class_4372;
            String title = handledScreen.method_25440().getString();
            String cleanTitle = title.replaceAll("\u00a7[0-9a-fk-or]", "").replaceAll("[\\u3400-\\u4DBF]", "");
            if (cleanTitle.contains("Baupl\u00e4ne [Waffen]") || cleanTitle.contains("Baupl\u00e4ne [R\u00fcstung]") || cleanTitle.contains("Baupl\u00e4ne [Werkzeuge]") || cleanTitle.contains("Favorisierte [Waffenbaupl\u00e4ne]") || cleanTitle.contains("Favorisierte [R\u00fcstungsbaupl\u00e4ne]") || cleanTitle.contains("CACTUS_CLICKER.blueprints.favorites.title.tools")) {
                if (!wasInBlueprintInventory) {
                    hideUncraftableActive = false;
                    originalItems.clear();
                }
                isInBlueprintInventory = true;
                isInDisassembleChest = false;
                SchmiedTrackerUtility.updateButtonPosition(handledScreen, client);
                if (hideUncraftableActive) {
                    SchmiedTrackerUtility.updateBlueprintItems(handledScreen, client);
                }
            } else if (cleanTitle.contains("Zerlegen") || cleanTitle.contains("Umschmieden") || cleanTitle.contains("Ausr\u00fcstung [Ausw\u00e4hlen]") || cleanTitle.contains("Aufwerten") || cleanTitle.contains("R\u00fcstungs Sammlung") || cleanTitle.contains("Waffen Sammlung") || cleanTitle.contains("Werkzeug Sammlung") || cleanTitle.contains("CACTUS_CLICKER.CACTUS_CLICKER") || cleanTitle.contains("Gesch\u00fctzte Items") || cleanTitle.contains("\u3b03") || cleanTitle.contains("\u3b04") || cleanTitle.contains("\u3b05") || cleanTitle.contains("\u3b06")) {
                isInDisassembleChest = true;
                isInBlueprintInventory = false;
                SchmiedTrackerUtility.updateSlotColors(handledScreen, client);
            } else {
                isInDisassembleChest = false;
                if (wasInBlueprintInventory && !isInBlueprintInventory) {
                    SchmiedTrackerUtility.restoreOriginalItems(handledScreen);
                    originalItems.clear();
                    hideUncraftableActive = false;
                }
                isInBlueprintInventory = false;
                slotColors.clear();
            }
        } else {
            isInDisassembleChest = false;
            if (wasInBlueprintInventory && !isInBlueprintInventory) {
                SchmiedTrackerUtility.restoreOriginalItems(null);
                originalItems.clear();
                hideUncraftableActive = false;
            }
            isInBlueprintInventory = false;
            slotColors.clear();
        }
        wasInBlueprintInventory = isInBlueprintInventory;
    }

    private static void updateSlotColors(class_465<?> screen, class_310 client) {
        slotColors.clear();
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showSchmiedezustaendeInAusr\u00fcstungsMen\u00fc) {
            return;
        }
        for (int slotIndex = 9; slotIndex <= 44; ++slotIndex) {
            class_1735 slot;
            class_1799 itemStack;
            if (slotIndex >= screen.method_17577().field_7761.size() || (itemStack = (slot = (class_1735)screen.method_17577().field_7761.get(slotIndex)).method_7677()).method_7960()) continue;
            List<class_2561> lore = SchmiedTrackerUtility.getItemTooltip(itemStack, (class_1657)client.field_1724);
            block1: for (class_2561 text : lore) {
                String line = text.getString();
                for (Map.Entry<String, String> entry : SMITHING_CONFIG_KEYS.entrySet()) {
                    if (!line.contains(entry.getKey())) continue;
                    String configKey = entry.getValue();
                    if (!SchmiedTrackerUtility.isSchmiedTypeEnabled(configKey)) continue block1;
                    int color = SchmiedTrackerUtility.getSchmiedTypeColor(configKey);
                    slotColors.put(slotIndex, color);
                    continue block1;
                }
            }
        }
    }

    private static List<class_2561> getItemTooltip(class_1799 itemStack, class_1657 player) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add(itemStack.method_7964());
        class_9290 loreComponent = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (loreComponent != null) {
            tooltip.addAll(loreComponent.comp_2400());
        }
        return tooltip;
    }

    private static boolean isSchmiedTypeEnabled(String configKey) {
        switch (configKey) {
            case "frostgeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).frostgeschmiedetEnabled;
            }
            case "lavageschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).lavageschmiedetEnabled;
            }
            case "titangeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).titangeschmiedetEnabled;
            }
            case "drachengeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).drachengeschmiedetEnabled;
            }
            case "daemonengeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).daemonengeschmiedetEnabled;
            }
            case "blitzgeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blitzgeschmiedetEnabled;
            }
            case "sternengeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).sternengeschmiedetEnabled;
            }
        }
        return false;
    }

    private static int getSchmiedTypeColor(String configKey) {
        switch (configKey) {
            case "frostgeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).frostgeschmiedetColor.getRGB();
            }
            case "lavageschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).lavageschmiedetColor.getRGB();
            }
            case "titangeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).titangeschmiedetColor.getRGB();
            }
            case "drachengeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).drachengeschmiedetColor.getRGB();
            }
            case "daemonengeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).daemonengeschmiedetColor.getRGB();
            }
            case "blitzgeschmiedet": {
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).blitzgeschmiedetColor.getRGB();
            }
            case "sternengeschmiedet": {
                if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).sternengeschmiedetRainbow) {
                    return SchmiedTrackerUtility.getRainbowColor();
                }
                return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).sternengeschmiedetColor.getRGB();
            }
        }
        return -1;
    }

    private static boolean hasCraftingUnicodeIndicators(String nameText) {
        String middleText;
        boolean hasLastIndicator;
        if (nameText == null || nameText.length() < 2) {
            return false;
        }
        char firstChar = nameText.charAt(0);
        char lastChar = nameText.charAt(nameText.length() - 1);
        char firstCode = firstChar;
        char lastCode = lastChar;
        boolean hasFirstIndicator = firstCode >= '\u3531' && firstCode <= '\u3564';
        boolean bl = hasLastIndicator = lastCode >= '\u3531' && lastCode <= '\u3564';
        return hasFirstIndicator && hasLastIndicator && !(middleText = nameText.substring(1, nameText.length() - 1)).trim().isEmpty();
    }

    private static boolean isUnicodeWhite(class_2583 style) {
        if (style == null || style.method_10973() == null) {
            return true;
        }
        int colorRgb = style.method_10973().method_27716();
        if (colorRgb == 65535) {
            return false;
        }
        return colorRgb == 0xFFFFFF || colorRgb == -1;
    }

    private static boolean isUnicodeCyan(class_2583 style) {
        if (style == null || style.method_10973() == null) {
            return false;
        }
        int colorRgb = style.method_10973().method_27716();
        if (colorRgb == 65535) {
            return true;
        }
        return colorRgb != 0xFFFFFF && colorRgb != -1 && colorRgb != 0xF0F0F0 && colorRgb != 0xE0E0E0 && colorRgb != 0xD0D0D0 && colorRgb != 0xC0C0C0 && colorRgb != 0xE6E6E6 && colorRgb != 0xCCCCCC && colorRgb != 0xDDDDDD && colorRgb != 0xEEEEEE;
    }

    private static boolean analyzeCraftabilityByUnicodeCodes(int firstCode, int lastCode, String nameText) {
        if (firstCode >= 13617 && firstCode <= 13668 && lastCode >= 13617 && lastCode <= 13668) {
            return false;
        }
        String lowerName = nameText.toLowerCase();
        if (lowerName.contains("champions wappengurt") || lowerName.contains("drachenlederhelm") || lowerName.contains("drachenlederschuhe") || lowerName.contains("enderstahl waffengurt") || lowerName.contains("eroberers schulterpanzer") || lowerName.contains("ewiges lichtband") || lowerName.contains("flora panzerbrust") || lowerName.contains("gebeulte handgelenkmanschetten") || lowerName.contains("halskette des bezwingers") || lowerName.contains("kappe des forschers") || lowerName.contains("kopfgeldj\u00e4gerring") || lowerName.contains("nat\u00fcrliche lederfinger") || lowerName.contains("pelzgewand des eiswanderers") || lowerName.contains("rote lederhandschuhe") || lowerName.contains("rubinhelmschale") || lowerName.contains("rubinrote kriegshose") || lowerName.contains("rubinrote kriegsschultern") || lowerName.contains("ruhmreicher kopfschutz") || lowerName.contains("solide stahlfingerlinge") || lowerName.contains("st\u00e4hlernde sabatons") || lowerName.contains("zeitloser lederband")) {
            return false;
        }
        return false;
    }

    private static String analyzeTextColor(class_2561 text) {
        if (text == null) {
            return "null";
        }
        try {
            class_2583 style = text.method_10866();
            if (style != null && style.method_10973() != null) {
                return "0x" + Integer.toHexString(style.method_10973().method_27716()).toUpperCase() + " (Style)";
            }
            String recursiveResult = SchmiedTrackerUtility.analyzeTextColorRecursive(text);
            if (recursiveResult != null && !recursiveResult.equals("null")) {
                return recursiveResult;
            }
            String textString = text.getString();
            if (textString.contains("\u00a7")) {
                for (int i = 0; i < textString.length() - 1; ++i) {
                    if (textString.charAt(i) != '\u00a7') continue;
                    char colorCode = textString.charAt(i + 1);
                    switch (colorCode) {
                        case 'f': {
                            return "0xFFFFFF (Wei\u00df)";
                        }
                        case 'F': {
                            return "0xFFFFFF (Wei\u00df)";
                        }
                        case 'e': {
                            return "0xFFFF55 (Gelb)";
                        }
                        case 'E': {
                            return "0xFFFF55 (Gelb)";
                        }
                        case 'a': {
                            return "0x55FF55 (Gr\u00fcn)";
                        }
                        case 'A': {
                            return "0x55FF55 (Gr\u00fcn)";
                        }
                        case 'b': {
                            return "0x5555FF (Blau)";
                        }
                        case 'B': {
                            return "0x5555FF (Blau)";
                        }
                        case 'c': {
                            return "0xFF5555 (Rot)";
                        }
                        case 'C': {
                            return "0xFF5555 (Rot)";
                        }
                        case 'd': {
                            return "0xFF55FF (Magenta)";
                        }
                        case 'D': {
                            return "0xFF55FF (Magenta)";
                        }
                        case '3': {
                            return "0x00AAAA (T\u00fcrkis)";
                        }
                        case '9': {
                            return "0x5555FF (Blau)";
                        }
                        case '5': {
                            return "0xAA00AA (Lila)";
                        }
                        case '6': {
                            return "0xFFAA00 (Gold)";
                        }
                        case '7': {
                            return "0xAAAAAA (Grau)";
                        }
                        case '8': {
                            return "0x555555 (Dunkelgrau)";
                        }
                        case '0': {
                            return "0x000000 (Schwarz)";
                        }
                        case '1': {
                            return "0x0000AA (Dunkelblau)";
                        }
                        case '2': {
                            return "0x00AA00 (Dunkelgr\u00fcn)";
                        }
                        case '4': {
                            return "0xAA0000 (Dunkelrot)";
                        }
                    }
                }
            }
            if (textString.length() >= 2 && SchmiedTrackerUtility.hasCraftingUnicodeIndicators(textString)) {
                class_2583 unicodeStyle = text.method_10866();
                if (unicodeStyle != null && unicodeStyle.method_10973() != null) {
                    int colorRgb = unicodeStyle.method_10973().method_27716();
                    return "0x" + Integer.toHexString(colorRgb).toUpperCase() + " (Unicode Style)";
                }
                return "null (keine Style-Farbe f\u00fcr Unicode)";
            }
            return "null (keine Farbe erkannt)";
        }
        catch (Exception e) {
            return "null (Fehler bei Farbanalyse: " + e.getMessage() + ")";
        }
    }

    private static String analyzeTextColorRecursive(class_2561 text) {
        if (text == null) {
            return null;
        }
        try {
            class_2583 textStyle;
            String className;
            class_2583 style = text.method_10866();
            if (style != null && style.method_10973() != null) {
                int colorRgb = style.method_10973().method_27716();
                return "0x" + Integer.toHexString(colorRgb).toUpperCase() + " (Rekursiv)";
            }
            List siblings = text.method_10855();
            if (siblings != null) {
                for (class_2561 sibling : siblings) {
                    String siblingResult = SchmiedTrackerUtility.analyzeTextColorRecursive(sibling);
                    if (siblingResult == null || siblingResult.equals("null")) continue;
                    return siblingResult;
                }
            }
            if (((className = text.getClass().getSimpleName()).contains("Literal") || className.contains("Text")) && (textStyle = text.method_10866()) != null && textStyle.method_10973() != null) {
                int colorRgb = textStyle.method_10973().method_27716();
                return "0x" + Integer.toHexString(colorRgb).toUpperCase() + " (" + className + ")";
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String analyzeUnicodeColor(class_2561 text) {
        if (text == null) {
            return "null";
        }
        try {
            String textString = text.getString();
            if (textString.length() < 2) {
                return "null (Text zu kurz)";
            }
            if (!SchmiedTrackerUtility.hasCraftingUnicodeIndicators(textString)) {
                return "null (keine Unicode-Indikatoren)";
            }
            List siblings = text.method_10855();
            if (siblings != null && !siblings.isEmpty() && siblings.size() >= 2) {
                class_2561 firstSibling = (class_2561)siblings.get(0);
                class_2561 lastSibling = (class_2561)siblings.get(siblings.size() - 1);
                String firstSiblingString = firstSibling.getString();
                String lastSiblingString = lastSibling.getString();
                if (firstSiblingString.length() > 0 && lastSiblingString.length() > 0) {
                    char firstSiblingChar = firstSiblingString.charAt(0);
                    char lastSiblingChar = lastSiblingString.charAt(0);
                    char firstSiblingCode = firstSiblingChar;
                    char lastSiblingCode = lastSiblingChar;
                    if (firstSiblingCode >= '\u3531' && firstSiblingCode <= '\u3564' && lastSiblingCode >= '\u3531' && lastSiblingCode <= '\u3564') {
                        class_2561 itemNameSibling;
                        class_2583 itemNameStyle;
                        if (siblings.size() >= 3 && (itemNameStyle = (itemNameSibling = (class_2561)siblings.get(1)).method_10866()) != null && itemNameStyle.method_10973() != null) {
                            int colorRgb = itemNameStyle.method_10973().method_27716();
                            return "0x" + Integer.toHexString(colorRgb).toUpperCase() + " (Unicode Context)";
                        }
                        class_2583 firstSiblingStyle = firstSibling.method_10866();
                        if (firstSiblingStyle != null && firstSiblingStyle.method_10973() != null) {
                            int colorRgb = firstSiblingStyle.method_10973().method_27716();
                            return "0x" + Integer.toHexString(colorRgb).toUpperCase() + " (Unicode Sibling)";
                        }
                        class_2583 lastSiblingStyle = lastSibling.method_10866();
                        if (lastSiblingStyle != null && lastSiblingStyle.method_10973() != null) {
                            int colorRgb = lastSiblingStyle.method_10973().method_27716();
                            return "0x" + Integer.toHexString(colorRgb).toUpperCase() + " (Unicode Sibling)";
                        }
                        class_2583 rootStyle = text.method_10866();
                        if (rootStyle != null && rootStyle.method_10973() != null) {
                            int colorRgb = rootStyle.method_10973().method_27716();
                            return "0x" + Integer.toHexString(colorRgb).toUpperCase() + " (Unicode Root)";
                        }
                        return "0xFFFFFF (Unicode Standard Wei\u00df)";
                    }
                }
            }
            return SchmiedTrackerUtility.analyzeUnicodeColorHeuristic(textString);
        }
        catch (Exception e) {
            return "null (Fehler bei Unicode-Analyse: " + e.getMessage() + ")";
        }
    }

    private static List<Integer> findBlueprintSlots(class_465<?> screen) {
        int[] blueprintSlotRanges;
        ArrayList<Integer> blueprintSlots = new ArrayList<Integer>();
        for (int slotIndex : blueprintSlotRanges = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43}) {
            String itemName;
            class_1735 slot;
            class_1799 itemStack;
            if (slotIndex >= screen.method_17577().field_7761.size() || (itemStack = (slot = (class_1735)screen.method_17577().field_7761.get(slotIndex)).method_7677()).method_7960() || !SchmiedTrackerUtility.hasCraftingUnicodeIndicators(itemName = itemStack.method_7964().getString())) continue;
            blueprintSlots.add(slotIndex);
        }
        if (blueprintSlots.isEmpty()) {
            for (int slotIndex : blueprintSlotRanges) {
                if (slotIndex >= screen.method_17577().field_7761.size()) continue;
                blueprintSlots.add(slotIndex);
            }
        }
        return blueprintSlots;
    }

    private static String analyzeUnicodeColorHeuristic(String textString) {
        try {
            if (textString.contains("\u00a7")) {
                for (int i = 0; i < textString.length() - 1; ++i) {
                    if (textString.charAt(i) != '\u00a7') continue;
                    char colorCode = textString.charAt(i + 1);
                    switch (colorCode) {
                        case '3': {
                            return "0x00FFFF (T\u00fcrkis - Heuristik)";
                        }
                        case 'b': {
                            return "0x5555FF (Blau - Heuristik)";
                        }
                        case '9': {
                            return "0x5555FF (Blau - Heuristik)";
                        }
                        case 'f': {
                            return "0xFFFFFF (Wei\u00df - Heuristik)";
                        }
                        case 'F': {
                            return "0xFFFFFF (Wei\u00df - Heuristik)";
                        }
                        case '7': {
                            return "0xAAAAAA (Grau - Heuristik)";
                        }
                        case '8': {
                            return "0x555555 (Dunkelgrau - Heuristik)";
                        }
                    }
                }
            }
            char firstChar = textString.charAt(0);
            char lastChar = textString.charAt(textString.length() - 1);
            char firstCode = firstChar;
            char lastCode = lastChar;
            if (firstCode >= '\u3531' && firstCode <= '\u3564' && lastCode >= '\u3531' && lastCode <= '\u3564') {
                return "null (keine heuristische Farbe gefunden)";
            }
            return "null (keine heuristische Farbe gefunden)";
        }
        catch (Exception e) {
            return "null (Fehler bei heuristischer Analyse: " + e.getMessage() + ")";
        }
    }

    private static int getRainbowColor() {
        float b;
        float g;
        float r;
        long time = System.currentTimeMillis();
        float hue = (float)(time % 2000L) / 2000.0f;
        float h = hue * 360.0f;
        float s = 1.0f;
        float v = 1.0f;
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        if (h < 60.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (h < 120.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (h < 180.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (h < 240.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (h < 300.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        r = (float)Math.pow(r, 0.7);
        g = (float)Math.pow(g, 0.8);
        b = (float)Math.pow(b, 0.7);
        return 0xFF000000 | (int)((r + m) * 255.0f) << 16 | (int)((g + m) * 255.0f) << 8 | (int)((b + m) * 255.0f);
    }

    private static void updateButtonPosition(class_465<?> screen, class_310 client) {
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int baseX = screenWidth - buttonWidth - 20;
        int baseY = 20;
        buttonX = baseX + ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).hideUncraftableButtonX;
        buttonY = baseY + ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).hideUncraftableButtonY;
    }

    private static void updateBlueprintItems(class_465<?> screen, class_310 client) {
        int[] targetSlots;
        if (!hideUncraftableActive) {
            SchmiedTrackerUtility.restoreOriginalItems(screen);
            return;
        }
        List<Integer> blueprintSlots = SchmiedTrackerUtility.findBlueprintSlots(screen);
        for (int slotIndex : targetSlots = blueprintSlots.stream().mapToInt(Integer::intValue).toArray()) {
            boolean hasEnchantmentsResult;
            class_1735 slot;
            class_1799 itemStack;
            if (slotIndex >= screen.method_17577().field_7761.size() || (itemStack = (slot = (class_1735)screen.method_17577().field_7761.get(slotIndex)).method_7677()).method_7960()) continue;
            if (!originalItems.containsKey(slotIndex)) {
                originalItems.put(slotIndex, itemStack.method_7972());
            }
            if (hasEnchantmentsResult = SchmiedTrackerUtility.hasEnchantments(itemStack)) continue;
            class_1799 blackConcrete = new class_1799((class_1935)class_1802.field_8704);
            blackConcrete.method_57379(class_9334.field_49631, (Object)((class_2561)itemStack.method_58694(class_9334.field_49631)));
            blackConcrete.method_57379(class_9334.field_49632, (Object)((class_9290)itemStack.method_58694(class_9334.field_49632)));
            class_2561 customName = (class_2561)blackConcrete.method_58694(class_9334.field_49631);
            if (customName != null) {
                originalName = customName.getString();
                newName = class_2561.method_43470((String)(originalName + " \u00a77[Ausgeblendet]"));
                blackConcrete.method_57379(class_9334.field_49631, (Object)newName);
            } else {
                originalName = itemStack.method_7964().getString();
                newName = class_2561.method_43470((String)(originalName + " \u00a77[Ausgeblendet]"));
                blackConcrete.method_57379(class_9334.field_49631, (Object)newName);
            }
            slot.method_53512(blackConcrete);
        }
    }

    private static void restoreOriginalItems(class_465<?> screen) {
        if (screen == null) {
            originalItems.clear();
            return;
        }
        HashMap<Integer, class_1799> itemsToRestore = new HashMap<Integer, class_1799>(originalItems);
        for (Map.Entry entry : itemsToRestore.entrySet()) {
            class_1735 slot;
            class_1799 currentItem;
            int slotIndex = (Integer)entry.getKey();
            class_1799 originalItem = (class_1799)entry.getValue();
            if (slotIndex >= screen.method_17577().field_7761.size() || (currentItem = (slot = (class_1735)screen.method_17577().field_7761.get(slotIndex)).method_7677()).method_7909() != class_1802.field_8704) continue;
            slot.method_53512(originalItem);
        }
        originalItems.clear();
    }

    private static boolean hasEnchantments(class_1799 itemStack) {
        try {
            boolean hasGlint = itemStack.method_7958();
            return hasGlint;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void renderColoredFrames(class_332 context, class_465<?> screen, int screenX, int screenY) {
        if (!isInDisassembleChest) {
            return;
        }
        for (Map.Entry<Integer, Integer> entry : slotColors.entrySet()) {
            int slotIndex = entry.getKey();
            int color = entry.getValue();
            if (slotIndex >= screen.method_17577().field_7761.size()) continue;
            class_1735 slot = (class_1735)screen.method_17577().field_7761.get(slotIndex);
            int slotX = screenX + slot.field_7873;
            int slotY = screenY + slot.field_7872;
            context.method_25294(slotX - 1, slotY - 1, slotX + 16 + 1, slotY, color);
            context.method_25294(slotX - 1, slotY + 16, slotX + 16 + 1, slotY + 16 + 1, color);
            context.method_25294(slotX - 1, slotY - 1, slotX, slotY + 16 + 1, color);
            context.method_25294(slotX + 16, slotY - 1, slotX + 16 + 1, slotY + 16 + 1, color);
        }
    }

    public static void renderHideUncraftableButton(class_332 context, class_465<?> screen) {
        if (!isInBlueprintInventory || !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).hideUncraftableEnabled) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        int backgroundColor = hideUncraftableActive ? -11834775 : -11834775;
        context.method_25294(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, backgroundColor);
        context.method_25294(buttonX, buttonY, buttonX + buttonWidth, buttonY + 2, -10123908);
        context.method_25294(buttonX, buttonY + buttonHeight - 2, buttonX + buttonWidth, buttonY + buttonHeight, -14864581);
        context.method_25294(buttonX, buttonY, buttonX + 2, buttonY + buttonHeight, -13545902);
        context.method_25294(buttonX + buttonWidth - 2, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, -13545902);
        String buttonText = hideUncraftableActive ? "Show All" : "Hide Uncraftable";
        int textColor = -12566464;
        int textX = buttonX + (buttonWidth - client.field_1772.method_1727(buttonText)) / 2;
        int textY = buttonY + (buttonHeight - 8) / 2;
        context.method_51433(client.field_1772, buttonText, textX, textY, textColor, false);
    }

    public static boolean handleButtonClick(double mouseX, double mouseY, int button) {
        if (!isInBlueprintInventory || !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).hideUncraftableEnabled) {
            return false;
        }
        if (button == 0 && mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight)) {
            class_437 class_4372;
            hideUncraftableActive = !hideUncraftableActive;
            class_310 client = class_310.method_1551();
            if (client != null && (class_4372 = client.field_1755) instanceof class_465) {
                class_465 handledScreen = (class_465)class_4372;
                if (hideUncraftableActive) {
                    SchmiedTrackerUtility.updateBlueprintItems(handledScreen, client);
                } else {
                    SchmiedTrackerUtility.restoreOriginalItems(handledScreen);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isHideUncraftableActive() {
        return hideUncraftableActive;
    }

    public static boolean isInBlueprintInventory() {
        return isInBlueprintInventory;
    }

    public static String debugItemEnchantmentDetection(class_1799 itemStack) {
        StringBuilder debug = new StringBuilder();
        debug.append("Item: ").append(class_7923.field_41178.method_10221((Object)itemStack.method_7909())).append("\n");
        debug.append("Verbesserte Unicode-Erkennung aktiviert: ").append(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).hideUncraftableUseImprovedDetection).append("\n");
        debug.append("Normale Unicode-Erkennung aktiviert: ").append(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).hideUncraftableUseUnicodeDetection).append("\n");
        try {
            boolean hasGlint = itemStack.method_7942();
            debug.append("hasEnchantments(): ").append(hasGlint).append("\n");
            class_9304 enchantments = itemStack.method_58657();
            boolean hasEnchantments = enchantments != null && !enchantments.method_57543();
            debug.append("getEnchantments(): ").append(hasEnchantments).append("\n");
            class_9290 loreComponent = (class_9290)itemStack.method_58694(class_9334.field_49632);
            if (loreComponent != null) {
                debug.append("Lore gefunden:\n");
                for (class_2561 line : loreComponent.comp_2400()) {
                    String lineText = line.getString();
                    debug.append("  - ").append(lineText).append("\n");
                }
            } else {
                debug.append("Keine Lore gefunden\n");
            }
            class_2561 customName = (class_2561)itemStack.method_58694(class_9334.field_49631);
            if (customName != null) {
                String nameText = customName.getString();
                debug.append("Custom Name: ").append(nameText).append("\n");
                if (nameText.length() > 2) {
                    char firstChar = nameText.charAt(0);
                    char lastChar = nameText.charAt(nameText.length() - 1);
                    char firstCode = firstChar;
                    char lastCode = lastChar;
                    debug.append("Erstes Zeichen: '").append(firstChar).append("' (Code: ").append((int)firstCode).append(")\n");
                    debug.append("Letztes Zeichen: '").append(lastChar).append("' (Code: ").append((int)lastCode).append(")\n");
                    boolean hasCraftingIndicator = SchmiedTrackerUtility.hasCraftingUnicodeIndicators(nameText);
                    debug.append("Hat Crafting-Indikator: ").append(hasCraftingIndicator).append("\n");
                    boolean isUncraftableFirst = firstCode == '\u3539';
                    boolean isUncraftableLast = lastCode == '\u3531' || lastCode == '\u3534';
                    debug.append("Ist uncraftbar (First): ").append(isUncraftableFirst).append("\n");
                    debug.append("Ist uncraftbar (Last): ").append(isUncraftableLast).append("\n");
                    boolean isUnicodeFirst = firstChar > '\u007f' || firstChar < ' ';
                    boolean isUnicodeLast = lastChar > '\u007f' || lastChar < ' ';
                    debug.append("Erstes Zeichen ist Unicode: ").append(isUnicodeFirst).append("\n");
                    debug.append("Letztes Zeichen ist Unicode: ").append(isUnicodeLast).append("\n");
                    debug.append("Erwartete Unicode-Codes f\u00fcr Crafting-Indikatoren:\n");
                    debug.append("  - 13625 (\u3539), 13624 (\u3538) f\u00fcr erstes Zeichen\n");
                    debug.append("  - 13617 (\u3534), 13620 (\u3531) f\u00fcr letztes Zeichen\n");
                    debug.append("Gefundene Codes: ").append((int)firstCode).append(" und ").append((int)lastCode).append("\n");
                    debug.append("\nVERBESSERTE UNICODE-ERKENNUNG:\n");
                    debug.append("  - T\u00fcrkise Unicode-Zeichen \u3539\u3538\u3531 = craftbar (wird NICHT ausgeblendet)\n");
                    debug.append("  - Wei\u00dfe Unicode-Zeichen \u3539\u3538\u3531 = uncraftbar (wird ausgeblendet)\n");
                    debug.append("  - Keine Unicode-Zeichen = wird nicht behandelt\n");
                    class_2583 formatting = customName.method_10866();
                    if (formatting != null && formatting.method_10973() != null) {
                        int colorRgb = formatting.method_10973().method_27716();
                        debug.append("Textfarbe: 0x").append(Integer.toHexString(colorRgb).toUpperCase()).append("\n");
                        boolean isWhiteColor = SchmiedTrackerUtility.isUnicodeWhite(formatting);
                        boolean isCyanColor = SchmiedTrackerUtility.isUnicodeCyan(formatting);
                        debug.append("Ist wei\u00dfe Farbe: ").append(isWhiteColor).append("\n");
                        debug.append("Ist t\u00fcrkise Farbe: ").append(isCyanColor).append("\n");
                        if (hasCraftingIndicator) {
                            if (isWhiteColor) {
                                debug.append("*** UNCRAFTABLE ERKANNT - Wei\u00dfe Unicode-Zeichen, Item wird ausgeblendet ***\n");
                            } else if (isCyanColor) {
                                debug.append("*** CRAFTABLE ERKANNT - T\u00fcrkise Unicode-Zeichen, Item bleibt sichtbar ***\n");
                            } else {
                                debug.append("*** UNBEKANNTE FARBE - Wird als uncraftbar behandelt, Item wird ausgeblendet ***\n");
                            }
                        } else {
                            debug.append("*** KEINE CRAFTING-INDIKATOREN - Item wird nicht behandelt ***\n");
                        }
                    } else {
                        debug.append("Keine Farbe gefunden\n");
                        if (hasCraftingIndicator) {
                            debug.append("*** UNCRAFTABLE ERKANNT - Keine Farbe = wei\u00df, Item wird ausgeblendet ***\n");
                        } else {
                            debug.append("*** KEINE CRAFTING-INDIKATOREN - Item wird nicht behandelt ***\n");
                        }
                    }
                }
            } else {
                debug.append("Kein Custom Name\n");
            }
            class_9323 components = itemStack.method_57353();
            if (components != null) {
                debug.append("Komponenten gefunden:\n");
                for (class_9336 component : components) {
                    debug.append("  - ").append(component.toString()).append("\n");
                }
            } else {
                debug.append("Keine speziellen Komponenten\n");
            }
        }
        catch (Exception e) {
            debug.append("Fehler beim Debuggen: ").append(e.getMessage()).append("\n");
        }
        return debug.toString();
    }

    static {
        SMITHING_CONFIG_KEYS.put("[Frostgeschmiedet]", "frostgeschmiedet");
        SMITHING_CONFIG_KEYS.put("[Lavageschmiedet]", "lavageschmiedet");
        SMITHING_CONFIG_KEYS.put("[Titangeschmiedet]", "titangeschmiedet");
        SMITHING_CONFIG_KEYS.put("[Drachengeschmiedet]", "drachengeschmiedet");
        SMITHING_CONFIG_KEYS.put("[D\u00e4monengeschmiedet]", "daemonengeschmiedet");
        SMITHING_CONFIG_KEYS.put("[Blitzgeschmiedet]", "blitzgeschmiedet");
        SMITHING_CONFIG_KEYS.put("[Sterngeschmiedet]", "sternengeschmiedet");
        SMITHING_CONFIG_KEYS.put("[Sternengeschmiedet]", "sternengeschmiedet");
    }
}

