/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.felix.CCLiveUtilitiesConfig;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class UpdateCheckerUtility {
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/nBXDNiuw/version";
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private static final Gson gson = new Gson();
    private static boolean updateCheckCompleted = false;
    private static boolean updateAvailable = false;
    private static String latestVersion = "";

    public static void initialize() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (!updateCheckCompleted) {
                UpdateCheckerUtility.checkForUpdates();
            }
        });
    }

    private static String getCurrentVersion() {
        try {
            return FabricLoader.getInstance().getModContainer("cclive-utilities").map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("1.4.2");
        }
        catch (Exception e) {
            System.out.println("Fehler beim Laden der Mod-Version: " + e.getMessage());
            return "1.4.2";
        }
    }

    private static void checkForUpdates() {
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).updateCheckerEnabled) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(MODRINTH_API_URL)).header("User-Agent", "CCLive-Utilities-UpdateChecker/1.0").GET().build();
                HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    UpdateCheckerUtility.parseUpdateResponse(response.body());
                } else {
                    System.out.println("Update-Check fehlgeschlagen: HTTP " + response.statusCode());
                }
            }
            catch (IOException | InterruptedException e) {
                System.out.println("Fehler beim Update-Check: " + e.getMessage());
            }
        });
    }

    private static void parseUpdateResponse(String jsonResponse) {
        try {
            JsonArray versions = (JsonArray)gson.fromJson(jsonResponse, JsonArray.class);
            String currentVersion = UpdateCheckerUtility.getCurrentVersion();
            if (versions != null && versions.size() > 0) {
                for (JsonElement element : versions) {
                    JsonObject version = element.getAsJsonObject();
                    String versionNumber = version.get("version_number").getAsString();
                    String versionType = version.get("version_type").getAsString();
                    if (!"release".equals(versionType) || !UpdateCheckerUtility.isNewerVersion(versionNumber, currentVersion)) continue;
                    latestVersion = versionNumber;
                    updateAvailable = true;
                    break;
                }
                if (updateAvailable) {
                    UpdateCheckerUtility.showUpdateMessage();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Fehler beim Parsen der Update-Response: " + e.getMessage());
        }
        updateCheckCompleted = true;
    }

    private static boolean isNewerVersion(String newVersion, String currentVersion) {
        String[] newParts = newVersion.split("\\.");
        String[] currentParts = currentVersion.split("\\.");
        int maxLength = Math.max(newParts.length, currentParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int currentPart;
            int newPart = i < newParts.length ? Integer.parseInt(newParts[i]) : 0;
            int n = currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            if (newPart > currentPart) {
                return true;
            }
            if (newPart >= currentPart) continue;
            return false;
        }
        return false;
    }

    private static void showUpdateMessage() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_5250 updateMessage = class_2561.method_43470((String)("\u00a7b[CCLive-Utilities] \u00a7fNeue Version verf\u00fcgbar: \u00a7a" + latestVersion));
            class_5250 infoMessage = class_2561.method_43470((String)"\u00a77Neuste Version hier: \u00a7bhttps://modrinth.com/mod/cclive-utilities");
            infoMessage.method_10862(infoMessage.method_10866().method_10958((class_2558)new class_2558.class_10608(URI.create("https://modrinth.com/mod/cclive-utilities"))));
            client.field_1724.method_7353((class_2561)updateMessage, false);
            client.field_1724.method_7353((class_2561)infoMessage, false);
        }
    }

    public static boolean isUpdateAvailable() {
        return updateAvailable;
    }

    public static String getLatestVersion() {
        return latestVersion;
    }
}

