/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;

public class AtlasTextureHelper {
    private static final Map<ResourceLocation, Function<ResourceLocation, TextureAtlasSprite>> ATLAS_CACHE = new HashMap<ResourceLocation, Function<ResourceLocation, TextureAtlasSprite>>();
    public static TextureAtlasSprite[] ENERGY_PARTICLE = new TextureAtlasSprite[5];
    public static TextureAtlasSprite[] SPARK_PARTICLE = new TextureAtlasSprite[7];
    public static TextureAtlasSprite[] SPELL_PARTICLE = new TextureAtlasSprite[7];
    public static TextureAtlasSprite[] MIXED_PARTICLE;
    public static TextureAtlasSprite ORB_PARTICLE;
    public static TextureAtlasSprite PORTAL_PARTICLE;
    public static TextureAtlasSprite ENERGY_CORE_OVERLAY;
    public static ParticleRenderType PARTICLE_SHEET_TRANSLUCENT;

    public static void init(IEventBus modBus) {
        modBus.addListener(AtlasTextureHelper::textureStitch);
    }

    private static void textureStitch(TextureAtlasStitchedEvent event) {
        TextureAtlas atlas = event.getAtlas();
        if (atlas.location().equals((Object)TextureAtlas.LOCATION_PARTICLES)) {
            int i;
            ATLAS_CACHE.clear();
            for (i = 0; i < ENERGY_PARTICLE.length; ++i) {
                AtlasTextureHelper.ENERGY_PARTICLE[i] = atlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("energy_" + i)));
            }
            for (i = 0; i < SPARK_PARTICLE.length; ++i) {
                AtlasTextureHelper.SPARK_PARTICLE[i] = atlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("spark_" + i)));
            }
            for (i = 0; i < SPELL_PARTICLE.length; ++i) {
                AtlasTextureHelper.SPELL_PARTICLE[i] = atlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("spell_" + i)));
            }
            MIXED_PARTICLE = (TextureAtlasSprite[])Stream.concat(Arrays.stream(SPARK_PARTICLE), Arrays.stream(SPELL_PARTICLE)).toArray(TextureAtlasSprite[]::new);
            ORB_PARTICLE = atlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"white_orb"));
            PORTAL_PARTICLE = atlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"portal"));
        }
        if (atlas.location().equals((Object)InventoryMenu.BLOCK_ATLAS)) {
            ENERGY_CORE_OVERLAY = atlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"block/energy_core/energy_core_overlay"));
        }
    }

    static {
        PARTICLE_SHEET_TRANSLUCENT = new ParticleRenderType(){

            public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
                return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            }
        };
    }
}

