/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.VBORenderType;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.shader.BCShader;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.client.shader.ChaosEntityShader;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.shader.ToolShader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Locale;
import java.util.function.Supplier;
import net.covers1624.quack.util.LazyValue;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ToolRenderBase
implements IItemRenderer {
    protected final TechLevel techLevel;
    protected final String tool;
    protected static float[][] baseColours = new float[][]{{0.0f, 0.5f, 0.8f, 1.0f}, {0.55f, 0.0f, 0.65f, 1.0f}, {0.8f, 0.5f, 0.1f, 1.0f}, {0.75f, 0.05f, 0.05f, 0.2f}};

    public ToolRenderBase(TechLevel techLevel, String tool) {
        this.techLevel = techLevel;
        this.tool = tool;
    }

    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        DEShaders.TOOL_BASE_SHADER.getUv1OverrideUniform().glUniform2i(packedOverlay & 0xFFFF, packedOverlay >> 16 & 0xFFFF);
        DEShaders.TOOL_BASE_SHADER.getUv2OverrideUniform().glUniform2i(packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        this.renderTool(ccrs, stack, transformType, mat, getter, transformType == ItemDisplayContext.GUI);
    }

    public abstract void renderTool(CCRenderState var1, ItemStack var2, ItemDisplayContext var3, Matrix4 var4, MultiBufferSource var5, boolean var6);

    public void transform(Matrix4 mat, double x, double y, double z, double scale) {
        mat.translate(x, y, z);
        mat.rotate(1.5707963267948701, Vector3.Y_NEG);
        mat.rotate(0.7853981633974351, Vector3.X_POS);
        mat.scale(scale);
    }

    @Nullable
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_TOOL;
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public static void glUniformBaseColor(BCShader<?> shader, TechLevel techLevel, float pulse) {
        ToolShader toolShader;
        if (!(shader instanceof ToolShader) || !(toolShader = (ToolShader)shader).hasBaseColorUniform()) {
            return;
        }
        float[] baseColour = baseColours[techLevel.index];
        float r = baseColour[0];
        float g = baseColour[1];
        float b = baseColour[2];
        float a = baseColour[3];
        switch (techLevel) {
            case DRACONIUM: 
            case WYVERN: 
            case DRACONIC: {
                a *= 1.0f + pulse;
                break;
            }
            case CHAOTIC: {
                r += pulse * 0.2f;
                g += pulse * 0.2f;
                b += pulse * 0.2f;
            }
        }
        toolShader.getBaseColorUniform().glUniform4f(r, g, b, a);
    }

    protected ToolPart basePart(CCModel model) {
        String levelName = this.techLevel.name().toLowerCase(Locale.ROOT);
        RenderType.CompositeRenderType baseType = RenderType.create((String)"draconicevolution:base", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.TOOL_BASE_SHADER).getShaderInstance())).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("textures/item/equipment/" + levelName + "_" + this.tool + ".png")), false, false)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(true));
        RenderType.CompositeRenderType guiType = RenderType.create((String)"draconicevolution:base_gui", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.TOOL_BASE_SHADER).getShaderInstance())).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("textures/item/equipment/" + levelName + "_" + this.tool + ".png")), false, false)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
        return new BaseToolPart(model, (RenderType)baseType, (RenderType)guiType, DEShaders.TOOL_BASE_SHADER);
    }

    protected ToolPart materialPart(CCModel model) {
        if (this.techLevel != TechLevel.CHAOTIC) {
            return this.basePart(model);
        }
        RenderType.CompositeRenderType chaoticType = RenderType.create((String)"draconicevolution:tool_chaos", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ((ChaosEntityShader)BCShaders.CHAOS_ENTITY_SHADER).getShaderInstance())).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"textures/item/equipment/chaos_shader.png"), true, false)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
        return new ChaoticToolPart(this, model, (RenderType)chaoticType, BCShaders.CHAOS_ENTITY_SHADER);
    }

    protected ToolPart gemPart(CCModel model) {
        String levelName = this.techLevel.name().toLowerCase(Locale.ROOT);
        RenderType.CompositeRenderType gemType = RenderType.create((String)"draconicevolution:tool_gem", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.TOOL_GEM_SHADER).getShaderInstance())).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("textures/item/equipment/shader_fallback_" + levelName + ".png")), false, false)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
        return new SimpleToolPart(model, (RenderType)gemType, DEShaders.TOOL_GEM_SHADER);
    }

    protected ToolPart tracePart(CCModel model) {
        String levelName = this.techLevel.name().toLowerCase(Locale.ROOT);
        RenderType.CompositeRenderType gemType = RenderType.create((String)"draconicevolution:tool_trace", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.TOOL_TRACE_SHADER).getShaderInstance())).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("textures/item/equipment/shader_fallback_" + levelName + ".png")), false, false)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
        return new SimpleToolPart(model, (RenderType)gemType, DEShaders.TOOL_TRACE_SHADER);
    }

    protected ToolPart bladePart(CCModel model) {
        String levelName = this.techLevel.name().toLowerCase(Locale.ROOT);
        RenderType.CompositeRenderType gemType = RenderType.create((String)"draconicevolution:tool_blade", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.TOOL_BLADE_SHADER).getShaderInstance())).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("textures/item/equipment/shader_fallback_" + levelName + ".png")), false, false)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
        return new SimpleToolPart(model, (RenderType)gemType, DEShaders.TOOL_BLADE_SHADER);
    }

    protected static class BaseToolPart
    extends ToolPart {
        private final Supplier<VBORenderType> vboType = new LazyValue(() -> new VBORenderType(type, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((VertexConsumer)builder, format);
            model.render(ccrs, new IVertexOperation[0]);
        }));
        private final Supplier<VBORenderType> guiVboType = new LazyValue(() -> new VBORenderType(guiType, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((VertexConsumer)builder, format);
            model.render(ccrs, new IVertexOperation[0]);
        }));

        public BaseToolPart(CCModel model, RenderType type, RenderType guiType, BCShader<?> shader) {
            super(shader);
        }

        @Override
        public void render(ItemDisplayContext transformType, MultiBufferSource buffers, Matrix4 mat, float pulse) {
            if (transformType == ItemDisplayContext.GUI) {
                this.guiVboType.get().withCallback(() -> this.shader.getModelMatUniform().glUniformMatrix4f(mat)).draw(buffers);
            } else {
                this.vboType.get().withCallback(() -> this.shader.getModelMatUniform().glUniformMatrix4f(mat)).draw(buffers);
            }
        }
    }

    protected static abstract class ToolPart {
        protected final BCShader<?> shader;

        protected ToolPart(BCShader<?> shader) {
            this.shader = shader;
        }

        public final void render(ItemDisplayContext transformType, MultiBufferSource buffers, Matrix4 mat) {
            this.render(transformType, buffers, mat, 1.0f);
        }

        public abstract void render(ItemDisplayContext var1, MultiBufferSource var2, Matrix4 var3, float var4);
    }

    protected class ChaoticToolPart
    extends SimpleToolPart {
        private final ChaosEntityShader shader;

        public ChaoticToolPart(ToolRenderBase this$0, CCModel model, RenderType baseType, ChaosEntityShader shader) {
            super(model, baseType, (BCShader<?>)shader);
            this.shader = shader;
        }

        @Override
        public void render(ItemDisplayContext transformType, MultiBufferSource buffers, Matrix4 mat, float pulse) {
            ((VBORenderType)this.vboType.get()).withCallback(() -> {
                this.shader.getDisableLightUniform().glUniform1b(true);
                this.shader.getDisableOverlayUniform().glUniform1b(true);
                this.shader.getAlphaUniform().glUniform1f(0.7f);
                this.shader.getModelMatUniform().glUniformMatrix4f(mat);
            }).draw(buffers);
        }
    }

    protected class SimpleToolPart
    extends ToolPart {
        protected final Supplier<VBORenderType> vboType;

        public SimpleToolPart(CCModel model, RenderType baseType, BCShader<?> shader) {
            super(shader);
            this.vboType = new LazyValue(() -> new VBORenderType(baseType, (format, builder) -> {
                CCRenderState ccrs = CCRenderState.instance();
                ccrs.reset();
                ccrs.bind((VertexConsumer)builder, format);
                model.render(ccrs, new IVertexOperation[0]);
            }));
        }

        @Override
        public void render(ItemDisplayContext transformType, MultiBufferSource buffers, Matrix4 mat, float pulse) {
            this.vboType.get().withCallback(() -> {
                ToolRenderBase.glUniformBaseColor(this.shader, ToolRenderBase.this.techLevel, pulse);
                this.shader.getModelMatUniform().glUniformMatrix4f(mat);
            }).draw(buffers);
        }
    }
}

