/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.brandonscore.inventory.SlotCheckValid;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ContainerJunkFilter
extends AbstractContainerMenu {
    private final ItemStack stack;
    private final Player player;
    private final PlayerSlot slot;
    private final IItemHandler itemHandler;

    public ContainerJunkFilter(@Nullable MenuType<?> type, int id, Player player, PlayerSlot slot, IItemHandler itemHandler) {
        super(type, id);
        this.player = player;
        this.slot = slot;
        this.itemHandler = itemHandler;
        this.stack = slot.getStackInSlot(player);
        this.addPlayerSlots(8, 29 + itemHandler.getSlots() / 9 * 18, 4);
        this.addJunkSlots(8, 21);
    }

    public void broadcastChanges() {
        if (this.stack != this.slot.getStackInSlot(this.player) && !this.player.level().isClientSide) {
            this.player.closeContainer();
        }
        super.broadcastChanges();
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && slotId < this.slots.size() && ((Slot)this.slots.get(slotId)).getItem() == this.stack) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    @Nullable
    public ItemStack quickMoveStack(Player playerIn, int i) {
        Slot slot = this.getSlot(i);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            ItemStack result = stack.copy();
            if (i >= 36 ? !this.moveItemStackTo(stack, 0, 36, false) : !this.moveItemStackTo(stack, 36, 36 + this.itemHandler.getSlots(), false)) {
                return ItemStack.EMPTY;
            }
            if (stack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(this.player, stack);
            return result;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slotID, int stateId, ItemStack stack) {
        Slot slot = this.getSlot(slotID);
        if (slot != null) {
            slot.set(stack);
        }
        this.stateId = stateId;
    }

    public Slot getSlot(int slotId) {
        if (slotId < this.slots.size() && slotId >= 0) {
            return (Slot)this.slots.get(slotId);
        }
        return null;
    }

    public void initializeContents(int stateId, List<ItemStack> stacks, ItemStack carried) {
        for (int i = 0; i < stacks.size(); ++i) {
            Slot slot = this.getSlot(i);
            if (slot == null) continue;
            slot.set(stacks.get(i));
        }
        this.carried = carried;
        this.stateId = stateId;
    }

    public void addPlayerSlots(int posX, int posY, int hotbarSpacing) {
        for (int x = 0; x < 9; ++x) {
            this.addSlot((Slot)new SlotCheckValid.IInv((Container)this.player.getInventory(), x, posX + 18 * x, posY + 54 + hotbarSpacing));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot((Slot)new SlotCheckValid.IInv((Container)this.player.getInventory(), x + y * 9 + 9, posX + 18 * x, posY + y * 18));
            }
        }
    }

    public void addJunkSlots(int posX, int posY) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            int x = i % 9 * 18;
            int y = i / 9 * 18;
            this.addSlot((Slot)new SlotItemHandler(this.itemHandler, i, posX + x, posY + y));
        }
    }
}

