/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.inventory.container.modular.ModularSlot;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.draconicevolution.blocks.tileentity.chest.TileDraconiumChest;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.CraftingInventoryWrapper;
import com.brandon3055.draconicevolution.inventory.DETileMenu;
import com.brandon3055.draconicevolution.inventory.ModularResultSlot;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class DraconiumChestMenu
extends DETileMenu<TileDraconiumChest> {
    public ModularResultSlot craftResultSlot;
    private final CraftingInventoryWrapper craftInventory;
    private final ResultContainerWrapper resultInventory;
    public final SlotGroup main = this.createSlotGroup(0, new int[]{1, 2, 3, 4});
    public final SlotGroup hotBar = this.createSlotGroup(0, new int[]{1, 2, 3, 4});
    public final SlotGroup chestInv = this.createSlotGroup(1, new int[]{0, 2, 3});
    public final SlotGroup furnaceInputs = this.createSlotGroup(2, new int[]{0, 1});
    public final SlotGroup capacitor = this.createSlotGroup(3, new int[]{0, 1});
    public final SlotGroup craftIn = this.createSlotGroup(4, new int[]{0, 1});
    public final SlotGroup craftOut = this.createSlotGroup(5, new int[]{0, 1});

    public DraconiumChestMenu(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        this((MenuType)DEContent.MENU_DRACONIUM_CHEST.get(), windowId, playerInv, (TileDraconiumChest)DraconiumChestMenu.getClientTile((Inventory)playerInv, (FriendlyByteBuf)extraData));
    }

    public DraconiumChestMenu(@Nullable MenuType<?> type, int windowId, Inventory inv, TileDraconiumChest tile) {
        super(type, windowId, inv, tile);
        this.hotBar.addPlayerBar(inv);
        this.main.addPlayerMain(inv);
        this.chestInv.addSlots(tile.mainInventory.getSlots(), 0, slot -> new ModularSlot((IItemHandler)tile.mainInventory, slot.intValue()));
        this.craftInventory = new CraftingInventoryWrapper((AbstractContainerMenu)this, 3, 3, (IItemHandlerModifiable)tile.craftingItems);
        this.resultInventory = new ResultContainerWrapper(tile.craftingItems, 9);
        this.craftResultSlot = new ModularResultSlot(inv.player, (CraftingContainer)this.craftInventory, this.resultInventory, 0, 0, 0);
        this.craftOut.addSlot((ModularSlot)this.craftResultSlot);
        this.craftIn.addSlots(this.craftInventory.getContainerSize(), 0, slot -> new ModularSlot((Container)this.craftInventory, slot.intValue()));
        this.furnaceInputs.addSlots(tile.furnaceItems.getSlots(), 0, slot -> new ModularSlot((IItemHandler)tile.furnaceItems, slot.intValue()));
        this.capacitor.addSlot(new ModularSlot((IItemHandler)tile.capacitorInv, 0));
        this.slotsChanged((Container)inv);
    }

    protected void slotChangedCraftingGrid(int containerID, Level level, Player player, CraftingContainer craftingInventory, ResultContainerWrapper resultInventory) {
        if (!level.isClientSide) {
            RecipeHolder icraftingrecipe;
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = level.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingInventory.asCraftInput(), level);
            if (optional.isPresent() && resultInventory.setRecipeUsed(level, serverplayerentity, icraftingrecipe = (RecipeHolder)optional.get())) {
                itemstack = ((CraftingRecipe)icraftingrecipe.value()).assemble((RecipeInput)craftingInventory.asCraftInput(), (HolderLookup.Provider)level.registryAccess());
            }
            resultInventory.setItem(0, itemstack);
            serverplayerentity.connection.send((Packet)new ClientboundContainerSetSlotPacket(containerID, this.stateId, ((Slot)this.craftResultSlot).index, itemstack));
        }
    }

    public void slotsChanged(Container inventory) {
        this.slotChangedCraftingGrid(this.containerId, ((TileDraconiumChest)this.tile).getLevel(), this.player, (CraftingContainer)this.craftInventory, this.resultInventory);
    }

    public static class ResultContainerWrapper
    implements Container,
    RecipeCraftingHolder {
        private final TileItemStackHandler stackHandler;
        private final int slot;
        @Nullable
        private RecipeHolder<?> recipeUsed;

        public ResultContainerWrapper(TileItemStackHandler stackHandler, int slot) {
            this.stackHandler = stackHandler;
            this.slot = slot;
        }

        public int getContainerSize() {
            return 1;
        }

        public boolean isEmpty() {
            return this.stackHandler.getStackInSlot(this.slot).isEmpty();
        }

        public ItemStack getItem(int p_40147_) {
            return this.stackHandler.getStackInSlot(this.slot);
        }

        public ItemStack removeItem(int p_40149_, int p_40150_) {
            ItemStack stack = this.stackHandler.getStackInSlot(this.slot);
            this.stackHandler.setStackInSlot(this.slot, ItemStack.EMPTY);
            return stack;
        }

        public ItemStack removeItemNoUpdate(int p_40160_) {
            return this.removeItem(0, 0);
        }

        public void setItem(int p_40152_, ItemStack stack) {
            this.stackHandler.setStackInSlot(this.slot, stack);
        }

        public void setChanged() {
        }

        public boolean stillValid(Player p_40155_) {
            return true;
        }

        public void clearContent() {
            this.stackHandler.setStackInSlot(this.slot, ItemStack.EMPTY);
        }

        public void setRecipeUsed(@Nullable RecipeHolder<?> p_301012_) {
            this.recipeUsed = p_301012_;
        }

        @Nullable
        public RecipeHolder<?> getRecipeUsed() {
            return this.recipeUsed;
        }
    }
}

