/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class SpacedSelectionList<E extends Entry<E>>
extends ObjectSelectionList<E> {
    public int padding;

    public SpacedSelectionList(Minecraft minecraft, int width, int height, int y, int itemHeight, int padding) {
        super(minecraft, width, height, y, itemHeight);
        this.padding = padding;
    }

    public E getEntryAtPosition(double mouseX, double mouseY) {
        int i = this.getRowWidth() / 2;
        int j = this.getX() + this.width / 2;
        int m = Mth.floor((double)(mouseY - (double)this.getY())) + (int)this.getScrollAmount() - this.padding;
        int n = m / this.itemHeight;
        return (E)((Object)(mouseX >= (double)(j - i) && mouseX <= (double)(j + i) && n >= 0 && m >= 0 && n < this.getItemCount() ? (Entry)((Object)this.children().get(n)) : null));
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.height);
    }

    public int getMaxPosition() {
        return this.padding + this.getItemCount() * this.itemHeight + this.padding;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.hovered = this.isMouseOver(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.enableScissor(guiGraphics);
        this.renderList(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.disableScissor();
        if (this.getMaxScroll() > 0) {
            int i = this.getScrollbarPosition();
            int j = (int)((float)(this.height * this.height) / (float)this.getMaxPosition());
            j = Mth.clamp((int)j, (int)32, (int)(this.height - 8));
            int k = (int)this.getScrollAmount() * (this.height - j) / this.getMaxScroll() + this.getY();
            if (k < this.getY()) {
                k = this.getY();
            }
            RenderSystem.enableBlend();
            guiGraphics.fill(i, this.getY(), i + 6, this.getBottom(), -16777216);
            guiGraphics.blitSprite(ResourceLocation.tryParse((String)"widget/scroller"), i, k, 6, j);
            RenderSystem.disableBlend();
        }
    }

    public void ensureVisible(E entry) {
        int k;
        int i = this.getRowTop(this.children().indexOf(entry));
        int j = i - this.getY() - this.padding - this.itemHeight;
        if (j < 0) {
            this.setScrollAmount(this.getScrollAmount() + (double)j);
        }
        if ((k = this.getBottom() - i - this.itemHeight - this.itemHeight) < 0) {
            this.setScrollAmount(this.getScrollAmount() + (double)(-k));
        }
    }

    public int getScrollbarPosition() {
        return this.getRowRight() + this.padding - 6;
    }

    public void renderList(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (int m = 0; m < this.getItemCount(); ++m) {
            int n = this.getRowTop(m);
            int o = this.getRowBottom(m);
            if (o < this.getY() || n > this.getBottom()) continue;
            this.renderItem(guiGraphics, mouseX, mouseY, partialTick, m, this.getRowLeft(), n, this.getRowWidth(), this.itemHeight);
        }
    }

    public void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        int i = this.getX() + (this.width - width) / 2;
        int j = this.getX() + (this.width + width) / 2;
        guiGraphics.fill(i, top, j, top + this.itemHeight, outerColor);
        guiGraphics.fill(i + 1, top + 1, j - 1, top + this.itemHeight - 1, innerColor);
    }

    public int getRowLeft() {
        return this.getX() + this.padding;
    }

    public int getRowTop(int index) {
        return this.getY() + this.padding - (int)this.getScrollAmount() + index * this.itemHeight;
    }

    public int getRowWidth() {
        return this.width - this.padding * 2;
    }

    public static abstract class Entry<E extends Entry<E>>
    extends ObjectSelectionList.Entry<E> {
    }
}

