/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import dev.yurisuika.raised.client.RaisedOptions;
import dev.yurisuika.raised.client.gui.GuiComponentInterface;
import dev.yurisuika.raised.client.gui.Layer;
import dev.yurisuika.raised.client.gui.components.SpacedSelectionList;
import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Configure;
import dev.yurisuika.raised.util.Icon;
import dev.yurisuika.raised.util.Parse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class RaisedScreen
extends Screen {
    public Screen parent;
    public ArrayList<AbstractWidget> options;
    public ArrayList<AbstractWidget> controls;
    public LayerList layers;
    public static ResourceLocation current = LayerRegistry.HOTBAR;
    public final int SPACING = 5;
    public final int PADDING = 8;
    public final int WIDGET_WIDTH_WIDE = 150;
    public final int WIDGET_WIDTH_SQUARE = 20;
    public final int WIDGET_HEIGHT = 20;
    public final int HEADER_HEIGHT = 36;
    public final int PANEL_WIDTH = 166;

    public RaisedScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"options.raised.title"));
        this.parent = parent;
    }

    public void m_7856_() {
        this.addOptions();
        this.addControls();
        this.addLayers();
        this.repositionElements();
    }

    public void addOptions() {
        this.options = new ArrayList();
        this.options.add(new OptionInstance("options.raised.displacement.x", OptionInstance.m_231535_((Component)Component.m_237115_((String)"options.raised.displacement.x.tooltip")), (prefix, value) -> Options.m_231921_((Component)prefix, (Component)(value == 0 ? CommonComponents.f_130654_ : Component.m_237113_((String)(Configure.getDisplacementX(current.toString()) + "px (" + Math.round(Math.ceil(value.floatValue() / ((float)this.f_96543_ / 4.0f) * 100.0f)) + "%)")))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, this.f_96543_ / 4), (Object)Configure.getDisplacementX(current.toString()), value -> Configure.setDisplacementX(current.toString(), value)).m_231507_(this.f_96541_.f_91066_, 8, 44, 150));
        this.options.add(new OptionInstance("options.raised.displacement.y", OptionInstance.m_231535_((Component)Component.m_237115_((String)"options.raised.displacement.y.tooltip")), (prefix, value) -> Options.m_231921_((Component)prefix, (Component)(value == 0 ? CommonComponents.f_130654_ : Component.m_237113_((String)(Configure.getDisplacementY(current.toString()) + "px (" + Math.round(Math.ceil(value.floatValue() / ((float)this.f_96544_ / 4.0f) * 100.0f)) + "%)")))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, this.f_96544_ / 4), (Object)Configure.getDisplacementY(current.toString()), value -> Configure.setDisplacementY(current.toString(), value)).m_231507_(this.f_96541_.f_91066_, 8, 69, 150));
        this.options.add(new OptionInstance("options.raised.direction.x", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"options.raised.direction.x.tooltip")), OptionInstance.m_231546_(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(Layer.Direction.X.values()), Codec.INT.xmap(Layer.Direction.X::byId, Layer.Direction.X::m_35965_)), (Object)Layer.Direction.X.byName(Configure.getDirectionX(current.toString()).m_7912_()), value -> Configure.setDirectionX(current.toString(), value)).m_231507_(this.f_96541_.f_91066_, 8, 94, 150));
        this.options.add(new OptionInstance("options.raised.direction.y", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"options.raised.direction.y.tooltip")), OptionInstance.m_231546_(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(Layer.Direction.Y.values()), Codec.INT.xmap(Layer.Direction.Y::byId, Layer.Direction.Y::m_35965_)), (Object)Layer.Direction.Y.byName(Configure.getDirectionY(current.toString()).m_7912_()), value -> Configure.setDirectionY(current.toString(), value)).m_231507_(this.f_96541_.f_91066_, 8, 119, 150));
        this.options.add(new OptionInstance("options.raised.sync", value -> Tooltip.m_257550_((Component)Component.m_237110_((String)"options.raised.sync.tooltip", (Object[])new Object[]{value.toString()})), (prefix, value) -> Component.m_237113_((String)Parse.parsePath(value)), (OptionInstance.ValueSet)new OptionInstance.Enum(LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).toList(), ResourceLocation.f_135803_), (Object)ResourceLocation.m_135820_((String)Configure.getSync(current.toString())), value -> Configure.setSync(current.toString(), value.toString())).m_231507_(this.f_96541_.f_91066_, 8, 144, 150));
        this.options.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public void addControls() {
        this.controls = new ArrayList();
        this.controls.add((AbstractWidget)Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.getPrevious()).m_253046_(20, 20).m_252794_(this.f_96543_ - 158, 8).m_253136_());
        this.controls.add((AbstractWidget)Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.getNext()).m_253046_(20, 20).m_252794_(this.f_96543_ - 28, 8).m_253136_());
        this.controls.add((AbstractWidget)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_253046_(150, 20).m_252794_(8, this.f_96544_ - 28).m_253136_());
        this.controls.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public void addLayers() {
        this.layers = new LayerList(this.f_96541_, 166, this.f_96544_ - 36);
        this.m_142416_((GuiEventListener)this.layers);
    }

    public void getPrevious() {
        HashSet mods = new HashSet();
        LayerRegistry.LAYERS.keySet().forEach(key -> mods.add(key.m_135827_()));
        List keys = mods.stream().toList();
        int index = keys.indexOf(current.m_135827_()) - 1;
        String mod = index < 0 ? (String)keys.get(keys.size() - 1) : (String)keys.get(index);
        this.setMod(mod);
    }

    public void getNext() {
        HashSet mods = new HashSet();
        LayerRegistry.LAYERS.keySet().forEach(key -> mods.add(key.m_135827_()));
        List keys = mods.stream().toList();
        int index = keys.indexOf(current.m_135827_()) + 1;
        String mod = index >= keys.size() ? (String)keys.get(0) : (String)keys.get(index);
        this.setMod(mod);
    }

    public void setMod(String mod) {
        current = LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).filter(name -> name.m_135827_().equals(mod)).toList().get(0);
        this.resetOptions();
        this.resetLayers();
        this.resetControls();
    }

    public void resetOptions() {
        this.options.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.options.clear();
        this.addOptions();
    }

    public void resetControls() {
        this.controls.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.controls.clear();
        this.addControls();
    }

    public void resetLayers() {
        this.layers.setLayers();
    }

    public void repositionElements() {
        this.layers.m_93437_(166, this.f_96544_ - 36, 36, this.f_96544_);
        this.layers.m_93507_(this.f_96543_ - 166);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.parent != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        if (Configure.getLayer(current.toString()) != null) {
            if (Configure.getDisplacementX(current.toString()) > width / 4) {
                Configure.setDisplacementX(current.toString(), width / 4);
            }
            if (Configure.getDisplacementY(current.toString()) > height / 4) {
                Configure.setDisplacementY(current.toString(), height / 4);
            }
        }
        this.resetOptions();
        this.resetControls();
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_86412_(poseStack, mouseX, mouseY, partialTick);
        RaisedScreen.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)this.f_96543_, (int)36, (int)0x40000000);
        RaisedScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)83, (int)14, (int)-1);
        ((GuiComponentInterface)((Object)this)).renderScrollingString(poseStack, this.f_96547_, (Component)Component.m_237113_((String)Parse.parseNamespace(current)), this.f_96543_ - 138, 8, this.f_96543_ - 28, 28, -1);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        if (RaisedOptions.OPTIONS.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return true;
    }

    public class LayerList
    extends SpacedSelectionList<Entry> {
        public LayerList(Minecraft minecraft, int width, int height) {
            super(minecraft, width, height, 36, RaisedScreen.this.f_96544_, 20, 8);
            this.setLayers();
        }

        public void setLayers() {
            this.m_93516_();
            LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).filter(location -> location.m_135827_().equals(current.m_135827_())).forEach(name -> this.m_7085_((AbstractSelectionList.Entry)new Entry((ResourceLocation)name)));
        }

        public boolean m_5694_() {
            return RaisedScreen.this.m_7222_() == this;
        }

        public class Entry
        extends SpacedSelectionList.Entry<Entry> {
            public final ResourceLocation name;

            public Entry(ResourceLocation name) {
                this.name = name;
                this.setCurrent(current.equals((Object)name));
            }

            public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                ((GuiComponentInterface)((Object)RaisedScreen.this)).renderScrollingString(poseStack, Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)Parse.parsePath(this.name)), left + 20, top, left + 130, top + 20, -1);
                RenderSystem.m_157456_((int)0, (ResourceLocation)Icon.getLayerIcon(this.name));
                GuiComponent.m_93133_((PoseStack)poseStack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
                RenderSystem.m_157456_((int)0, (ResourceLocation)ResourceLocation.m_135820_((String)("raised:textures/gui/direction/" + Configure.getDirectionX(this.name.toString()).toString().toLowerCase() + "_" + Configure.getDirectionY(this.name.toString()).toString().toLowerCase() + ".png")));
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + 130), (int)top, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{Parse.parsePath(this.name)});
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.setCurrent(true);
                return true;
            }

            public void setCurrent(boolean current) {
                if (current) {
                    RaisedScreen.current = this.name;
                    RaisedScreen.this.resetOptions();
                    LayerList.this.m_6987_((AbstractSelectionList.Entry)this);
                }
            }
        }
    }
}

