/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui;

import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Translate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GuiEvents {
    public static final Map<ResourceLocation, IIngameOverlay> MODS = new HashMap<ResourceLocation, IIngameOverlay>();
    public boolean translated = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void startTranslate(RenderGameOverlayEvent.PreLayer event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getOverlay());
        if (name != null && LayerRegistry.LAYERS.containsKey(name) && !this.translated) {
            this.translated = true;
            Translate.start(event.getMatrixStack(), name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void endTranslate(RenderGameOverlayEvent.PreLayer event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getOverlay());
        if (name != null && LayerRegistry.LAYERS.containsKey(name) && event.isCanceled() && this.translated) {
            this.translated = false;
            Translate.end(event.getMatrixStack(), name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void endTranslate(RenderGameOverlayEvent.PostLayer event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getOverlay());
        if (name != null && LayerRegistry.LAYERS.containsKey(name) && this.translated) {
            this.translated = false;
            Translate.end(event.getMatrixStack(), name);
        }
    }

    public static ResourceLocation formatOverlay(IIngameOverlay overlay) {
        if (overlay.equals((Object)ForgeIngameGui.HOTBAR_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.PLAYER_HEALTH_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.ARMOR_LEVEL_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.FOOD_LEVEL_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.AIR_LEVEL_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.MOUNT_HEALTH_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.JUMP_BAR_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.ITEM_NAME_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.RECORD_OVERLAY_ELEMENT)) {
            return LayerRegistry.HOTBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.CHAT_PANEL_ELEMENT)) {
            return LayerRegistry.CHAT;
        }
        if (overlay.equals((Object)ForgeIngameGui.BOSS_HEALTH_ELEMENT)) {
            return LayerRegistry.BOSSBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.SCOREBOARD_ELEMENT)) {
            return LayerRegistry.SIDEBAR;
        }
        if (overlay.equals((Object)ForgeIngameGui.POTION_ICONS_ELEMENT)) {
            return LayerRegistry.EFFECTS;
        }
        if (overlay.equals((Object)ForgeIngameGui.PLAYER_LIST_ELEMENT)) {
            return LayerRegistry.PLAYERS;
        }
        if (overlay.equals((Object)ForgeIngameGui.TITLE_TEXT_ELEMENT)) {
            return LayerRegistry.TITLES;
        }
        if (overlay.equals((Object)ForgeIngameGui.SUBTITLES_ELEMENT)) {
            return LayerRegistry.SUBTITLES;
        }
        if (MODS.containsValue(overlay)) {
            return MODS.entrySet().stream().filter(entry -> ((IIngameOverlay)entry.getValue()).equals((Object)overlay)).map(Map.Entry::getKey).findFirst().get();
        }
        return null;
    }
}

