/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;

public abstract class SpacedSelectionList<E extends Entry<E>>
extends ObjectSelectionList<E> {
    public int padding;

    public SpacedSelectionList(Minecraft minecraft, int width, int height, int y, int itemHeight, int padding) {
        super(minecraft, width, height, y, itemHeight);
        this.padding = padding;
    }

    public int getFirstEntryY() {
        return this.getY() + this.padding;
    }

    public int getNextY() {
        int i = this.getY() + this.padding - (int)this.scrollAmount();
        for (Entry entry : this.children()) {
            i += entry.getHeight();
        }
        return i;
    }

    public int contentHeight() {
        int i = 0;
        for (Entry entry : this.children()) {
            i += entry.getHeight();
        }
        return i + this.padding * 2;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.hovered = this.isMouseOver(mouseX, mouseY) ? (Entry)this.getEntryAtPosition(mouseX, mouseY) : null;
        this.enableScissor(guiGraphics);
        this.renderListItems(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.disableScissor();
        this.renderScrollbar(guiGraphics, mouseX, mouseY);
    }

    public void scrollToEntry(E entry) {
        int j;
        int i = entry.getY() - this.getY() - this.padding;
        if (i < 0) {
            this.setScrollAmount(this.scrollAmount() + (double)i);
        }
        if ((j = this.getBottom() - entry.getY() - entry.getHeight() - this.padding) < 0) {
            this.setScrollAmount(this.scrollAmount() + (double)(-j));
        }
    }

    public int scrollBarX() {
        return this.getRowRight() + this.padding - 6;
    }

    public void renderListItems(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Entry entry : this.children()) {
            if (entry.getY() + entry.getHeight() < this.getY() || entry.getY() > this.getBottom()) continue;
            this.renderItem(guiGraphics, mouseX, mouseY, partialTick, (AbstractSelectionList.Entry)entry);
        }
    }

    public int getRowLeft() {
        return this.getX() + this.padding;
    }

    public int getRowWidth() {
        return this.width - this.padding * 2;
    }

    public static abstract class Entry<E extends Entry<E>>
    extends ObjectSelectionList.Entry<E> {
        public int getContentX() {
            return this.getX();
        }

        public int getContentY() {
            return this.getY();
        }

        public int getContentHeight() {
            return this.getHeight();
        }

        public int getContentWidth() {
            return this.getWidth();
        }
    }
}

