/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.mixin.neoforge.client.gui;

import dev.yurisuika.raised.client.gui.Layer;
import dev.yurisuika.raised.client.gui.MappedLayers;
import dev.yurisuika.raised.registry.LayerRegistry;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.GuiLayerManager;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GuiLayerManager.class}, remap=false)
public abstract class GuiLayerManagerMixin {
    @Inject(method={"add(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/gui/LayeredDraw$Layer;)Lnet/neoforged/neoforge/client/gui/GuiLayerManager;"}, at={@At(value="RETURN")})
    private void registerLayer(ResourceLocation name, LayeredDraw.Layer layer, CallbackInfoReturnable<GuiLayerManager> cir) {
        this.addLayer(name);
    }

    @Unique
    public void addLayer(ResourceLocation name) {
        ResourceLocation formattedName = name;
        if (!name.getNamespace().equals("minecraft")) {
            LayerRegistry.register(name, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.NONE, name));
        } else {
            formattedName = this.formatName(name);
        }
        if (formattedName != null) {
            MappedLayers.MAPPED_LAYERS.put(name, formattedName);
        }
    }

    @Unique
    public ResourceLocation formatName(ResourceLocation name) {
        if (name.equals((Object)VanillaGuiLayers.HOTBAR)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.PLAYER_HEALTH)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.ARMOR_LEVEL)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.FOOD_LEVEL)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.AIR_LEVEL)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.VEHICLE_HEALTH)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.JUMP_METER)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.EXPERIENCE_BAR)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.EXPERIENCE_LEVEL)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.SELECTED_ITEM_NAME)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.SPECTATOR_TOOLTIP)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.OVERLAY_MESSAGE)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.CHAT)) {
            return LayerRegistry.CHAT;
        }
        if (name.equals((Object)VanillaGuiLayers.BOSS_OVERLAY)) {
            return LayerRegistry.BOSSBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.SCOREBOARD_SIDEBAR)) {
            return LayerRegistry.SIDEBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.EFFECTS)) {
            return LayerRegistry.EFFECTS;
        }
        if (name.equals((Object)VanillaGuiLayers.TAB_LIST)) {
            return LayerRegistry.PLAYERS;
        }
        if (name.equals((Object)VanillaGuiLayers.TITLE)) {
            return LayerRegistry.TITLES;
        }
        if (name.equals((Object)VanillaGuiLayers.SUBTITLE_OVERLAY)) {
            return LayerRegistry.SUBTITLES;
        }
        return null;
    }
}

