/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui;

import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Translate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GuiEvents {
    public boolean translated = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void startTranslate(RenderGameOverlayEvent.Pre event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getType());
        if (name != null && !name.equals((Object)LayerRegistry.OTHER) && LayerRegistry.LAYERS.containsKey(name) && !this.translated) {
            this.translated = true;
            Translate.start(name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void endTranslate(RenderGameOverlayEvent.Pre event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getType());
        if (name != null && !name.equals((Object)LayerRegistry.OTHER) && LayerRegistry.LAYERS.containsKey(name) && event.isCanceled() && this.translated) {
            this.translated = false;
            Translate.end(name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void endTranslate(RenderGameOverlayEvent.Post event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getType());
        if (name != null && !name.equals((Object)LayerRegistry.OTHER) && LayerRegistry.LAYERS.containsKey(name) && this.translated) {
            this.translated = false;
            Translate.end(name);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void startAllPreTranslate(RenderGameOverlayEvent.Pre event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getType());
        if (name != null && name.equals((Object)LayerRegistry.OTHER) && LayerRegistry.LAYERS.containsKey(name) && !this.translated) {
            this.translated = true;
            Translate.start(name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void endAllPreTranslate(RenderGameOverlayEvent.Pre event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getType());
        if (name != null && name.equals((Object)LayerRegistry.OTHER) && LayerRegistry.LAYERS.containsKey(name) && this.translated) {
            this.translated = false;
            Translate.end(name);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void startAllPostTranslate(RenderGameOverlayEvent.Post event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getType());
        if (name != null && name.equals((Object)LayerRegistry.OTHER) && LayerRegistry.LAYERS.containsKey(name) && !this.translated) {
            this.translated = true;
            Translate.start(name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void endAllPostTranslate(RenderGameOverlayEvent.Post event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getType());
        if (name != null && name.equals((Object)LayerRegistry.OTHER) && LayerRegistry.LAYERS.containsKey(name) && this.translated) {
            this.translated = false;
            Translate.end(name);
        }
    }

    public static ResourceLocation formatOverlay(RenderGameOverlayEvent.ElementType elementType) {
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR)) {
            return LayerRegistry.HOTBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.HEALTH)) {
            return LayerRegistry.HOTBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.ARMOR)) {
            return LayerRegistry.HOTBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.FOOD)) {
            return LayerRegistry.HOTBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.AIR)) {
            return LayerRegistry.HOTBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.HEALTHMOUNT)) {
            return LayerRegistry.HOTBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.JUMPBAR)) {
            return LayerRegistry.HOTBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return LayerRegistry.HOTBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.CHAT)) {
            return LayerRegistry.CHAT;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            return LayerRegistry.BOSSBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.BOSSINFO)) {
            return LayerRegistry.BOSSBAR;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.POTION_ICONS)) {
            return LayerRegistry.EFFECTS;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.PLAYER_LIST)) {
            return LayerRegistry.PLAYERS;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.SUBTITLES)) {
            return LayerRegistry.SUBTITLES;
        }
        if (elementType.equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            return LayerRegistry.OTHER;
        }
        return null;
    }
}

