/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.yurisuika.raised.client.RaisedOptions;
import dev.yurisuika.raised.client.gui.GuiComponentInterface;
import dev.yurisuika.raised.client.gui.Layer;
import dev.yurisuika.raised.client.gui.components.SpacedSelectionList;
import dev.yurisuika.raised.mixin.client.gui.components.SliderButtonAccessor;
import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Configure;
import dev.yurisuika.raised.util.Icon;
import dev.yurisuika.raised.util.Parse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.OptionSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.OptionButton;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.settings.IteratableOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RaisedScreen
extends Screen {
    public Screen parent;
    public ArrayList<Widget> options;
    public ArrayList<Widget> controls;
    public LayerList layers;
    public static ResourceLocation current = LayerRegistry.HOTBAR;
    public final int SPACING = 5;
    public final int PADDING = 8;
    public final int WIDGET_WIDTH_WIDE = 150;
    public final int WIDGET_WIDTH_SQUARE = 20;
    public final int WIDGET_HEIGHT = 20;
    public final int HEADER_HEIGHT = 36;
    public final int PANEL_WIDTH = 166;

    public RaisedScreen(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("options.raised.title"));
        this.parent = parent;
    }

    public void func_231160_c_() {
        this.addOptions();
        this.addControls();
        this.addLayers();
        this.repositionElements();
    }

    public void addOptions() {
        this.options = new ArrayList();
        this.options.add(new SliderPercentageOption("options.raised.displacement.x", 0.0, (double)this.field_230708_k_ / 4.0, 1.0f, options -> Configure.getDisplacementX(current.toString()), (options, value) -> Configure.setDisplacementX(current.toString(), value.intValue()), (options, option) -> {
            option.func_241567_a_(this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("options.raised.displacement.x.tooltip"), 200));
            return new TranslationTextComponent("options.raised.displacement.x").func_240702_b_(": ").func_230529_a_((ITextComponent)(option.func_216729_a(options) == 0.0 ? DialogTexts.field_240631_b_ : new StringTextComponent(Configure.getDisplacementX(current.toString()) + "px (" + Math.round(Math.ceil((float)option.func_216729_a(options) / (float)option.func_216733_c() * 100.0f)) + "%)")));
        }).func_216586_a(this.field_230706_i_.field_71474_y, 8, 44, 150));
        this.options.add(new SliderPercentageOption("options.raised.displacement.y", 0.0, (double)this.field_230709_l_ / 4.0, 1.0f, options -> Configure.getDisplacementY(current.toString()), (options, value) -> Configure.setDisplacementY(current.toString(), value.intValue()), (options, option) -> {
            option.func_241567_a_(this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("options.raised.displacement.y.tooltip"), 200));
            return new TranslationTextComponent("options.raised.displacement.y").func_240702_b_(": ").func_230529_a_((ITextComponent)(option.func_216729_a(options) == 0.0 ? DialogTexts.field_240631_b_ : new StringTextComponent(Configure.getDisplacementY(current.toString()) + "px (" + Math.round(Math.ceil((float)option.func_216729_a(options) / (float)option.func_216733_c() * 100.0f)) + "%)")));
        }).func_216586_a(this.field_230706_i_.field_71474_y, 8, 69, 150));
        this.options.add(new IteratableOption("options.raised.direction.x", (options, integer) -> Configure.setDirectionX(current.toString(), Layer.Direction.X.byId(Configure.getDirectionX(current.toString()).getId() < Layer.Direction.X.values().length - 1 ? Configure.getDirectionX(current.toString()).getId() + 1 : 0)), (options, option) -> {
            option.func_241567_a_(this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("options.raised.direction.x.tooltip"), 200));
            return new TranslationTextComponent("options.raised.direction.x").func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent(Configure.getDirectionX(current.toString()).getKey()));
        }).func_216586_a(this.field_230706_i_.field_71474_y, 8, 94, 150));
        this.options.add(new IteratableOption("options.raised.direction.y", (options, integer) -> Configure.setDirectionY(current.toString(), Layer.Direction.Y.byId(Configure.getDirectionY(current.toString()).getId() < Layer.Direction.Y.values().length - 1 ? Configure.getDirectionY(current.toString()).getId() + 1 : 0)), (options, option) -> {
            option.func_241567_a_(this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("options.raised.direction.y.tooltip"), 200));
            return new TranslationTextComponent("options.raised.direction.y").func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent(Configure.getDirectionY(current.toString()).getKey()));
        }).func_216586_a(this.field_230706_i_.field_71474_y, 8, 119, 150));
        this.options.add(new IteratableOption("options.raised.sync", (options, integer) -> {
            List names = LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).collect(Collectors.toList());
            int index = names.indexOf(ResourceLocation.func_208304_a((String)Configure.getSync(current.toString())));
            Configure.setSync(current.toString(), ((ResourceLocation)names.get(index < names.size() - 1 ? index + 1 : 0)).toString());
        }, (options, option) -> {
            option.func_241567_a_(this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("options.raised.sync.tooltip", new Object[]{Configure.getSync(current.toString())}), 200));
            return new TranslationTextComponent("options.raised.sync").func_240702_b_(": ").func_240702_b_(Parse.parsePath(ResourceLocation.func_208304_a((String)Configure.getSync(current.toString()))));
        }).func_216586_a(this.field_230706_i_.field_71474_y, 8, 144, 150));
        this.options.forEach(x$0 -> this.func_230480_a_((Widget)x$0));
    }

    public void addControls() {
        this.controls = new ArrayList();
        this.controls.add((Widget)new Button(this.field_230708_k_ - 158, 8, 20, 20, (ITextComponent)new StringTextComponent("<"), button -> this.getPrevious()));
        this.controls.add((Widget)new Button(this.field_230708_k_ - 28, 8, 20, 20, (ITextComponent)new StringTextComponent(">"), button -> this.getNext()));
        this.controls.add((Widget)new Button(8, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240632_c_, button -> this.func_231175_as__()));
        this.controls.forEach(x$0 -> this.func_230480_a_((Widget)x$0));
    }

    public void addLayers() {
        this.layers = new LayerList(this.field_230706_i_, 166, this.field_230709_l_ - 36);
        this.func_230481_d_((IGuiEventListener)this.layers);
    }

    public void getPrevious() {
        HashSet mods = new HashSet();
        LayerRegistry.LAYERS.keySet().forEach(key -> mods.add(key.func_110624_b()));
        List keys = mods.stream().collect(Collectors.toList());
        int index = keys.indexOf(current.func_110624_b()) - 1;
        String mod = index < 0 ? (String)keys.get(keys.size() - 1) : (String)keys.get(index);
        this.setMod(mod);
    }

    public void getNext() {
        HashSet mods = new HashSet();
        LayerRegistry.LAYERS.keySet().forEach(key -> mods.add(key.func_110624_b()));
        List keys = mods.stream().collect(Collectors.toList());
        int index = keys.indexOf(current.func_110624_b()) + 1;
        String mod = index >= keys.size() ? (String)keys.get(0) : (String)keys.get(index);
        this.setMod(mod);
    }

    public void setMod(String mod) {
        current = (ResourceLocation)LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).filter(name -> name.func_110624_b().equals(mod)).collect(Collectors.toList()).get(0);
        this.resetOptions();
        this.resetLayers();
        this.resetControls();
    }

    public void resetOptions() {
        this.options.forEach(widget -> {
            this.field_230710_m_.remove(widget);
            this.field_230705_e_.remove(widget);
        });
        this.options.clear();
        this.addOptions();
    }

    public void resetControls() {
        this.controls.forEach(widget -> {
            this.field_230710_m_.remove(widget);
            this.field_230705_e_.remove(widget);
        });
        this.controls.clear();
        this.addControls();
    }

    public void resetLayers() {
        this.layers.setLayers();
    }

    public void repositionElements() {
        this.layers.func_230940_a_(166, this.field_230709_l_ - 36, 36, this.field_230709_l_);
        this.layers.func_230959_g_(this.field_230708_k_ - 166);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        if (this.parent != null) {
            this.field_230706_i_.func_147108_a(this.parent);
        }
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        super.func_231152_a_(minecraft, width, height);
        if (Configure.getLayer(current.toString()) != null) {
            if (Configure.getDisplacementX(current.toString()) > width / 4) {
                Configure.setDisplacementX(current.toString(), width / 4);
            }
            if (Configure.getDisplacementY(current.toString()) > height / 4) {
                Configure.setDisplacementY(current.toString(), height / 4);
            }
        }
        this.resetOptions();
        this.resetControls();
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.func_230446_a_(poseStack);
        this.layers.func_230430_a_(poseStack, mouseX, mouseY, partialTick);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTick);
        RaisedScreen.func_238467_a_((MatrixStack)poseStack, (int)0, (int)0, (int)this.field_230708_k_, (int)36, (int)0x40000000);
        this.field_230712_o_.func_238405_a_(poseStack, this.field_230704_d_.getString(), (float)(83 - this.field_230712_o_.func_78256_a(this.field_230704_d_.getString()) / 2), 14.0f, -1);
        ((GuiComponentInterface)((Object)this)).renderScrollingString(poseStack, this.field_230712_o_, (ITextComponent)new StringTextComponent(Parse.parseNamespace(current)), this.field_230708_k_ - 138, 8, this.field_230708_k_ - 28, 28, -1);
        this.options.forEach(widget -> {
            if (widget.func_231047_b_((double)mouseX, (double)mouseY)) {
                if (widget instanceof OptionButton) {
                    this.func_238654_b_(poseStack, (List)((OptionButton)widget).func_238517_a_().func_238246_b_().get(), mouseX, mouseY);
                } else if (widget instanceof OptionSlider) {
                    this.func_238654_b_(poseStack, (List)((SliderButtonAccessor)widget).getOption().func_238246_b_().get(), mouseX, mouseY);
                }
            }
        });
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        super.func_231046_a_(keyCode, scanCode, modifiers);
        if (RaisedOptions.OPTIONS.func_197976_a(keyCode, scanCode)) {
            this.func_231175_as__();
            return true;
        }
        return true;
    }

    public class LayerList
    extends SpacedSelectionList<Entry> {
        public LayerList(Minecraft minecraft, int width, int height) {
            super(minecraft, width, height, 36, RaisedScreen.this.field_230709_l_, 20, 8);
            this.setLayers();
        }

        public void setLayers() {
            this.func_230963_j_();
            LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).filter(location -> location.func_110624_b().equals(current.func_110624_b())).forEach(name -> this.func_230513_b_((AbstractList.AbstractListEntry)new Entry((ResourceLocation)name)));
        }

        public boolean func_230971_aw__() {
            return RaisedScreen.this.func_241217_q_() == this;
        }

        public class Entry
        extends SpacedSelectionList.Entry<Entry> {
            public final ResourceLocation name;

            public Entry(ResourceLocation name) {
                this.name = name;
                this.setCurrent(current.equals((Object)name));
            }

            public void func_230432_a_(MatrixStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                ((GuiComponentInterface)((Object)RaisedScreen.this)).renderScrollingString(poseStack, Minecraft.func_71410_x().field_71466_p, (ITextComponent)new StringTextComponent(Parse.parsePath(this.name)), left + 20, top, left + 130, top + 20, -1);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Icon.getLayerIcon(this.name));
                AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceLocation.func_208304_a((String)("raised:textures/gui/direction/" + Configure.getDirectionX(this.name.toString()).toString().toLowerCase() + "_" + Configure.getDirectionY(this.name.toString()).toString().toLowerCase() + ".png")));
                AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(left + 130), (int)top, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.setCurrent(true);
                return true;
            }

            public void setCurrent(boolean current) {
                if (current) {
                    RaisedScreen.current = this.name;
                    RaisedScreen.this.resetOptions();
                    LayerList.this.func_241215_a_((AbstractList.AbstractListEntry)this);
                }
            }
        }
    }
}

