/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Configure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class LayerArgument
implements ArgumentType<ResourceLocation> {
    public static LayerArgument layer() {
        return new LayerArgument();
    }

    public static ResourceLocation getLayer(CommandContext<CommandSource> context, String id) {
        return (ResourceLocation)context.getArgument(id, ResourceLocation.class);
    }

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation name = ResourceLocation.func_195826_a((StringReader)reader);
        if (Configure.getLayers().containsKey(name.toString())) {
            return name;
        }
        throw new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.raised.layer.unknown", new Object[]{object})).createWithContext((ImmutableStringReader)reader, (Object)name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return ISuggestionProvider.func_212476_a(LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return Arrays.asList("minecraft:hotbar", "appleskin:saturation_level", "farmersdelight:nourishment");
    }
}

