/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.registry;

import dev.yurisuika.raised.client.gui.Layer;
import dev.yurisuika.raised.util.Configure;
import java.util.TreeMap;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;

public class LayerRegistry {
    public static final TreeMap<ResourceLocation, Layer> LAYERS = new TreeMap();
    public static final ResourceLocation HOTBAR = ResourceLocation.func_208304_a((String)"hotbar");
    public static final ResourceLocation CHAT = ResourceLocation.func_208304_a((String)"chat");
    public static final ResourceLocation BOSSBAR = ResourceLocation.func_208304_a((String)"bossbar");
    public static final ResourceLocation SIDEBAR = ResourceLocation.func_208304_a((String)"sidebar");
    public static final ResourceLocation EFFECTS = ResourceLocation.func_208304_a((String)"effects");
    public static final ResourceLocation PLAYERS = ResourceLocation.func_208304_a((String)"players");
    public static final ResourceLocation TITLES = ResourceLocation.func_208304_a((String)"titles");
    public static final ResourceLocation SUBTITLES = ResourceLocation.func_208304_a((String)"subtitles");
    public static final ResourceLocation TOASTS = ResourceLocation.func_208304_a((String)"toasts");
    public static final ResourceLocation OTHER = ResourceLocation.func_208304_a((String)"other");

    public static void register(String name) {
        LayerRegistry.register(name, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.NONE, name));
    }

    public static void register(ResourceLocation name) {
        LayerRegistry.register(name, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.NONE, name.toString()));
    }

    public static void register(String name, Layer layer) {
        LayerRegistry.register(ResourceLocation.func_208304_a((String)name), layer);
    }

    public static void register(ResourceLocation name, Layer layer) {
        LAYERS.put(name, layer);
        LayerRegistry.addLayerToConfig(name, layer);
        LogManager.getLogger((String)"raised").info("Registering Raised layer '{}'", (Object)name);
    }

    public static void addLayerToConfig(ResourceLocation name, Layer layer) {
        if (!Configure.getLayers().containsKey(name.toString())) {
            Configure.addLayer(name.toString(), layer);
        }
    }

    public static void addLayersToConfig() {
        LAYERS.forEach(LayerRegistry::addLayerToConfig);
    }

    public static Layer createLayer(int displacementX, int displacementY, Layer.Direction.X directionX, Layer.Direction.Y directionY, ResourceLocation sync) {
        return LayerRegistry.createLayer(displacementX, displacementY, directionX, directionY, sync.toString());
    }

    public static Layer createLayer(int displacementX, int displacementY, Layer.Direction.X directionX, Layer.Direction.Y directionY, String sync) {
        return new Layer(new Layer.Displacement(displacementX, displacementY), new Layer.Direction(directionX, directionY), sync);
    }

    public static void boostrap() {
        LayerRegistry.register(HOTBAR, LayerRegistry.createLayer(0, 2, Layer.Direction.X.NONE, Layer.Direction.Y.UP, HOTBAR));
        LayerRegistry.register(CHAT, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.UP, CHAT));
        LayerRegistry.register(BOSSBAR, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.DOWN, BOSSBAR));
        LayerRegistry.register(SIDEBAR, LayerRegistry.createLayer(0, 0, Layer.Direction.X.LEFT, Layer.Direction.Y.NONE, SIDEBAR));
        LayerRegistry.register(EFFECTS, LayerRegistry.createLayer(0, 0, Layer.Direction.X.LEFT, Layer.Direction.Y.DOWN, EFFECTS));
        LayerRegistry.register(PLAYERS, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.DOWN, PLAYERS));
        LayerRegistry.register(TITLES, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.NONE, TITLES));
        LayerRegistry.register(SUBTITLES, LayerRegistry.createLayer(0, 0, Layer.Direction.X.LEFT, Layer.Direction.Y.UP, SUBTITLES));
        LayerRegistry.register(TOASTS, LayerRegistry.createLayer(0, 0, Layer.Direction.X.LEFT, Layer.Direction.Y.DOWN, TOASTS));
        LayerRegistry.register(OTHER, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.NONE, OTHER));
    }
}

