/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.util;

import dev.yurisuika.raised.client.gui.Layer;
import dev.yurisuika.raised.config.Config;
import java.util.TreeMap;

public class Configure {
    public static TreeMap<String, Layer> getLayers() {
        return Config.getOptions().getLayers();
    }

    public static void setLayers(TreeMap<String, Layer> layers) {
        Config.getOptions().setLayers(layers);
        Config.saveConfig();
    }

    public static Layer getLayer(String name) {
        return Configure.getLayers().get(name);
    }

    public static void setLayer(String name, Layer layer) {
        Configure.setDisplacementX(name, layer.getDisplacement().getX());
        Configure.setDisplacementY(name, layer.getDisplacement().getY());
        Configure.setDirectionX(name, layer.getDirection().getX());
        Configure.setDirectionY(name, layer.getDirection().getY());
        Configure.setSync(name, layer.getSync());
        Config.saveConfig();
    }

    public static void addLayer(String name, Layer layer) {
        Configure.getLayers().put(name, layer);
        Config.saveConfig();
    }

    public static void removeLayer(String name, Layer layer) {
        Configure.getLayers().remove(name, layer);
        Config.saveConfig();
    }

    public static Layer.Displacement getDisplacement(String name) {
        return Configure.getLayer(name).getDisplacement();
    }

    public static void setDisplacement(String name, int x, int y) {
        Configure.getLayer(name).setDisplacement(new Layer.Displacement(x, y));
        Config.saveConfig();
    }

    public static int getDisplacementX(String name) {
        return Configure.getLayer(name).getDisplacement().getX();
    }

    public static void setDisplacementX(String name, int x) {
        Configure.getLayer(name).getDisplacement().setX(x);
        Config.saveConfig();
    }

    public static int getDisplacementY(String name) {
        return Configure.getLayer(name).getDisplacement().getY();
    }

    public static void setDisplacementY(String name, int y) {
        Configure.getLayer(name).getDisplacement().setY(y);
        Config.saveConfig();
    }

    public static Layer.Direction getDirection(String name) {
        return Configure.getLayer(name).getDirection();
    }

    public static void setDirection(String name, Layer.Direction.X x, Layer.Direction.Y y) {
        Configure.getLayer(name).setDirection(new Layer.Direction(x, y));
        Config.saveConfig();
    }

    public static Layer.Direction.X getDirectionX(String name) {
        return Configure.getLayer(name).getDirection().getX();
    }

    public static void setDirectionX(String name, Layer.Direction.X x) {
        Configure.getLayer(name).getDirection().setX(x);
        Config.saveConfig();
    }

    public static Layer.Direction.Y getDirectionY(String name) {
        return Configure.getLayer(name).getDirection().getY();
    }

    public static void setDirectionY(String name, Layer.Direction.Y y) {
        Configure.getLayer(name).getDirection().setY(y);
        Config.saveConfig();
    }

    public static String getSync(String name) {
        return Configure.getLayer(name).getSync();
    }

    public static void setSync(String name, String sync) {
        Configure.getLayer(name).setSync(sync);
        Config.saveConfig();
    }
}

