/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui;

import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Translate;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.apache.commons.compress.utils.Lists;

public class GuiEvents {
    public static final List<ResourceLocation> MODS = Lists.newArrayList();
    public boolean translated = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void startTranslate(RenderGuiLayerEvent.Pre event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getName());
        if (name != null && LayerRegistry.LAYERS.containsKey(name) && !this.translated) {
            this.translated = true;
            Translate.start(event.getGuiGraphics().pose(), name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void endTranslate(RenderGuiLayerEvent.Pre event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getName());
        if (name != null && LayerRegistry.LAYERS.containsKey(name) && event.isCanceled() && this.translated) {
            this.translated = false;
            Translate.end(event.getGuiGraphics().pose(), name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void endTranslate(RenderGuiLayerEvent.Post event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getName());
        if (name != null && LayerRegistry.LAYERS.containsKey(name) && this.translated) {
            this.translated = false;
            Translate.end(event.getGuiGraphics().pose(), name);
        }
    }

    public static ResourceLocation formatOverlay(ResourceLocation name) {
        if (name.equals((Object)VanillaGuiLayers.HOTBAR)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.PLAYER_HEALTH)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.ARMOR_LEVEL)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.FOOD_LEVEL)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.AIR_LEVEL)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.VEHICLE_HEALTH)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.JUMP_METER)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.EXPERIENCE_BAR)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.EXPERIENCE_LEVEL)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.SELECTED_ITEM_NAME)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.SPECTATOR_TOOLTIP)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.OVERLAY_MESSAGE)) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.CHAT)) {
            return LayerRegistry.CHAT;
        }
        if (name.equals((Object)VanillaGuiLayers.BOSS_OVERLAY)) {
            return LayerRegistry.BOSSBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.SCOREBOARD_SIDEBAR)) {
            return LayerRegistry.SIDEBAR;
        }
        if (name.equals((Object)VanillaGuiLayers.EFFECTS)) {
            return LayerRegistry.EFFECTS;
        }
        if (name.equals((Object)VanillaGuiLayers.TAB_LIST)) {
            return LayerRegistry.PLAYERS;
        }
        if (name.equals((Object)VanillaGuiLayers.TITLE)) {
            return LayerRegistry.TITLES;
        }
        if (name.equals((Object)VanillaGuiLayers.SUBTITLE_OVERLAY)) {
            return LayerRegistry.SUBTITLES;
        }
        if (MODS.contains(name)) {
            return name;
        }
        return null;
    }
}

