/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui;

import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Translate;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.compress.utils.Lists;

public class GuiEvents {
    public static final List<ResourceLocation> MODS = Lists.newArrayList();
    public boolean translated = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void startTranslate(RenderGuiOverlayEvent.Pre event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getOverlay().id());
        if (name != null && LayerRegistry.LAYERS.containsKey(name) && !this.translated) {
            this.translated = true;
            Translate.start(event.getPoseStack(), name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void endTranslate(RenderGuiOverlayEvent.Pre event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getOverlay().id());
        if (name != null && LayerRegistry.LAYERS.containsKey(name) && event.isCanceled() && this.translated) {
            this.translated = false;
            Translate.end(event.getPoseStack(), name);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void endTranslate(RenderGuiOverlayEvent.Post event) {
        ResourceLocation name = GuiEvents.formatOverlay(event.getOverlay().id());
        if (name != null && LayerRegistry.LAYERS.containsKey(name) && this.translated) {
            this.translated = false;
            Translate.end(event.getPoseStack(), name);
        }
    }

    public static ResourceLocation formatOverlay(ResourceLocation name) {
        if (name.equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.PLAYER_HEALTH.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.ARMOR_LEVEL.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.FOOD_LEVEL.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.AIR_LEVEL.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.MOUNT_HEALTH.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.JUMP_BAR.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.ITEM_NAME.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.RECORD_OVERLAY.id())) {
            return LayerRegistry.HOTBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.CHAT_PANEL.id())) {
            return LayerRegistry.CHAT;
        }
        if (name.equals((Object)VanillaGuiOverlay.BOSS_EVENT_PROGRESS.id())) {
            return LayerRegistry.BOSSBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.SCOREBOARD.id())) {
            return LayerRegistry.SIDEBAR;
        }
        if (name.equals((Object)VanillaGuiOverlay.POTION_ICONS.id())) {
            return LayerRegistry.EFFECTS;
        }
        if (name.equals((Object)VanillaGuiOverlay.PLAYER_LIST.id())) {
            return LayerRegistry.PLAYERS;
        }
        if (name.equals((Object)VanillaGuiOverlay.TITLE_TEXT.id())) {
            return LayerRegistry.TITLES;
        }
        if (name.equals((Object)VanillaGuiOverlay.SUBTITLES.id())) {
            return LayerRegistry.SUBTITLES;
        }
        if (MODS.contains(name)) {
            return name;
        }
        return null;
    }
}

