/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.registry;

import dev.yurisuika.raised.client.gui.Layer;
import dev.yurisuika.raised.util.Configure;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.LoggerFactory;

public class LayerRegistry {
    public static final TreeMap<ResourceLocation, Layer> LAYERS = new TreeMap();
    public static final ResourceLocation HOTBAR = ResourceLocation.m_135820_((String)"hotbar");
    public static final ResourceLocation CHAT = ResourceLocation.m_135820_((String)"chat");
    public static final ResourceLocation BOSSBAR = ResourceLocation.m_135820_((String)"bossbar");
    public static final ResourceLocation SIDEBAR = ResourceLocation.m_135820_((String)"sidebar");
    public static final ResourceLocation EFFECTS = ResourceLocation.m_135820_((String)"effects");
    public static final ResourceLocation PLAYERS = ResourceLocation.m_135820_((String)"players");
    public static final ResourceLocation TITLES = ResourceLocation.m_135820_((String)"titles");
    public static final ResourceLocation SUBTITLES = ResourceLocation.m_135820_((String)"subtitles");
    public static final ResourceLocation TOASTS = ResourceLocation.m_135820_((String)"toasts");
    public static final ResourceLocation OTHER = ResourceLocation.m_135820_((String)"other");

    public static void register(String name) {
        LayerRegistry.register(name, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.NONE, name));
    }

    public static void register(ResourceLocation name) {
        LayerRegistry.register(name, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.NONE, name.toString()));
    }

    public static void register(String name, Layer layer) {
        LayerRegistry.register(ResourceLocation.m_135820_((String)name), layer);
    }

    public static void register(ResourceLocation name, Layer layer) {
        LAYERS.put(name, layer);
        LayerRegistry.addLayerToConfig(name, layer);
        LoggerFactory.getLogger((String)"raised").info("Registering Raised layer '{}'", (Object)name);
    }

    public static void addLayerToConfig(ResourceLocation name, Layer layer) {
        if (!Configure.getLayers().containsKey(name.toString())) {
            Configure.addLayer(name.toString(), layer);
        }
    }

    public static void addLayersToConfig() {
        LAYERS.forEach(LayerRegistry::addLayerToConfig);
    }

    public static Layer createLayer(int displacementX, int displacementY, Layer.Direction.X directionX, Layer.Direction.Y directionY, ResourceLocation sync) {
        return LayerRegistry.createLayer(displacementX, displacementY, directionX, directionY, sync.toString());
    }

    public static Layer createLayer(int displacementX, int displacementY, Layer.Direction.X directionX, Layer.Direction.Y directionY, String sync) {
        return new Layer(new Layer.Displacement(displacementX, displacementY), new Layer.Direction(directionX, directionY), sync);
    }

    public static void boostrap() {
        LayerRegistry.register(HOTBAR, LayerRegistry.createLayer(0, 2, Layer.Direction.X.NONE, Layer.Direction.Y.UP, HOTBAR));
        LayerRegistry.register(CHAT, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.UP, CHAT));
        LayerRegistry.register(BOSSBAR, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.DOWN, BOSSBAR));
        LayerRegistry.register(SIDEBAR, LayerRegistry.createLayer(0, 0, Layer.Direction.X.LEFT, Layer.Direction.Y.NONE, SIDEBAR));
        LayerRegistry.register(EFFECTS, LayerRegistry.createLayer(0, 0, Layer.Direction.X.LEFT, Layer.Direction.Y.DOWN, EFFECTS));
        LayerRegistry.register(PLAYERS, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.DOWN, PLAYERS));
        LayerRegistry.register(TITLES, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.NONE, TITLES));
        LayerRegistry.register(SUBTITLES, LayerRegistry.createLayer(0, 0, Layer.Direction.X.LEFT, Layer.Direction.Y.UP, SUBTITLES));
        LayerRegistry.register(TOASTS, LayerRegistry.createLayer(0, 0, Layer.Direction.X.LEFT, Layer.Direction.Y.DOWN, TOASTS));
        LayerRegistry.register(OTHER, LayerRegistry.createLayer(0, 0, Layer.Direction.X.NONE, Layer.Direction.Y.NONE, OTHER));
    }
}

