/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.mixin.client.gui;

import dev.yurisuika.raised.client.gui.Resource;
import dev.yurisuika.raised.mixin.client.gui.GuiGraphicsInvoker;
import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Configure;
import dev.yurisuika.raised.util.Pack;
import dev.yurisuika.raised.util.Translate;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Gui.class}, priority=-999999999)
public abstract class GuiMixin {
    @ModifyArg(method={"renderItemHotbar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1), index=0)
    private ResourceLocation replaceHotbarSelectorIdentifier(ResourceLocation sprite) {
        if (Configure.getTexture() == Resource.Texture.REPLACE || Configure.getTexture() == Resource.Texture.AUTO && Pack.getPack()) {
            return ResourceLocation.tryParse((String)"raised:hud/hotbar_selection");
        }
        return sprite;
    }

    @ModifyArg(method={"renderItemHotbar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1), index=4)
    private int replaceHotbarSelectorHeight(int height) {
        if (Configure.getTexture() == Resource.Texture.REPLACE || Configure.getTexture() == Resource.Texture.AUTO && Pack.getPack()) {
            return 24;
        }
        return height;
    }

    @Inject(method={"renderItemHotbar"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void patchHotbarSelector(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci, Player player) {
        if (Configure.getTexture() == Resource.Texture.PATCH || Configure.getTexture() == Resource.Texture.AUTO && !Pack.getPack()) {
            int x = guiGraphics.guiWidth() / 2 - 92 + player.getInventory().selected * 20;
            int y = guiGraphics.guiHeight();
            ((GuiGraphicsInvoker)guiGraphics).invokeInnerBlit(ResourceLocation.tryParse((String)"textures/gui/sprites/hud/hotbar_selection.png"), x, x + 24, y, y + 1, 0, 0.0f, 1.0f, 0.04347826f, 0.0f);
        }
    }

    @Inject(method={"renderHotbarAndDecorations"}, at={@At(value="HEAD")})
    private void startMainHudTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.HOTBAR);
    }

    @Inject(method={"renderHotbarAndDecorations"}, at={@At(value="TAIL")})
    private void endMainHudTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.end(guiGraphics.pose(), LayerRegistry.HOTBAR);
    }

    @Inject(method={"renderExperienceLevel"}, at={@At(value="HEAD")})
    private void startExperienceLevelTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.HOTBAR);
    }

    @Inject(method={"renderExperienceLevel"}, at={@At(value="TAIL")})
    private void endExperienceLevelTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.end(guiGraphics.pose(), LayerRegistry.HOTBAR);
    }

    @Inject(method={"renderOverlayMessage"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V")})
    private void startOverlayMessageTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.HOTBAR);
    }

    @Inject(method={"renderOverlayMessage"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", shift=At.Shift.AFTER)})
    private void endOverlayMessageTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.end(guiGraphics.pose(), LayerRegistry.HOTBAR);
    }

    @Inject(method={"renderChat"}, at={@At(value="HEAD")})
    private void startChatTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.CHAT);
    }

    @Inject(method={"renderChat"}, at={@At(value="TAIL")})
    private void endChatTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.end(guiGraphics.pose(), LayerRegistry.CHAT);
    }

    @Inject(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/GuiGraphics;F)V"}, at={@At(value="HEAD")})
    private void startSidebarTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.SIDEBAR);
    }

    @Inject(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/GuiGraphics;F)V"}, at={@At(value="TAIL")})
    private void endSidebarTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.end(guiGraphics.pose(), LayerRegistry.SIDEBAR);
    }

    @Inject(method={"renderEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getMobEffectTextures()Lnet/minecraft/client/resources/MobEffectTextureManager;")})
    private void startEffectsTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.EFFECTS);
    }

    @Inject(method={"renderEffects"}, at={@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V", shift=At.Shift.AFTER)})
    private void endEffectsTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.end(guiGraphics.pose(), LayerRegistry.EFFECTS);
    }

    @Inject(method={"renderTabList"}, at={@At(value="HEAD")})
    private void startPlayersTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.PLAYERS);
    }

    @Inject(method={"renderTabList"}, at={@At(value="TAIL")})
    private void endPlayersTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.end(guiGraphics.pose(), LayerRegistry.PLAYERS);
    }

    @Inject(method={"renderTitle"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V")})
    private void startTitlesTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.TITLES);
    }

    @Inject(method={"renderTitle"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", shift=At.Shift.AFTER)})
    private void endTitlesTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.end(guiGraphics.pose(), LayerRegistry.TITLES);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void startRenderHeadTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.OTHER);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void startRenderTailTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.OTHER);
    }

    @Mixin(value={Gui.class}, priority=999999999)
    public static abstract class Last {
        @Inject(method={"render"}, at={@At(value="HEAD")})
        private void endRenderHeadTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
            Translate.end(guiGraphics.pose(), LayerRegistry.OTHER);
        }

        @Inject(method={"render"}, at={@At(value="TAIL")})
        private void endRenderTailTranslate(GuiGraphics guiGraphics, float partialTick, CallbackInfo ci) {
            Translate.end(guiGraphics.pose(), LayerRegistry.OTHER);
        }
    }
}

