/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.util.Mth;
import net.minecraft.util.OptionEnum;
import net.minecraft.util.StringRepresentable;

public class Resource {
    public Texture texture;

    public Resource(Texture texture) {
        this.texture = texture;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public static enum Texture implements OptionEnum,
    StringRepresentable
    {
        REPLACE(0, "options.raised.texture.replace"),
        PATCH(1, "options.raised.texture.patch"),
        AUTO(2, "options.raised.texture.auto"),
        NONE(3, "options.raised.texture.none");

        public static final StringRepresentable.EnumCodec<Texture> CODEC;
        public static final Texture[] VALUES;
        public final int id;
        public final String key;

        private Texture(int id, String key) {
            this.id = id;
            this.key = key;
        }

        public int getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public static Texture byName(String name) {
            return (Texture)CODEC.byName(name);
        }

        public static Texture byId(int id) {
            return VALUES[Mth.abs((int)(id % VALUES.length))];
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.fromEnum(Texture::values);
            VALUES = (Texture[])Arrays.stream(Texture.values()).sorted(Comparator.comparingInt(type -> type.id)).toArray(Texture[]::new);
        }
    }
}

