/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui.screens;

import com.mojang.serialization.Codec;
import dev.yurisuika.raised.client.RaisedOptions;
import dev.yurisuika.raised.client.gui.Layer;
import dev.yurisuika.raised.client.gui.Resource;
import dev.yurisuika.raised.client.gui.components.SpacedSelectionList;
import dev.yurisuika.raised.mixin.client.gui.components.AbstractWidgetInvoker;
import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Configure;
import dev.yurisuika.raised.util.Icon;
import dev.yurisuika.raised.util.Parse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class RaisedScreen
extends Screen {
    public Screen parent;
    public ArrayList<AbstractWidget> options;
    public ArrayList<AbstractWidget> controls;
    public LayerList layers;
    public static ResourceLocation current = LayerRegistry.HOTBAR;
    public final int SPACING = 5;
    public final int PADDING = 8;
    public final int WIDGET_WIDTH_WIDE = 150;
    public final int WIDGET_WIDTH_SQUARE = 20;
    public final int WIDGET_HEIGHT = 20;
    public final int HEADER_HEIGHT = 36;
    public final int PANEL_WIDTH = 166;

    public RaisedScreen(Screen parent) {
        super((Component)Component.translatable((String)"options.raised.title"));
        this.parent = parent;
    }

    public void init() {
        this.addOptions();
        this.addControls();
        this.addLayers();
        this.repositionElements();
    }

    public void addOptions() {
        this.options = new ArrayList();
        this.options.add(new OptionInstance("options.raised.displacement.x", OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)"options.raised.displacement.x.tooltip")), (prefix, value) -> Options.genericValueLabel((Component)prefix, (Component)(value == 0 ? CommonComponents.OPTION_OFF : Component.literal((String)(Configure.getDisplacementX(current.toString()) + "px (" + Math.round(Math.ceil(value.floatValue() / ((float)this.width / 4.0f) * 100.0f)) + "%)")))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, this.width / 4), (Object)Configure.getDisplacementX(current.toString()), value -> Configure.setDisplacementX(current.toString(), value)).createButton(this.minecraft.options, 8, 44, 150));
        this.options.add(new OptionInstance("options.raised.displacement.y", OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)"options.raised.displacement.y.tooltip")), (prefix, value) -> Options.genericValueLabel((Component)prefix, (Component)(value == 0 ? CommonComponents.OPTION_OFF : Component.literal((String)(Configure.getDisplacementY(current.toString()) + "px (" + Math.round(Math.ceil(value.floatValue() / ((float)this.height / 4.0f) * 100.0f)) + "%)")))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, this.height / 4), (Object)Configure.getDisplacementY(current.toString()), value -> Configure.setDisplacementY(current.toString(), value)).createButton(this.minecraft.options, 8, 69, 150));
        this.options.add(new OptionInstance("options.raised.direction.x", value -> Tooltip.create((Component)Component.translatable((String)"options.raised.direction.x.tooltip")), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(Layer.Direction.X.values()), Codec.INT.xmap(Layer.Direction.X::byId, Layer.Direction.X::getId)), (Object)Layer.Direction.X.byName(Configure.getDirectionX(current.toString()).getSerializedName()), value -> Configure.setDirectionX(current.toString(), value)).createButton(this.minecraft.options, 8, 94, 150));
        this.options.add(new OptionInstance("options.raised.direction.y", value -> Tooltip.create((Component)Component.translatable((String)"options.raised.direction.y.tooltip")), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(Layer.Direction.Y.values()), Codec.INT.xmap(Layer.Direction.Y::byId, Layer.Direction.Y::getId)), (Object)Layer.Direction.Y.byName(Configure.getDirectionY(current.toString()).getSerializedName()), value -> Configure.setDirectionY(current.toString(), value)).createButton(this.minecraft.options, 8, 119, 150));
        this.options.add(new OptionInstance("options.raised.sync", value -> Tooltip.create((Component)Component.translatable((String)"options.raised.sync.tooltip", (Object[])new Object[]{value.toString()})), (prefix, value) -> Component.literal((String)Parse.parsePath(value)), (OptionInstance.ValueSet)new OptionInstance.Enum(LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).toList(), ResourceLocation.CODEC), (Object)ResourceLocation.tryParse((String)Configure.getSync(current.toString())), value -> Configure.setSync(current.toString(), value.toString())).createButton(this.minecraft.options, 8, 144, 150));
        this.options.add(new OptionInstance("options.raised.texture", value -> Tooltip.create((Component)Component.translatable((String)("options.raised.texture." + value.getSerializedName() + ".tooltip"))), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(Resource.Texture.values()), Codec.INT.xmap(Resource.Texture::byId, Resource.Texture::getId)), (Object)Resource.Texture.byName(Configure.getTexture().getSerializedName()), Configure::setTexture).createButton(this.minecraft.options, 8, this.height - 53, 150));
        this.options.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void addControls() {
        this.controls = new ArrayList();
        this.controls.add((AbstractWidget)Button.builder((Component)Component.literal((String)"<"), button -> this.getPrevious()).size(20, 20).pos(this.width - 158, 8).build());
        this.controls.add((AbstractWidget)Button.builder((Component)Component.literal((String)">"), button -> this.getNext()).size(20, 20).pos(this.width - 28, 8).build());
        this.controls.add((AbstractWidget)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).size(150, 20).pos(8, this.height - 28).build());
        this.controls.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void addLayers() {
        this.layers = new LayerList(this.minecraft, 166, this.height - 36);
        this.addRenderableWidget((GuiEventListener)this.layers);
    }

    public void getPrevious() {
        HashSet mods = new HashSet();
        LayerRegistry.LAYERS.keySet().forEach(key -> mods.add(key.getNamespace()));
        List keys = mods.stream().toList();
        int index = keys.indexOf(current.getNamespace()) - 1;
        String mod = index < 0 ? (String)keys.getLast() : (String)keys.get(index);
        this.setMod(mod);
    }

    public void getNext() {
        HashSet mods = new HashSet();
        LayerRegistry.LAYERS.keySet().forEach(key -> mods.add(key.getNamespace()));
        List keys = mods.stream().toList();
        int index = keys.indexOf(current.getNamespace()) + 1;
        String mod = index >= keys.size() ? (String)keys.getFirst() : (String)keys.get(index);
        this.setMod(mod);
    }

    public void setMod(String mod) {
        current = LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).filter(name -> name.getNamespace().equals(mod)).toList().getFirst();
        this.resetOptions();
        this.resetLayers();
        this.resetControls();
    }

    public void resetOptions() {
        this.options.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.options.clear();
        this.addOptions();
    }

    public void resetControls() {
        this.controls.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.controls.clear();
        this.addControls();
    }

    public void resetLayers() {
        this.layers.setLayers();
    }

    public void repositionElements() {
        this.layers.setSize(166, this.height - 36);
        this.layers.setPosition(this.width - 166, 36);
    }

    public void onClose() {
        super.onClose();
        if (this.parent != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        if (Configure.getLayer(current.toString()) != null) {
            if (Configure.getDisplacementX(current.toString()) > width / 4) {
                Configure.setDisplacementX(current.toString(), width / 4);
            }
            if (Configure.getDisplacementY(current.toString()) > height / 4) {
                Configure.setDisplacementY(current.toString(), height / 4);
            }
        }
        this.resetOptions();
        this.resetControls();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.fill(0, 0, this.width, 36, 0x40000000);
        guiGraphics.drawCenteredString(this.font, this.title, 83, 14, -1);
        AbstractWidgetInvoker.invokeRenderScrollingString(guiGraphics, this.font, (Component)Component.literal((String)Parse.parseNamespace(current)), this.width - 138, 8, this.width - 28, 28, -1);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        super.keyPressed(keyCode, scanCode, modifiers);
        if (RaisedOptions.OPTIONS.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return true;
    }

    public class LayerList
    extends SpacedSelectionList<Entry> {
        public LayerList(Minecraft minecraft, int width, int height) {
            super(minecraft, width, height, 0, 20, 8);
            this.setLayers();
        }

        public void setLayers() {
            this.clearEntries();
            LayerRegistry.LAYERS.keySet().stream().sorted(Comparator.comparing(ResourceLocation::toString)).filter(location -> location.getNamespace().equals(current.getNamespace())).forEach(name -> this.addEntry((AbstractSelectionList.Entry)new Entry((ResourceLocation)name)));
        }

        public class Entry
        extends SpacedSelectionList.Entry<Entry> {
            public final ResourceLocation name;

            public Entry(ResourceLocation name) {
                this.name = name;
                this.setCurrent(current.equals((Object)name));
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                AbstractWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)Minecraft.getInstance().font, (Component)Component.literal((String)Parse.parsePath(this.name)), (int)(left + 20), (int)top, (int)(left + 130), (int)(top + 20), (int)-1);
                guiGraphics.blit(RenderType::guiTextured, Icon.getLayerIcon(this.name), left, top, 0.0f, 0.0f, 20, 20, 20, 20);
                guiGraphics.blit(RenderType::guiTextured, ResourceLocation.fromNamespaceAndPath((String)"raised", (String)("textures/gui/direction/" + Configure.getDirectionX(this.name.toString()).toString().toLowerCase() + "_" + Configure.getDirectionY(this.name.toString()).toString().toLowerCase() + ".png")), left + 130, top, 0.0f, 0.0f, 20, 20, 20, 20);
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{Parse.parsePath(this.name)});
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.setCurrent(true);
                return true;
            }

            public void setCurrent(boolean current) {
                if (current) {
                    RaisedScreen.current = this.name;
                    RaisedScreen.this.resetOptions();
                    LayerList.this.setSelected((AbstractSelectionList.Entry)this);
                }
            }
        }
    }
}

