/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.mixin.client.gui;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.yurisuika.raised.client.gui.Resource;
import dev.yurisuika.raised.mixin.client.gui.GuiGraphicsInvoker;
import dev.yurisuika.raised.registry.LayerRegistry;
import dev.yurisuika.raised.util.Configure;
import dev.yurisuika.raised.util.Pack;
import dev.yurisuika.raised.util.Translate;
import java.util.function.Function;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class}, priority=-999999999)
public abstract class GuiMixin {
    @ModifyArg(method={"renderItemHotbar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1), index=1)
    private ResourceLocation replaceHotbarSelectorIdentifier(ResourceLocation sprite) {
        if (Configure.getTexture() == Resource.Texture.REPLACE || Configure.getTexture() == Resource.Texture.AUTO && Pack.getPack()) {
            return ResourceLocation.fromNamespaceAndPath((String)"raised", (String)"hud/hotbar_selection");
        }
        return sprite;
    }

    @ModifyArg(method={"renderItemHotbar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1), index=5)
    private int replaceHotbarSelectorHeight(int height) {
        if (Configure.getTexture() == Resource.Texture.REPLACE || Configure.getTexture() == Resource.Texture.AUTO && Pack.getPack()) {
            return 24;
        }
        return height;
    }

    @WrapOperation(method={"renderItemHotbar"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1)})
    private void patchHotbarSelector(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderTypeGetter, ResourceLocation sprite, int x, int y, int width, int height, Operation<Void> operation, @Local(ordinal=0) Player player) {
        operation.call(new Object[]{guiGraphics, renderTypeGetter, sprite, x, y, width, height});
        if (Configure.getTexture() == Resource.Texture.PATCH || Configure.getTexture() == Resource.Texture.AUTO && !Pack.getPack()) {
            x = guiGraphics.guiWidth() / 2 - 92 + player.getInventory().selected * 20;
            y = guiGraphics.guiHeight();
            ((GuiGraphicsInvoker)guiGraphics).invokeInnerBlit(RenderType::guiTextured, ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/hotbar_selection.png"), x, x + 24, y, y + 1, 0.0f, 1.0f, 0.04347826f, 0.0f, -1);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void startRenderHeadTranslate(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.OTHER);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void startRenderTailTranslate(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        Translate.start(guiGraphics.pose(), LayerRegistry.OTHER);
    }

    @Mixin(value={Gui.class}, priority=999999999)
    public static abstract class Last {
        @Inject(method={"render"}, at={@At(value="HEAD")})
        private void endRenderHeadTranslate(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
            Translate.end(guiGraphics.pose(), LayerRegistry.OTHER);
        }

        @Inject(method={"render"}, at={@At(value="TAIL")})
        private void endRenderTailTranslate(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
            Translate.end(guiGraphics.pose(), LayerRegistry.OTHER);
        }
    }
}

