/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateTester {
    private final Block block;
    private final TagKey<Block> blockTag;
    private final List<PropertyTester> properties;
    private final BlockStateTesterBuilder builder;
    public static final Codec<BlockStateTester> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockStateTesterBuilder.CODEC.fieldOf("tester").forGetter(b -> b.builder)).apply((Applicative)i, BlockStateTester::new));

    private BlockStateTester(Block block, TagKey<Block> blockTag, List<PropertyTester> properties, BlockStateTesterBuilder builder) {
        this.block = block;
        this.blockTag = blockTag;
        this.properties = properties;
        this.builder = builder;
    }

    private BlockStateTester(BlockStateTesterBuilder builder) {
        this(builder.block.orElse(null), (TagKey<Block>)((TagKey)builder.blockTagS.map(s -> TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)((ResourceLocation)ResourceLocation.read((String)s).getOrThrow()))).orElse(null)), builder.pTL, builder);
    }

    public boolean test(BlockState blockState) {
        boolean blockType = false;
        if (this.block != null) {
            blockType = blockState.getBlock().equals(this.block);
        } else if (this.blockTag != null) {
            blockType = blockState.is(this.blockTag);
        }
        boolean propertiesTest = this.properties.isEmpty();
        if (blockType) {
            Collection propertyList = blockState.getProperties();
            HashMap<String, Property> matchedProperty = new HashMap<String, Property>();
            boolean skipPropertyTest = false;
            for (PropertyTester pT : this.properties) {
                boolean find = false;
                for (Property p : propertyList) {
                    if (!p.getName().equals(pT.name)) continue;
                    find = true;
                    matchedProperty.put(pT.name, p);
                    break;
                }
                if (find) continue;
                skipPropertyTest = true;
                break;
            }
            if (!skipPropertyTest) {
                for (PropertyTester pT : this.properties) {
                    propertiesTest = true;
                    Property property = (Property)matchedProperty.get(pT.name);
                    boolean pPass = pT.testPropertyValue(blockState, property);
                    if (pPass) continue;
                    propertiesTest = false;
                    break;
                }
            }
        }
        return blockType && propertiesTest;
    }

    public List<Block> toBlockList() {
        ArrayList<Block> result = new ArrayList<Block>();
        if (this.block != null) {
            result.add(this.block);
        } else if (BuiltInRegistries.BLOCK.getTag(this.blockTag).isPresent()) {
            ((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(this.blockTag).get()).forEach(blockHolder -> result.add((Block)blockHolder.value()));
        }
        return result;
    }

    public NonNullList<Ingredient> toIngredient() {
        ItemStack[] itemStacks = (ItemStack[])this.toBlockList().stream().map(Block::asItem).map(Item::getDefaultInstance).toArray(ItemStack[]::new);
        Ingredient ingredient = Ingredient.of((ItemStack[])itemStacks);
        NonNullList result = NonNullList.create();
        result.add((Object)ingredient);
        return result;
    }

    public String toString() {
        return "BlockStateTester:" + String.valueOf(this.block) + " B/T " + String.valueOf(this.blockTag) + " P:" + String.valueOf(this.properties);
    }

    private record BlockStateTesterBuilder(Optional<Block> block, Optional<String> blockTagS, List<PropertyTester> pTL) {
        public static final Codec<BlockStateTesterBuilder> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("block").forGetter(b -> b.block), (App)Codec.STRING.optionalFieldOf("tag").forGetter(b -> b.blockTagS), (App)Codec.list(PropertyTester.CODEC).fieldOf("properties").forGetter(b -> b.pTL)).apply((Applicative)i, BlockStateTesterBuilder::new));
    }

    public record PropertyTester(String name, List<String> values) {
        public static final Codec<PropertyTester> CODEC = RecordCodecBuilder.create(propertyTesterInstance -> propertyTesterInstance.group((App)Codec.STRING.fieldOf("name").forGetter(p -> p.name), (App)Codec.list((Codec)Codec.STRING).fieldOf("value").forGetter(p -> p.values)).apply((Applicative)propertyTesterInstance, PropertyTester::new));

        public <T extends Comparable<T>> boolean testPropertyValue(BlockState blockState, Property<T> property) {
            Comparable value = blockState.getValue(property);
            String valueName = property.getName(value);
            return this.values.contains(valueName);
        }
    }
}

