/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.CHTags;
import com.ffsupver.createheat.Config;
import com.ffsupver.createheat.api.CustomHeater;
import com.ffsupver.createheat.block.HeatProvider;
import com.ffsupver.createheat.block.thermalBlock.HeatStorage;
import com.ffsupver.createheat.block.thermalBlock.StoneHeatStorage;
import com.ffsupver.createheat.recipe.HeatRecipe;
import com.ffsupver.createheat.registries.CHRecipes;
import com.ffsupver.createheat.util.BlockUtil;
import com.ffsupver.createheat.util.NbtUtil;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ThermalBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private boolean isController;
    private BlockPos controllerPos = null;
    private final Set<BlockPos> connectedBlocks = new HashSet<BlockPos>();
    private int heat;
    public static final Supplier<Integer> MAX_HEAT = () -> 50 * (Integer)Config.HEAT_PER_FADING_BLAZE.get();
    private int cooldown = 0;
    private static final int MAX_COOLDOWN = 10;
    private final HeatStorage heatStorage = new HeatStorage(MAX_HEAT.get());
    private final ArrayList<StoneHeatStorage> stoneHeatStorages = new ArrayList();
    private final ArrayList<StoneHeatStorage> stoneHeatStoragesToAddLater = new ArrayList();
    private final Map<BlockPos, HeatRecipeProcessing> recipeProcessingMap = new HashMap<BlockPos, HeatRecipeProcessing>();
    private final HeatStorage displayHeatStorage = new HeatStorage(0);

    public ThermalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putBoolean("is_controller", this.isController);
        if (this.isController) {
            tag.put("connected", (Tag)NbtUtil.writeBlockPosToNbtList(this.connectedBlocks));
            tag.putInt("heat", this.heat);
            tag.putInt("cooldown", this.cooldown);
            tag.put("heat_storage", (Tag)this.heatStorage.toNbt());
            tag.put("shs", (Tag)NbtUtil.writeToNbtList(this.stoneHeatStorages, shs -> {
                if (shs.shouldWriteToNbt(this.getControllerPos())) {
                    return shs.toNbt();
                }
                return null;
            }));
            tag.put("recipe", (Tag)NbtUtil.writeMapToNbtList(this.recipeProcessingMap, NbtUtil::blockPosToNbt, hRP -> hRP.toNbt(this.getBlockPos())));
            if (clientPacket) {
                tag.put("display_heat", (Tag)this.getAllHeatForDisplay().toNbt());
            }
        } else {
            tag.put("controller", NbtUtils.writeBlockPos((BlockPos)this.controllerPos));
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.isController = tag.getBoolean("is_controller");
        if (this.isController) {
            this.connectedBlocks.clear();
            this.connectedBlocks.addAll(NbtUtil.readBlockPosFromNbtList(tag.getList("connected", 10)));
            this.heat = tag.getInt("heat");
            this.cooldown = tag.getInt("cooldown");
            this.heatStorage.fromNbt(tag.getCompound("heat_storage"));
            this.stoneHeatStorages.clear();
            this.stoneHeatStorages.addAll(NbtUtil.readListFromNbt(tag.getList("shs", 10), tS -> StoneHeatStorage.cFromNbt((CompoundTag)tS)));
            this.recipeProcessingMap.clear();
            this.recipeProcessingMap.putAll(NbtUtil.readMapFromNbtList(tag.getList("recipe", 10), NbtUtil::blockPosFromNbt, t -> HeatRecipeProcessing.fromNbt((CompoundTag)t, this.getBlockPos())));
            if (clientPacket) {
                this.displayHeatStorage.fromNbt(tag.getCompound("display_heat"));
            }
        } else {
            this.controllerPos = NBTHelper.readBlockPos((CompoundTag)tag, (String)"controller");
        }
    }

    public void tick() {
        super.tick();
        if (!this.isController) {
            return;
        }
        if (this.cooldown < 0) {
            this.tickEveryConnectedBlock();
            this.cooldown = 10;
        } else {
            --this.cooldown;
        }
    }

    public void tickEveryConnectedBlock() {
        if (this.getLevel().isClientSide()) {
            return;
        }
        int tickSkip = 10;
        Set connectedBlockList = this.connectedBlocks.stream().map(pos -> {
            ThermalBlockEntity thermalBlockEntity;
            BlockEntity patt0$temp = this.getLevel().getBlockEntity(pos);
            return patt0$temp instanceof ThermalBlockEntity ? (thermalBlockEntity = (ThermalBlockEntity)patt0$temp) : null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        int lastHeat = this.heat;
        this.heat = 0;
        int superHeatCount = 0;
        boolean changeSHS = false;
        Iterator<StoneHeatStorage> sHSIterator = this.stoneHeatStorages.iterator();
        while (sHSIterator.hasNext()) {
            StoneHeatStorage sHS = sHSIterator.next();
            if (!sHS.isConnect(this.connectedBlocks)) {
                sHS.disconnect(this.getControllerPos());
                sHSIterator.remove();
                changeSHS = true;
                continue;
            }
            boolean bl = changeSHS = changeSHS || sHS.checkSize(this.getLevel(), this.getControllerPos());
            if (sHS.getCapacity() > 0 && !sHS.shouldChangeController) continue;
            sHSIterator.remove();
            changeSHS = true;
        }
        this.stoneHeatStorages.addAll(this.stoneHeatStoragesToAddLater);
        this.stoneHeatStoragesToAddLater.clear();
        List<BlockPos> processPosToRemove = this.recipeProcessingMap.entrySet().stream().filter(entry -> ((HeatRecipeProcessing)entry.getValue()).finished).map(Map.Entry::getKey).toList();
        processPosToRemove.forEach(this.recipeProcessingMap::remove);
        ArrayList<HeatRecipeProcessing> hRPL = new ArrayList<HeatRecipeProcessing>();
        for (ThermalBlockEntity thermalBlockEntity : connectedBlockList) {
            hRPL.addAll(thermalBlockEntity.getRecipes());
            HeatData heatBelow = thermalBlockEntity.genHeat();
            this.heat += heatBelow.heat * tickSkip;
            superHeatCount += heatBelow.superHeatCount;
            for (Direction d : Direction.values()) {
                boolean foundIn;
                BlockPos checkPos = thermalBlockEntity.getBlockPos().relative(d);
                if (!StoneHeatStorage.isAvailableBlock(this.getLevel().getBlockState(checkPos)) || (foundIn = this.isPosInStoneHeatStorage(checkPos))) continue;
                StoneHeatStorage newShs = new StoneHeatStorage(new HashSet<BlockPos>(Set.of(checkPos)), this.getControllerPos());
                Set<BlockPos> connectControllerPosSet = newShs.checkSize(this.getLevel(), checkPos, true);
                boolean foundOldSHS = false;
                for (BlockPos otherControllerPos : connectControllerPosSet) {
                    ThermalBlockEntity t;
                    ThermalBlockEntity otherControllerBE;
                    Optional<StoneHeatStorage> oldSHSOp;
                    BlockEntity blockEntity;
                    if (otherControllerPos.equals((Object)this.getControllerPos()) || !((blockEntity = this.getLevel().getBlockEntity(otherControllerPos)) instanceof ThermalBlockEntity) || !(oldSHSOp = (otherControllerBE = (t = (ThermalBlockEntity)blockEntity).getControllerEntity()).findOldStoneHeatStorage(newShs)).isPresent()) continue;
                    this.stoneHeatStorages.add(oldSHSOp.get());
                    foundOldSHS = true;
                    break;
                }
                if (!foundOldSHS) {
                    this.stoneHeatStorages.add(newShs);
                }
                changeSHS = true;
            }
        }
        this.releaseHeat();
        this.checkAddHeatRecipeProcessing(hRPL);
        for (ThermalBlockEntity thermalBlockEntity : connectedBlockList) {
            CostHeatResult costHeatResult = thermalBlockEntity.costHeat(this.heat, tickSkip, superHeatCount);
            this.heat = costHeatResult.heat;
            superHeatCount = costHeatResult.superHeatCount;
        }
        this.recipeProcessingMap.values().forEach(rP -> {
            rP.addHeat(this, tickSkip);
            this.heat += rP.process(this.getBlockPos(), this.getLevel(), tickSkip);
        });
        boolean storageUpdate = this.storageHeat();
        if (changeSHS || storageUpdate || this.heat != lastHeat) {
            this.sendData();
        }
    }

    private void checkAddHeatRecipeProcessing(List<HeatRecipeProcessing> hRPL) {
        for (HeatRecipeProcessing h : hRPL) {
            if (this.recipeProcessingMap.containsKey(h.processPos)) continue;
            this.recipeProcessingMap.put(h.processPos, h);
        }
    }

    private HeatData genHeat() {
        BlockPos belowPos = this.getBlockPos().below();
        Optional<Holder.Reference<CustomHeater>> customHeatOp = CustomHeater.getFromBlockState(this.getLevel().registryAccess(), this.getLevel().getBlockState(belowPos));
        BlockEntity blockEntity = this.getLevel().getBlockEntity(belowPos);
        if (blockEntity instanceof HeatProvider) {
            HeatProvider provider = (HeatProvider)blockEntity;
            return new HeatData(provider.getHeatPerTick(), provider.getSupperHeatCount());
        }
        if (customHeatOp.isPresent()) {
            CustomHeater customHeater = (CustomHeater)customHeatOp.get().value();
            return new HeatData(customHeater.heatPerTick(), customHeater.superHeatCount());
        }
        BlazeBurnerBlock.HeatLevel heatLevelB = this.getHeatLevel(belowPos);
        int boilHeat = (int)BoilerHeater.findHeat((Level)this.getLevel(), (BlockPos)this.getBlockPos().below(), (BlockState)this.getLevel().getBlockState(this.getBlockPos().below())) + 1;
        int result = Math.max(this.getHeatPerTick(heatLevelB), boilHeat);
        if (!((Boolean)Config.ALLOW_PASSIVE_HEAT.get()).booleanValue()) {
            result = result == 1 ? 0 : result;
        }
        return new HeatData(result, result >= 3 ? 1 : 0);
    }

    private CostHeatResult costHeat(int heat, int tickSkip, int superHeat) {
        boolean canSuperHeat;
        if (!this.needToHeat()) {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.NONE);
            return new CostHeatResult(heat, superHeat);
        }
        boolean bl = canSuperHeat = (Boolean)Config.ALLOW_GENERATE_SUPER_HEAT.get() != false || superHeat > 0;
        if (canSuperHeat && heat >= this.calculateHeatCost(tickSkip, BlazeBurnerBlock.HeatLevel.SEETHING)) {
            if (this.needToHeatUp(BlazeBurnerBlock.HeatLevel.SEETHING)) {
                this.setBlockHeat(BlazeBurnerBlock.HeatLevel.SEETHING);
            }
        } else if (heat >= this.calculateHeatCost(tickSkip, BlazeBurnerBlock.HeatLevel.KINDLED)) {
            if (this.needToHeatUp(BlazeBurnerBlock.HeatLevel.KINDLED) || this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING)) {
                this.setBlockHeat(BlazeBurnerBlock.HeatLevel.KINDLED);
            }
        } else {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.NONE);
        }
        if (!((Boolean)Config.ALLOW_SUPER_HEAT_REPRODUCE.get()).booleanValue() && this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING)) {
            --superHeat;
        }
        return new CostHeatResult(heat - this.calculateHeatCost(tickSkip, this.getHeatLevel()), superHeat);
    }

    private boolean storageHeat() {
        boolean blockUpdate = false;
        if (this.heat > 0) {
            int left = this.heat;
            for (StoneHeatStorage stoneHeatStorage : this.stoneHeatStorages) {
                if (left > 0) {
                    int inserted = stoneHeatStorage.insert(left);
                    left -= inserted;
                }
                blockUpdate = blockUpdate || stoneHeatStorage.updateBlockState(this.getLevel(), this.getControllerPos());
            }
            if (left > 0) {
                this.heatStorage.insert(left);
            }
        }
        return blockUpdate;
    }

    private void releaseHeat() {
        if (this.heat <= 0) {
            for (StoneHeatStorage stoneHeatStorage : this.stoneHeatStorages) {
                int need = this.heatStorage.getCapacity() - this.heatStorage.getAmount();
                if (need <= 0) continue;
                int toExtract = stoneHeatStorage.extract(need, true);
                toExtract = this.heatStorage.insert(toExtract);
                stoneHeatStorage.extract(toExtract, false);
            }
            this.heat += this.heatStorage.extract(this.heatStorage.getAmount(), false);
        }
    }

    private boolean isPosInStoneHeatStorage(BlockPos checkPos) {
        if (this.isController()) {
            return this.stoneHeatStorages.stream().anyMatch(sHs -> sHs.hasPos(checkPos));
        }
        return this.getControllerEntity().isPosInStoneHeatStorage(checkPos);
    }

    private Optional<StoneHeatStorage> findOldStoneHeatStorage(StoneHeatStorage newSHS) {
        if (this.isController()) {
            return this.stoneHeatStorages.stream().filter(oldSHS -> !oldSHS.stonePosSet.isEmpty() && newSHS.stonePosSet.contains(oldSHS.stonePosSet.iterator().next())).findFirst();
        }
        return this.getControllerEntity().findOldStoneHeatStorage(newSHS);
    }

    public boolean acceptNewStoneHeatStorage(StoneHeatStorage oldSHS) {
        if (this.isController()) {
            if (oldSHS.isConnect(this.connectedBlocks)) {
                this.stoneHeatStoragesToAddLater.add(new StoneHeatStorage(oldSHS, this.getControllerPos()));
                return true;
            }
            return false;
        }
        return this.getControllerEntity().acceptNewStoneHeatStorage(oldSHS);
    }

    public int calculateHeatCost(int tickSkip, BlazeBurnerBlock.HeatLevel heatLevel) {
        return tickSkip * this.getHeatPerTick(heatLevel);
    }

    public int getHeatPerTick(BlazeBurnerBlock.HeatLevel heatLevel) {
        return switch (heatLevel) {
            default -> throw new MatchException(null, null);
            case BlazeBurnerBlock.HeatLevel.NONE -> 0;
            case BlazeBurnerBlock.HeatLevel.SMOULDERING -> 1;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> (Integer)Config.HEAT_PER_FADING_BLAZE.get();
            case BlazeBurnerBlock.HeatLevel.SEETHING -> (Integer)Config.HEAT_PER_SEETHING_BLAZE.get();
        };
    }

    private boolean needToHeatUp(BlazeBurnerBlock.HeatLevel heatLevel) {
        return this.needToHeat() && (this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.NONE) || heatLevel.equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING) && !this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING));
    }

    private boolean needToHeat() {
        return this.needToHeatAbove() || this.canProcessRecipe(this.getBlockPos());
    }

    private List<HeatRecipeProcessing> getRecipes() {
        ArrayList<HeatRecipeProcessing> rPList = new ArrayList<HeatRecipeProcessing>();
        BlockUtil.AllDirectionOf(this.getBlockPos(), checkPos -> {
            BlockState checkState = this.getLevel().getBlockState(checkPos);
            HeatRecipe.HeatRecipeTester tester = new HeatRecipe.HeatRecipeTester(checkState);
            Optional optionalRH = this.getLevel().getRecipeManager().getRecipeFor((RecipeType)CHRecipes.HEAT_RECIPE.get(), (RecipeInput)tester, this.getLevel());
            if (optionalRH.isPresent()) {
                AtomicReference oHRP = new AtomicReference(Optional.empty());
                BlockUtil.AllDirectionOf(checkPos, checkControllerPos -> {
                    ThermalBlockEntity otherTE;
                    BlockEntity patt0$temp;
                    if (!checkControllerPos.equals((Object)this.getBlockPos()) && (patt0$temp = this.getLevel().getBlockEntity(checkControllerPos)) instanceof ThermalBlockEntity && !(otherTE = (ThermalBlockEntity)patt0$temp).getControllerPos().equals((Object)this.getControllerPos())) {
                        oHRP.set(otherTE.getRecipeByOther((BlockPos)checkPos));
                    }
                }, c -> ((Optional)oHRP.get()).isPresent());
                HeatRecipeProcessing hRP = oHRP.get().orElse(new HeatRecipeProcessing((BlockPos)checkPos, this.getControllerPos(), (RecipeHolder<HeatRecipe>)((RecipeHolder)optionalRH.get())));
                rPList.add(hRP);
            }
        });
        return rPList;
    }

    private Optional<HeatRecipeProcessing> getRecipeByOther(BlockPos pos) {
        return Optional.ofNullable(this.getControllerEntity().recipeProcessingMap.get(pos));
    }

    /*
     * Unable to fully structure code
     */
    public boolean needToHeatAbove() {
        needToHeatAbove = this.getLevel().getBlockState(this.getBlockPos().above()).is(CHTags.BlockTag.SHOULD_HEAT);
        var4_2 = this.getLevel().getBlockEntity(this.getBlockPos().above());
        if (!(var4_2 instanceof FluidTankBlockEntity)) ** GOTO lbl-1000
        fluidTankBlockEntity = (FluidTankBlockEntity)var4_2;
        if (fluidTankBlockEntity.getControllerBE().boiler.attachedEngines > 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        needToHeatBoiler = v0;
        return needToHeatAbove != false || needToHeatBoiler != false;
    }

    public boolean canProcessRecipe(BlockPos pos) {
        if (this.isController()) {
            AtomicBoolean c = new AtomicBoolean(false);
            BlockUtil.AllDirectionOf(pos, checkPos -> c.set(this.recipeProcessingMap.containsKey(checkPos)), b -> c.get());
            return c.get();
        }
        return this.getControllerEntity() != null && this.getControllerEntity().canProcessRecipe(this.getBlockPos());
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevel(BlockPos pos) {
        BlockState blockState = this.getLevel().getBlockState(pos);
        return blockState.hasProperty((Property)BlazeBurnerBlock.HEAT_LEVEL) ? (BlazeBurnerBlock.HeatLevel)blockState.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL) : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevel() {
        return (BlazeBurnerBlock.HeatLevel)this.getBlockState().getValue((Property)BlazeBurnerBlock.HEAT_LEVEL);
    }

    public void setBlockHeat(BlazeBurnerBlock.HeatLevel heatLevel) {
        this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)heatLevel), 3);
        this.notifyUpdate();
    }

    public void checkNeighbour() {
        if (!this.isController) {
            AtomicBoolean foundConnect = new AtomicBoolean(false);
            BlockUtil.AllDirectionOf(this.getBlockPos(), checkPos -> {
                BlockEntity patt0$temp = this.getLevel().getBlockEntity(checkPos);
                if (patt0$temp instanceof ThermalBlockEntity) {
                    ThermalBlockEntity controllerEntity;
                    ThermalBlockEntity neighbourEntity = (ThermalBlockEntity)patt0$temp;
                    this.isController = false;
                    if (!foundConnect.get()) {
                        this.controllerPos = neighbourEntity.getControllerPos();
                        foundConnect.set(true);
                    }
                    if ((controllerEntity = this.getControllerEntity()) != null) {
                        controllerEntity.addConnectedPos(this.getBlockPos());
                        if (!neighbourEntity.getControllerPos().equals((Object)this.controllerPos)) {
                            if (neighbourEntity.getControllerEntity() != null) {
                                neighbourEntity.getControllerEntity().isController = false;
                            }
                            controllerEntity.walkAllBlocks(null);
                        }
                    }
                }
            });
            if (!foundConnect.get()) {
                this.isController = true;
                this.controllerPos = this.getBlockPos();
                this.addConnectedPos(this.getBlockPos());
            }
        }
    }

    public void addConnectedPos(BlockPos pos) {
        this.connectedBlocks.add(pos);
        this.calculateHeatStorage();
    }

    public void destroy() {
        if (this.isController()) {
            this.stoneHeatStorages.forEach(sHS -> sHS.disconnect(this.getBlockPos()));
            for (BlockPos pos : this.connectedBlocks) {
                BlockEntity blockEntity;
                if (pos.equals((Object)this.getBlockPos()) || !((blockEntity = this.getLevel().getBlockEntity(pos)) instanceof ThermalBlockEntity)) continue;
                ThermalBlockEntity thermalBlockEntity = (ThermalBlockEntity)blockEntity;
                thermalBlockEntity.isController = true;
                thermalBlockEntity.walkAllBlocks(this.getBlockPos());
                break;
            }
        } else {
            BlockEntity blockEntity = this.getLevel().getBlockEntity(this.controllerPos);
            if (blockEntity instanceof ThermalBlockEntity) {
                ThermalBlockEntity thermalBlockEntity = (ThermalBlockEntity)blockEntity;
                thermalBlockEntity.walkAllBlocks(this.getBlockPos());
            }
        }
        super.destroy();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HeatStorage heatStorageForDisplay;
        ThermalBlockEntity controllerEntity = this.getControllerEntity();
        if (controllerEntity != null && (heatStorageForDisplay = controllerEntity.displayHeatStorage) != null) {
            tooltip.add((Component)Component.literal((String)Strings.repeat((char)' ', (int)4)).append((Component)Component.translatable((String)"createheat.gui.goggles.heat_amount", (Object[])new Object[]{heatStorageForDisplay.getAmount(), heatStorageForDisplay.getCapacity()})));
            tooltip.add((Component)Component.literal((String)Strings.repeat((char)' ', (int)4)).append((Component)Component.translatable((String)"createheat.gui.goggles.heat_remain", (Object[])new Object[]{this.getControllerEntity().heat / 10})));
            return true;
        }
        return false;
    }

    public void walkAllBlocks(BlockPos exceptFor) {
        Set<BlockPos> oldBlocks = Set.copyOf(this.connectedBlocks);
        this.connectedBlocks.clear();
        BlockUtil.walkAllBlocks(this.getBlockPos(), this.connectedBlocks, pos -> {
            BlockEntity patt0$temp;
            if (!pos.equals((Object)exceptFor) && (patt0$temp = this.getLevel().getBlockEntity(pos)) instanceof ThermalBlockEntity) {
                ThermalBlockEntity thermalBlockEntity = (ThermalBlockEntity)patt0$temp;
                thermalBlockEntity.controllerPos = this.getBlockPos();
                return true;
            }
            return false;
        });
        for (BlockPos pos2 : oldBlocks) {
            ThermalBlockEntity thermalBlockEntity;
            BlockEntity blockEntity;
            if (this.connectedBlocks.contains(pos2) || !((blockEntity = this.getLevel().getBlockEntity(pos2)) instanceof ThermalBlockEntity) || (thermalBlockEntity = (ThermalBlockEntity)blockEntity).isController() || !thermalBlockEntity.getControllerPos().equals((Object)this.getBlockPos())) continue;
            thermalBlockEntity.isController = true;
            thermalBlockEntity.walkAllBlocks(exceptFor);
        }
        this.calculateHeatStorage();
        this.notifyUpdate();
    }

    private void calculateHeatStorage() {
        this.heatStorage.setCapacity(this.connectedBlocks.size() * MAX_HEAT.get());
    }

    public HeatStorage getAllHeatForDisplay() {
        HeatStorage result = new HeatStorage(0);
        for (HeatStorage heatStorage : this.stoneHeatStorages) {
            result.setCapacity(result.getCapacity() + heatStorage.getCapacity());
            result.insert(heatStorage.getAmount());
        }
        result.setCapacity(result.getCapacity() + this.heatStorage.getCapacity());
        result.insert(this.heatStorage.getAmount());
        return result;
    }

    public ThermalBlockEntity getControllerEntity() {
        BlockEntity blockEntity;
        if (this.isController) {
            return this;
        }
        if (this.controllerPos != null && (blockEntity = this.getLevel().getBlockEntity(this.controllerPos)) instanceof ThermalBlockEntity) {
            ThermalBlockEntity controllerEntity = (ThermalBlockEntity)blockEntity;
            return controllerEntity.isController() ? controllerEntity : null;
        }
        return null;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean isController() {
        return this.isController;
    }

    public BlockPos getControllerPos() {
        return this.isController ? this.getBlockPos() : this.controllerPos;
    }

    public Set<BlockPos> getConnectedBlocks() {
        return this.isController ? this.connectedBlocks : this.getControllerEntity().getConnectedBlocks();
    }

    public int getHeat() {
        return this.heat;
    }

    public HeatStorage getHeatStorage() {
        if (this.isController()) {
            return this.heatStorage;
        }
        return this.getControllerEntity().getHeatStorage();
    }

    private record HeatData(int heat, int superHeatCount) {
    }

    private record CostHeatResult(int heat, int superHeatCount) {
    }

    private static class HeatRecipeProcessing {
        private final BlockPos processPos;
        private BlockPos recordControllerPos;
        private RecipeHolder<HeatRecipe> recipe;
        private int heatAccept;
        private int heatGot;
        private boolean finished;
        private String recipeId;

        private HeatRecipeProcessing(BlockPos processPos, BlockPos recordControllerPos, RecipeHolder<HeatRecipe> recipe, int heatGot) {
            this.processPos = processPos;
            this.recordControllerPos = recordControllerPos;
            this.recipe = recipe;
            this.heatAccept = 0;
            this.heatGot = heatGot;
        }

        private HeatRecipeProcessing(BlockPos processPos, BlockPos recordControllerPos, RecipeHolder<HeatRecipe> recipe) {
            this(processPos, recordControllerPos, recipe, 0);
        }

        private HeatRecipeProcessing(BlockPos processPos, BlockPos recordControllerPos, String recipeId, int heatGot) {
            this(processPos, recordControllerPos, (RecipeHolder<HeatRecipe>)((RecipeHolder)null), heatGot);
            this.recipeId = recipeId;
        }

        private void addHeat(ThermalBlockEntity controller, int tickSkip) {
            BlockUtil.AllDirectionOf(this.processPos, pos -> {
                if (controller.getConnectedBlocks().contains(pos)) {
                    BlazeBurnerBlock.HeatLevel heatLevel = controller.getHeatLevel((BlockPos)pos);
                    this.heatAccept += controller.calculateHeatCost(tickSkip, heatLevel);
                }
            });
        }

        private int process(BlockPos controllerPos, Level level, int tickSkip) {
            if (!controllerPos.equals((Object)this.recordControllerPos)) {
                this.checkRecordController(level, controllerPos);
                return 0;
            }
            if (this.recipe == null) {
                this.initRecipe(level.getRecipeManager());
            }
            if (!this.checkInputBlock(level)) {
                this.finished = true;
            }
            HeatRecipe heatRecipe = (HeatRecipe)this.recipe.value();
            int tmpHeatAccept = this.heatAccept;
            this.heatAccept = 0;
            if (this.finished || tmpHeatAccept < heatRecipe.getMinHeatPerTick() * tickSkip) {
                return tmpHeatAccept;
            }
            int heatFinal = this.heatGot + tmpHeatAccept;
            if (heatFinal >= heatRecipe.getHeatCost()) {
                this.heatGot = heatRecipe.getHeatCost();
                this.finished = true;
                BlockState outputState = heatRecipe.getOutputBlock();
                if (outputState.getFluidState().is(FluidTags.WATER) && level.dimensionType().ultraWarm()) {
                    level.destroyBlock(this.processPos, false);
                } else {
                    level.setBlock(this.processPos, heatRecipe.getOutputBlock(), 3);
                }
                return heatFinal - heatRecipe.getHeatCost();
            }
            this.heatGot = heatFinal;
            return 0;
        }

        private void initRecipe(RecipeManager recipeManager) {
            Optional<RecipeHolder> recipeOp = recipeManager.getAllRecipesFor((RecipeType)CHRecipes.HEAT_RECIPE.get()).stream().filter(h -> h.id().toString().equals(this.recipeId)).findFirst();
            this.recipe = recipeOp.orElse(null);
            if (this.recipe == null) {
                this.finished = true;
            }
        }

        private void checkRecordController(Level level, BlockPos newPos) {
            if (!(level.getBlockEntity(this.recordControllerPos) instanceof ThermalBlockEntity)) {
                this.recordControllerPos = newPos;
            }
        }

        private boolean checkInputBlock(Level level) {
            HeatRecipe.HeatRecipeTester tester = new HeatRecipe.HeatRecipeTester(level.getBlockState(this.processPos));
            Optional heatRecipeRecipeHolderOp = level.getRecipeManager().getRecipeFor((RecipeType)CHRecipes.HEAT_RECIPE.get(), (RecipeInput)tester, level);
            if (heatRecipeRecipeHolderOp.isPresent()) {
                RecipeHolder heatRecipeH = (RecipeHolder)heatRecipeRecipeHolderOp.get();
                return heatRecipeH.id().equals((Object)this.recipe.id());
            }
            return false;
        }

        private CompoundTag toNbt(BlockPos controllerPos) {
            if (controllerPos.equals((Object)this.recordControllerPos)) {
                CompoundTag nbt = new CompoundTag();
                nbt.put("process_pos", NbtUtils.writeBlockPos((BlockPos)this.processPos));
                nbt.putInt("heat_got", this.heatGot);
                nbt.putString("id", this.recipe == null ? this.recipeId : this.recipe.id().toString());
                return nbt;
            }
            return null;
        }

        private static HeatRecipeProcessing fromNbt(CompoundTag nbt, BlockPos recordControllerPos) {
            BlockPos processPos = NBTHelper.readBlockPos((CompoundTag)nbt, (String)"process_pos");
            int heatGot = nbt.getInt("heat_got");
            String recipeId = nbt.getString("id");
            return new HeatRecipeProcessing(processPos, recordControllerPos, recipeId, heatGot);
        }
    }
}

