/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.compat;

import com.ffsupver.createheat.compat.CHModCompat;
import com.ffsupver.createheat.compat.iceAndFire.IceAndFire;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class Mods {
    private static Map<String, Supplier<CHModCompat>> MODS = new HashMap<String, Supplier<CHModCompat>>();

    private static void loadMods() {
        MODS.clear();
        Mods.addMod(ModIds.IceAndFire.ModId, IceAndFire::new);
    }

    public static void init(IEventBus eventBus) {
        Mods.loadMods();
        for (Map.Entry<String, Supplier<CHModCompat>> entry : MODS.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            entry.getValue().get().init(eventBus);
        }
    }

    public static void registerPonder(PonderSceneRegistrationHelper<ItemProviderEntry<?, ?>> HELPER) {
        Mods.loadMods();
        for (Map.Entry<String, Supplier<CHModCompat>> entry : MODS.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            entry.getValue().get().registerPonder(HELPER);
        }
    }

    private static void addMod(String modId, Supplier<CHModCompat> modCompatSupplier) {
        if (ModList.get().isLoaded(modId)) {
            MODS.put(modId, modCompatSupplier);
        }
    }

    public static void addItemsToCreativeTab(BuildCreativeModeTabContentsEvent event, ResourceKey<CreativeModeTab> tabKey, ItemLike ... itemLikes) {
        if (event.getTabKey().equals(tabKey)) {
            Arrays.stream(itemLikes).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }

    public static enum ModIds {
        IceAndFire("iceandfire");

        public final String ModId;

        private ModIds(String modId) {
            this.ModId = modId;
        }
    }
}

