/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.item;

import com.ffsupver.createheat.block.thermalBlock.ThermalBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ThermalTool
extends Item {
    public ThermalTool(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ThermalBlockEntity) {
            ThermalBlockEntity thermalBlockEntity = (ThermalBlockEntity)blockEntity;
            Player player = context.getPlayer();
            BlockPos controllerPos = thermalBlockEntity.getControllerPos();
            ThermalBlockEntity controllerEntity = thermalBlockEntity.getControllerEntity();
            if (player != null && !level.isClientSide()) {
                if (player.isCrouching()) {
                    player.displayClientMessage((Component)Component.literal((String)("total heat:" + String.valueOf(controllerEntity.getAllHeatForDisplay()))).withStyle(ChatFormatting.RED), true);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)("Connect count :" + controllerEntity.getConnectedBlocks().size() + " heat:" + controllerEntity.getHeat() + " Controller x:" + controllerPos.getX() + " y:" + controllerPos.getY() + " z:" + controllerPos.getZ() + " heatStorage:" + String.valueOf(controllerEntity.getHeatStorage()))).withStyle(ChatFormatting.RED), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (level.getBlockState(pos).is(Blocks.TNT) && !level.isClientSide()) {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 5.0f, true, Level.ExplosionInteraction.TRIGGER);
        }
        return super.useOn(context);
    }

    public boolean useOnRelease(ItemStack stack) {
        return super.useOnRelease(stack);
    }
}

