/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.recipe;

import com.ffsupver.createheat.api.BlockStateTester;
import com.ffsupver.createheat.recipe.RecipeBuildHelper;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HeatRecipe
implements Recipe<HeatRecipeTester> {
    private final BlockStateTester inputBlock;
    private final BlockState outputBlock;
    private final int heatCost;
    private final int minHeatPerTick;
    public static final String ID = "heat";
    public static final RecipeType<HeatRecipe> TYPE = RecipeBuildHelper.recipeType("heat");
    public static final RecipeSerializer<HeatRecipe> SERIALIZER = RecipeBuildHelper.recipeSerializer(HeatRecipe.fromJson());

    public HeatRecipe(BlockStateTester inputBlock, BlockState outputBlock, int heatCost, int minHeatPerTick) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.heatCost = heatCost;
        this.minHeatPerTick = minHeatPerTick;
    }

    public boolean matches(HeatRecipeTester heatRecipeTester, Level level) {
        return heatRecipeTester.checkState(this.inputBlock);
    }

    public ItemStack assemble(HeatRecipeTester recipeInput, HolderLookup.Provider provider) {
        return this.outputBlock.getBlock().asItem().getDefaultInstance();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.outputBlock.getBlock().asItem().getDefaultInstance();
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return TYPE;
    }

    public String toString() {
        return "Input : " + String.valueOf(this.inputBlock) + " Output : " + String.valueOf(this.outputBlock) + " cost:" + this.heatCost + " min:" + this.minHeatPerTick;
    }

    public BlockState getOutputBlock() {
        return this.outputBlock;
    }

    public int getHeatCost() {
        return this.heatCost;
    }

    public int getMinHeatPerTick() {
        return this.minHeatPerTick;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputBlock.toIngredient();
    }

    private static MapCodec<HeatRecipe> fromJson() {
        return RecordCodecBuilder.mapCodec(p -> {
            Products.P4 p1 = p.group((App)Codec.INT.fieldOf(ID).forGetter(h -> h.heatCost), (App)BlockStateTester.CODEC.fieldOf("input").forGetter(h -> h.inputBlock), (App)BlockState.CODEC.fieldOf("output").forGetter(h -> h.outputBlock), (App)Codec.INT.fieldOf("min_heat").forGetter(h -> h.minHeatPerTick));
            return p1.apply((Applicative)p, (heat, input, output, min) -> new HeatRecipe((BlockStateTester)input, (BlockState)output, (int)heat, (int)min));
        });
    }

    public static class HeatRecipeTester
    implements RecipeInput {
        private final BlockState state;

        public HeatRecipeTester(BlockState state) {
            this.state = state;
        }

        public boolean checkState(BlockStateTester tester) {
            return tester.test(this.state);
        }

        public ItemStack getItem(int i) {
            return ItemStack.EMPTY;
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return this.state.isAir();
        }
    }
}

