/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.api;

import com.ffsupver.createheat.mixin.ChunkMapAccessor;
import com.ffsupver.createheat.registries.CHBoilerUpdaters;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class BoilerUpdater {
    private static int cooldown;

    public static void registerEvent(ServerTickEvent.Post event) {
        if (--cooldown <= 0) {
            event.getServer().getAllLevels().forEach(BoilerUpdater::processLevelBlockEntities);
            cooldown = 20;
        }
    }

    private static void processLevelBlockEntities(ServerLevel level) {
        ChunkMap chunkMap = level.getChunkSource().chunkMap;
        if (chunkMap instanceof ChunkMapAccessor) {
            ChunkMapAccessor chunkMapAccessor = (ChunkMapAccessor)chunkMap;
            for (ChunkHolder chunkHolder : chunkMapAccessor.getChunksAccessor()) {
                LevelChunk chunk = chunkHolder.getTickingChunk();
                if (chunk == null || !level.shouldTickBlocksAt(chunk.getPos().toLong())) continue;
                BoilerUpdater.processChunkBlockEntities(chunk, level);
            }
        }
    }

    private static void processChunkBlockEntities(LevelChunk chunk, ServerLevel level) {
        chunk.getBlockEntities().forEach((pos, blockEntity) -> {
            if (blockEntity instanceof FluidTankBlockEntity) {
                BlockPos posBelow;
                FluidTankBlockEntity fluidTankBlockEntity = (FluidTankBlockEntity)blockEntity;
                if (fluidTankBlockEntity.getControllerBE().boiler.attachedEngines > 0 && !(chunk.getBlockEntity(posBelow = pos.below()) instanceof FluidTankBlockEntity) && CHBoilerUpdaters.shouldUpdate(posBelow, level)) {
                    fluidTankBlockEntity.getControllerBE().updateBoilerTemperature();
                }
            }
        });
    }

    @FunctionalInterface
    public static interface Tester {
        public boolean shouldUpdate(BlockPos var1, ServerLevel var2);
    }
}

