/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.block.ConnectableBlock;
import com.ffsupver.createheat.block.thermalBlock.BaseThermalBlockEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BaseThermalBlock<T extends BaseThermalBlockEntity>
extends ConnectableBlock<BaseThermalBlockEntity, T>
implements IWrenchable {
    private final Class<T> blockEntityClass;
    private final Supplier<BlockEntityType<? extends T>> blockEntityType;

    public BaseThermalBlock(BlockBehaviour.Properties properties, Class<T> blockEntityClass, Supplier<BlockEntityType<? extends T>> blockEntityType) {
        super(properties);
        this.blockEntityClass = blockEntityClass;
        this.blockEntityType = blockEntityType;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.NONE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlazeBurnerBlock.HEAT_LEVEL});
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return switch ((BlazeBurnerBlock.HeatLevel)state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL)) {
            default -> throw new MatchException(null, null);
            case BlazeBurnerBlock.HeatLevel.NONE -> 0;
            case BlazeBurnerBlock.HeatLevel.SMOULDERING, BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> 15;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> 12;
        };
    }

    public Class<T> getBlockEntityClass() {
        return this.blockEntityClass;
    }

    public BlockEntityType<? extends T> getBlockEntityType() {
        return this.blockEntityType.get();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BaseThermalBlock.addParticles(state, level, pos, random);
    }

    public static void addParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((BlazeBurnerBlock.HeatLevel)state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL)).equals((Object)BlazeBurnerBlock.HeatLevel.NONE) && random.nextInt(2) == 0) {
            Direction direction = Direction.getRandom((RandomSource)random);
            BlockPos particlePos = pos.relative(direction);
            BlockState particlePosState = level.getBlockState(particlePos);
            if (!state.canOcclude() || !particlePosState.isFaceSturdy((BlockGetter)level, particlePos, direction.getOpposite())) {
                double d0 = direction.getStepX() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepX() * 0.5;
                double d1 = direction.getStepY() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepY() * 0.5;
                double d2 = direction.getStepZ() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.5;
                Vec3 position = new Vec3((double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2);
                Vec3 speed = position.subtract(pos.getCenter()).scale(random.nextDouble() * (double)0.04f);
                SimpleParticleType particleOptions = ((BlazeBurnerBlock.HeatLevel)state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL)).equals((Object)BlazeBurnerBlock.HeatLevel.KINDLED) ? ParticleTypes.FLAME : ParticleTypes.SOUL_FIRE_FLAME;
                level.addParticle((ParticleOptions)particleOptions, position.x(), position.y(), position.z(), speed.x(), speed.y(), speed.z());
            }
        }
    }
}

