/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.block.thermalBlock.BaseThermalBlockEntity;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlockEntityBehaviour;
import com.ffsupver.createheat.registries.CHIcons;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SmartThermalBlockEntity
extends BaseThermalBlockEntity
implements IHaveGoggleInformation {
    private ScrollOptionBehaviour<MaxHeatSelections> maxHeatLevelSelections;

    public SmartThermalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        ThermalBlockEntityBehaviour thermalBlockEntityBehaviour = new ThermalBlockEntityBehaviour(this);
        thermalBlockEntityBehaviour.setCanHeat(tBEB -> this.canHeat(BlazeBurnerBlock.HeatLevel.KINDLED));
        thermalBlockEntityBehaviour.setCanSuperHeat(tBEB -> this.canHeat(BlazeBurnerBlock.HeatLevel.SEETHING));
        thermalBlockEntityBehaviour.setCanGenerateHeatIgnoreHTP(tBEB -> this.canGenerateHeatIgnoreHTP());
        behaviours.add(thermalBlockEntityBehaviour);
        this.maxHeatLevelSelections = new ScrollOptionBehaviour(MaxHeatSelections.class, (Component)Component.translatable((String)"createheat.smart_thermal_block.selection_mode.max_heat"), (SmartBlockEntity)this, (ValueBoxTransform)new CenteredSideValueBoxTransform());
        behaviours.add((BlockEntityBehaviour)this.maxHeatLevelSelections);
    }

    private boolean canHeat(BlazeBurnerBlock.HeatLevel heatLevel) {
        BlazeBurnerBlock.HeatLevel maxHeatLevel = ((MaxHeatSelections)this.maxHeatLevelSelections.get()).getHeatLevel();
        return heatLevel.ordinal() <= maxHeatLevel.ordinal();
    }

    private boolean canGenerateHeatIgnoreHTP() {
        return ((MaxHeatSelections)this.maxHeatLevelSelections.get()).equals((Object)MaxHeatSelections.NONE_HEAT);
    }

    private static enum MaxHeatSelections implements INamedIconOptions
    {
        NONE_HEAT("none", CHIcons.I_HEAT_LEVEL_NONE, BlazeBurnerBlock.HeatLevel.NONE),
        KINDLED_HEAT("kindled", CHIcons.I_HEAT_LEVEL_KINDLED, BlazeBurnerBlock.HeatLevel.KINDLED),
        SEETHING_HEAT("seething", CHIcons.I_HEAT_LEVEL_SEETHING, BlazeBurnerBlock.HeatLevel.SEETHING);

        private final String name;
        private final CHIcons icon;
        private final BlazeBurnerBlock.HeatLevel heatLevel;

        private MaxHeatSelections(String name, CHIcons icon, BlazeBurnerBlock.HeatLevel heatLevel) {
            this.name = name;
            this.icon = icon;
            this.heatLevel = heatLevel;
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return "createheat.smart_thermal_block.selection_mode." + this.name;
        }

        public BlazeBurnerBlock.HeatLevel getHeatLevel() {
            return this.heatLevel;
        }
    }
}

