/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.compat.jei;

import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.compat.jei.category.HeatCategory;
import com.ffsupver.createheat.registries.CHBlocks;
import com.ffsupver.createheat.registries.CHItems;
import com.ffsupver.createheat.registries.CHRecipes;
import dev.dubhe.anvilcraft.integration.jei.AnvilCraftJeiPlugin;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class CreateHeatJEI
implements IModPlugin {
    public static ResourceLocation ID = CreateHeat.asResource("jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new HeatCategory()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(HeatCategory.TYPE, CreateHeatJEI.fillRecipes((net.minecraft.world.item.crafting.RecipeType)CHRecipes.HEAT_RECIPE.get()));
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, List.of(CHItems.THERMAL_TOOL.asStack()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        CreateHeatJEI.registerWithThermalBlocks(b -> registration.addRecipeCatalyst((ItemLike)b, new RecipeType[]{HeatCategory.TYPE}));
        CreateHeatJEI.registerWithThermalBlocks(b -> registration.addRecipeCatalyst((ItemLike)b, new RecipeType[]{AnvilCraftJeiPlugin.SUPER_HEATING}));
    }

    public static <T> RecipeType<T> recipeType(String path, Class<T> recipeClass) {
        return RecipeType.create((String)"createheat", (String)path, recipeClass);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getAllRecipes(net.minecraft.world.item.crafting.RecipeType<T> recipeType) {
        return Minecraft.getInstance().getConnection().getRecipeManager().getAllRecipesFor(recipeType);
    }

    private static <I extends RecipeInput, T extends Recipe<I>> List<T> fillRecipes(net.minecraft.world.item.crafting.RecipeType<T> recipeType) {
        return CreateHeatJEI.getAllRecipes(recipeType).stream().map(RecipeHolder::value).toList();
    }

    private static void registerWithThermalBlocks(Consumer<Block> registerFunc) {
        registerFunc.accept((Block)CHBlocks.THERMAL_BLOCK.get());
        registerFunc.accept((Block)CHBlocks.SMART_THERMAL_BLOCK.get());
    }
}

