/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.registries;

import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.block.HeatTransferProcesser;
import com.ffsupver.createheat.recipe.HeatRecipeTransferProcesser;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public class CHHeatTransferProcessers {
    private static final CreateRegistrate REGISTRATE = CreateHeat.registrate();
    private static final CreateRegistrate t = CreateRegistrate.create((String)"dasd");
    private static final Set<Predicate<BlockState>> NEED_TO_HEAT_UP_OPTIONAL = new HashSet<Predicate<BlockState>>();
    public static final ResourceKey<Registry<HeatTransferProcesserBuilder>> HEAT_PROCESSOR_REGISTRY_KEY = REGISTRATE.makeRegistry("htp", RegistryBuilder::new);

    public static void bootSetup() {
        CHHeatTransferProcessers.registerHeatTransferProcesser(HeatRecipeTransferProcesser.TYPE.getPath(), () -> HeatRecipeTransferProcesser::new);
        CHHeatTransferProcessers.registerHeatTransferProcesser(OptionalNeedHeatUpBlockHTP.TYPE.getPath(), () -> OptionalNeedHeatUpBlockHTP::new);
    }

    public static void registerHeatTransferProcesser(String name, Supplier<HeatTransferProcesserBuilder> heatTransferProcesserBuilder) {
        REGISTRATE.generic(name, HEAT_PROCESSOR_REGISTRY_KEY, NonNullSupplier.of(heatTransferProcesserBuilder)).register();
    }

    public static void registerOptionalNeedHeatBlock(Predicate<BlockState> tester) {
        NEED_TO_HEAT_UP_OPTIONAL.add(tester);
    }

    public static Optional<HeatTransferProcesser> findProcesser(Level level, BlockPos blockPos, Direction face) {
        return REGISTRATE.getAll(HEAT_PROCESSOR_REGISTRY_KEY).stream().map(d -> ((HeatTransferProcesserBuilder)d.get()).create()).filter(h -> h.needHeat(level, blockPos, face)).findFirst();
    }

    public static HeatTransferProcesser fromNbt(Tag tag) {
        Optional<HeatTransferProcesser> heatTransferProcesserOp;
        CompoundTag nbt = (CompoundTag)tag;
        if (nbt.contains("type", 8) && (heatTransferProcesserOp = REGISTRATE.getAll(HEAT_PROCESSOR_REGISTRY_KEY).stream().filter(rE -> rE.getId().equals((Object)ResourceLocation.parse((String)nbt.getString("type")))).map(d -> ((HeatTransferProcesserBuilder)d.get()).create()).findFirst()).isPresent()) {
            HeatTransferProcesser heatTransferProcesser = heatTransferProcesserOp.get();
            heatTransferProcesser.fromNbt(nbt);
            return heatTransferProcesser;
        }
        return null;
    }

    public static CompoundTag toNbt(HeatTransferProcesser heatTransferProcesser) {
        if (heatTransferProcesser.shouldWriteAndReadFromNbt()) {
            CompoundTag nbt = heatTransferProcesser.toNbt();
            nbt.putString("type", heatTransferProcesser.getTypeId().toString());
            return nbt;
        }
        return null;
    }

    private static class OptionalNeedHeatUpBlockHTP
    extends HeatTransferProcesser {
        protected static ResourceLocation TYPE = CreateHeat.asResource("optional_need_heat_up");

        public OptionalNeedHeatUpBlockHTP() {
            super(TYPE);
        }

        @Override
        public boolean needHeat(Level level, BlockPos pos, @Nullable Direction face) {
            boolean dirT;
            boolean bl = dirT = face == null || Direction.UP.equals((Object)face);
            if (!dirT) {
                return false;
            }
            BlockState state = level.getBlockState(pos);
            return NEED_TO_HEAT_UP_OPTIONAL.stream().anyMatch(sP -> sP.test(state));
        }

        @Override
        public boolean shouldHeatAt(Direction face) {
            return face.equals((Object)Direction.UP);
        }

        @Override
        public void acceptHeat(Level level, BlockPos hTPPos, int heatProvide, int tickSkip) {
        }

        @Override
        public boolean shouldProcessEveryTick() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface HeatTransferProcesserBuilder {
        public HeatTransferProcesser create();
    }
}

