/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.util;

import com.ffsupver.createheat.Config;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class BlockUtil {
    public static void AllDirectionOf(BlockPos startPos, Consumer<BlockPos> f) {
        BlockUtil.AllDirectionOf(startPos, (BlockPos b, Direction fa) -> f.accept((BlockPos)b));
    }

    public static void AllDirectionOf(BlockPos startPos, BiConsumer<BlockPos, Direction> f) {
        BlockUtil.AllDirectionOf(startPos, f, (BlockPos b) -> false);
    }

    public static void AllDirectionOf(BlockPos startPos, Consumer<BlockPos> f, Predicate<BlockPos> shouldBreak) {
        BlockUtil.AllDirectionOf(startPos, (BlockPos b, Direction fa) -> f.accept((BlockPos)b), shouldBreak);
    }

    public static void AllDirectionOf(BlockPos startPos, BiConsumer<BlockPos, Direction> f, Predicate<BlockPos> shouldBreak) {
        for (Direction d : Direction.values()) {
            if (shouldBreak.test(startPos.relative(d))) break;
            f.accept(startPos.relative(d), d);
        }
    }

    public static void walkAllBlocks(BlockPos startPos, Set<BlockPos> walkedBlockPos, Predicate<BlockPos> check, int maxRange, int currentRange) {
        if (currentRange > maxRange || walkedBlockPos.contains(startPos) || !check.test(startPos)) {
            return;
        }
        walkedBlockPos.add(startPos);
        BlockUtil.AllDirectionOf(startPos, (BlockPos neighborPos) -> BlockUtil.walkAllBlocks(neighborPos, walkedBlockPos, check, maxRange, currentRange + 1));
    }

    public static void walkAllBlocks(BlockPos startPos, Set<BlockPos> walkedBlockPos, Predicate<BlockPos> check) {
        BlockUtil.walkAllBlocks(startPos, walkedBlockPos, check, (Integer)Config.MAX_CONNECT_RANGE.get(), 0);
    }

    public static boolean checkState(BlockState checkState, BlockState state) {
        boolean sameBlock = checkState.getBlock().equals(state.getBlock());
        if (!sameBlock) {
            return false;
        }
        Collection properties = checkState.getProperties();
        for (Property property : properties) {
            boolean nS = state.hasProperty(property) && state.getValue(property).equals(checkState.getValue(property));
            if (nS) continue;
            return false;
        }
        return true;
    }

    public static boolean isConnect(Set<BlockPos> set1, Set<BlockPos> set2) {
        for (BlockPos thisPos : set1) {
            for (Direction d : Direction.values()) {
                for (BlockPos thPos : set2) {
                    if (!thisPos.relative(d).equals((Object)thPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

