/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.CHTags;
import com.ffsupver.createheat.Config;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ThermalBlockEntity
extends SmartBlockEntity {
    private boolean isController;
    private BlockPos controllerPos = null;
    private final Set<BlockPos> connectedBlocks = new HashSet<BlockPos>();
    private int heat;
    private final int MAX_HEAT = 50 * (Integer)Config.HEAT_PER_FADING_BLAZE.get();
    private int cooldown = 0;
    private static final int MAX_COOLDOWN = 10;
    private final HeatStorage heatStorage = new HeatStorage(this.MAX_HEAT);

    public ThermalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putBoolean("is_controller", this.isController);
        if (this.isController) {
            ListTag listTag = new ListTag();
            for (BlockPos connectedPos : this.connectedBlocks) {
                CompoundTag connectedPosTag = new CompoundTag();
                connectedPosTag.put("p", NbtUtils.writeBlockPos((BlockPos)connectedPos));
                listTag.add((Object)connectedPosTag);
            }
            tag.put("connected", (Tag)listTag);
            tag.putInt("heat", this.heat);
            tag.putInt("cooldown", this.cooldown);
            tag.put("heat_storage", (Tag)this.heatStorage.toNbt());
        } else {
            tag.put("controller", NbtUtils.writeBlockPos((BlockPos)this.controllerPos));
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.isController = tag.getBoolean("is_controller");
        if (this.isController) {
            this.connectedBlocks.clear();
            ListTag listTag = tag.getList("connected", 10);
            for (Tag compoundTag : listTag) {
                this.connectedBlocks.add(NBTHelper.readBlockPos((CompoundTag)((CompoundTag)compoundTag), (String)"p"));
            }
            this.heat = tag.getInt("heat");
            this.cooldown = tag.getInt("cooldown");
            this.heatStorage.fromNbt(tag.getCompound("heat_storage"));
        } else {
            this.controllerPos = NBTHelper.readBlockPos((CompoundTag)tag, (String)"controller");
        }
    }

    public void tick() {
        super.tick();
        if (!this.isController) {
            return;
        }
        if (this.cooldown < 0) {
            this.tickEveryConnectedBlock();
            this.cooldown = 10;
        } else {
            --this.cooldown;
        }
    }

    public void tickEveryConnectedBlock() {
        if (this.getLevel().isClientSide()) {
            return;
        }
        Set connectedBlockList = this.connectedBlocks.stream().map(pos -> {
            ThermalBlockEntity thermalBlockEntity;
            BlockEntity patt0$temp = this.getLevel().getBlockEntity(pos);
            return patt0$temp instanceof ThermalBlockEntity ? (thermalBlockEntity = (ThermalBlockEntity)patt0$temp) : null;
        }).collect(Collectors.toSet());
        this.heat = 0;
        int superHeatCount = 0;
        for (ThermalBlockEntity thermalBlockEntity : connectedBlockList) {
            int heatBelow = thermalBlockEntity.genHeat();
            this.heat += heatBelow * 10;
            superHeatCount += heatBelow >= 3 ? 1 : 0;
        }
        if (this.heat <= 0) {
            this.heat += this.heatStorage.extract(this.heatStorage.getAmount(), false);
        }
        for (ThermalBlockEntity thermalBlockEntity : connectedBlockList) {
            CostHeatResult costHeatResult = thermalBlockEntity.costHeat(this.heat, 10, superHeatCount);
            this.heat = costHeatResult.heat;
            superHeatCount = costHeatResult.superHeatCount;
        }
        if (this.heat > 0) {
            this.heatStorage.insert(this.heat);
        }
    }

    public int genHeat() {
        BlazeBurnerBlock.HeatLevel heatLevelB = this.getHeatLevel(this.getBlockPos().below());
        int boilHeat = (int)BoilerHeater.findHeat((Level)this.getLevel(), (BlockPos)this.getBlockPos().below(), (BlockState)this.getLevel().getBlockState(this.getBlockPos().below())) + 1;
        int result = Math.max(this.getHeatPerTick(heatLevelB), boilHeat);
        if (((Boolean)Config.ALLOW_PASSIVE_HEAT.get()).booleanValue()) {
            return result;
        }
        return result == 1 ? 0 : result;
    }

    private CostHeatResult costHeat(int heat, int tickSkip, int superHeat) {
        boolean canSuperHeat;
        if (!this.needToHeatAbove()) {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.NONE);
            return new CostHeatResult(heat, superHeat);
        }
        boolean bl = canSuperHeat = (Boolean)Config.ALLOW_GENERATE_SUPER_HEAT.get() != false || superHeat > 0;
        if (canSuperHeat && heat >= this.calculateHeatCost(tickSkip, BlazeBurnerBlock.HeatLevel.SEETHING)) {
            if (this.needToHeatUp(BlazeBurnerBlock.HeatLevel.SEETHING)) {
                this.setBlockHeat(BlazeBurnerBlock.HeatLevel.SEETHING);
            }
        } else if (heat >= this.calculateHeatCost(tickSkip, BlazeBurnerBlock.HeatLevel.KINDLED)) {
            if (this.needToHeatUp(BlazeBurnerBlock.HeatLevel.KINDLED) || this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING)) {
                this.setBlockHeat(BlazeBurnerBlock.HeatLevel.KINDLED);
            }
        } else {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.NONE);
        }
        if (!((Boolean)Config.ALLOW_SUPER_HEAT_REPRODUCE.get()).booleanValue() && this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING)) {
            --superHeat;
        }
        return new CostHeatResult(heat - this.calculateHeatCost(tickSkip, this.getHeatLevel()), superHeat);
    }

    public int calculateHeatCost(int tickSkip, BlazeBurnerBlock.HeatLevel heatLevel) {
        return tickSkip * this.getHeatPerTick(heatLevel);
    }

    public int getHeatPerTick(BlazeBurnerBlock.HeatLevel heatLevel) {
        return switch (heatLevel) {
            default -> throw new MatchException(null, null);
            case BlazeBurnerBlock.HeatLevel.NONE -> 0;
            case BlazeBurnerBlock.HeatLevel.SMOULDERING -> 1;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> (Integer)Config.HEAT_PER_FADING_BLAZE.get();
            case BlazeBurnerBlock.HeatLevel.SEETHING -> (Integer)Config.HEAT_PER_SEETHING_BLAZE.get();
        };
    }

    public boolean needToHeatUp(BlazeBurnerBlock.HeatLevel heatLevel) {
        return this.needToHeatAbove() && (this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.NONE) || heatLevel.equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING) && !this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING));
    }

    /*
     * Unable to fully structure code
     */
    public boolean needToHeatAbove() {
        needToHeatAbove = this.getLevel().getBlockState(this.getBlockPos().above()).is(CHTags.BlockTag.SHOULD_HEAT);
        var4_2 = this.getLevel().getBlockEntity(this.getBlockPos().above());
        if (!(var4_2 instanceof FluidTankBlockEntity)) ** GOTO lbl-1000
        fluidTankBlockEntity = (FluidTankBlockEntity)var4_2;
        if (fluidTankBlockEntity.getControllerBE().boiler.attachedEngines > 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        needToHeatBoiler = v0;
        return needToHeatAbove != false || needToHeatBoiler != false;
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevel(BlockPos pos) {
        BlockState blockState = this.getLevel().getBlockState(pos);
        return blockState.hasProperty((Property)BlazeBurnerBlock.HEAT_LEVEL) ? (BlazeBurnerBlock.HeatLevel)blockState.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL) : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevel() {
        return (BlazeBurnerBlock.HeatLevel)this.getBlockState().getValue((Property)BlazeBurnerBlock.HEAT_LEVEL);
    }

    public void setBlockHeat(BlazeBurnerBlock.HeatLevel heatLevel) {
        this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)heatLevel), 3);
        this.notifyUpdate();
    }

    public void checkNeighbour() {
        if (!this.isController) {
            boolean foundConnect = false;
            for (Direction direction : Direction.values()) {
                ThermalBlockEntity controllerEntity;
                BlockEntity blockEntity = this.getLevel().getBlockEntity(this.getBlockPos().relative(direction));
                if (!(blockEntity instanceof ThermalBlockEntity)) continue;
                ThermalBlockEntity neighbourEntity = (ThermalBlockEntity)blockEntity;
                this.isController = false;
                if (!foundConnect) {
                    this.controllerPos = neighbourEntity.getControllerPos();
                    foundConnect = true;
                }
                if ((controllerEntity = this.getControllerEntity()) == null) continue;
                controllerEntity.addConnectedPos(this.getBlockPos());
                if (neighbourEntity.getControllerPos().equals((Object)this.controllerPos)) continue;
                if (neighbourEntity.getControllerEntity() != null) {
                    neighbourEntity.getControllerEntity().isController = false;
                }
                controllerEntity.walkAllBlocks(null);
            }
            if (!foundConnect) {
                this.isController = true;
                this.controllerPos = this.getBlockPos();
                this.addConnectedPos(this.getBlockPos());
            }
        }
    }

    public void addConnectedPos(BlockPos pos) {
        this.connectedBlocks.add(pos);
        this.calculateHeatStorage();
    }

    public void destroy() {
        if (this.isController) {
            for (BlockPos pos : this.connectedBlocks) {
                BlockEntity blockEntity;
                if (pos.equals((Object)this.getBlockPos()) || !((blockEntity = this.getLevel().getBlockEntity(pos)) instanceof ThermalBlockEntity)) continue;
                ThermalBlockEntity thermalBlockEntity = (ThermalBlockEntity)blockEntity;
                thermalBlockEntity.isController = true;
                thermalBlockEntity.walkAllBlocks(this.getBlockPos());
                break;
            }
        } else {
            BlockEntity blockEntity = this.getLevel().getBlockEntity(this.controllerPos);
            if (blockEntity instanceof ThermalBlockEntity) {
                ThermalBlockEntity thermalBlockEntity = (ThermalBlockEntity)blockEntity;
                thermalBlockEntity.walkAllBlocks(this.getBlockPos());
            }
        }
        super.destroy();
    }

    public void walkAllBlocks(BlockPos exceptFor) {
        Set<BlockPos> oldBlocks = Set.copyOf(this.connectedBlocks);
        this.connectedBlocks.clear();
        this.walkAllBlocks(this.getBlockPos(), this.connectedBlocks, pos -> {
            BlockEntity patt0$temp;
            if (!pos.equals((Object)exceptFor) && (patt0$temp = this.getLevel().getBlockEntity(pos)) instanceof ThermalBlockEntity) {
                ThermalBlockEntity thermalBlockEntity = (ThermalBlockEntity)patt0$temp;
                thermalBlockEntity.controllerPos = this.getBlockPos();
                return true;
            }
            return false;
        });
        for (BlockPos pos2 : oldBlocks) {
            ThermalBlockEntity thermalBlockEntity;
            BlockEntity blockEntity;
            if (this.connectedBlocks.contains(pos2) || !((blockEntity = this.getLevel().getBlockEntity(pos2)) instanceof ThermalBlockEntity) || (thermalBlockEntity = (ThermalBlockEntity)blockEntity).isController() || !thermalBlockEntity.getControllerPos().equals((Object)this.getBlockPos())) continue;
            thermalBlockEntity.isController = true;
            thermalBlockEntity.walkAllBlocks(exceptFor);
        }
        this.calculateHeatStorage();
        this.notifyUpdate();
    }

    private void calculateHeatStorage() {
        this.heatStorage.setCapacity(this.connectedBlocks.size() * this.MAX_HEAT);
    }

    public void walkAllBlocks(BlockPos startPos, Set<BlockPos> walkedBlockPos, Predicate<BlockPos> check) {
        if (walkedBlockPos.contains(startPos) || !check.test(startPos)) {
            return;
        }
        walkedBlockPos.add(startPos);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = startPos.relative(direction);
            this.walkAllBlocks(neighborPos, walkedBlockPos, check);
        }
    }

    public ThermalBlockEntity getControllerEntity() {
        if (this.isController) {
            return this;
        }
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this.controllerPos);
        if (blockEntity instanceof ThermalBlockEntity) {
            ThermalBlockEntity controllerEntity = (ThermalBlockEntity)blockEntity;
            return controllerEntity;
        }
        return null;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean isController() {
        return this.isController;
    }

    public BlockPos getControllerPos() {
        return this.isController ? this.getBlockPos() : this.controllerPos;
    }

    public Set<BlockPos> getConnectedBlocks() {
        return this.isController ? this.connectedBlocks : this.getControllerEntity().getConnectedBlocks();
    }

    public int getHeat() {
        return this.heat;
    }

    public HeatStorage getHeatStorage() {
        return this.heatStorage;
    }

    public static class HeatStorage {
        private int capacity;
        private int amount;

        public HeatStorage(int capacity) {
            this.capacity = capacity;
            this.amount = 0;
        }

        public int insert(int heat) {
            int max = this.amount + heat;
            if (max > this.capacity) {
                this.amount = this.capacity;
                return max - this.capacity;
            }
            this.amount = max;
            return heat;
        }

        public int extract(int heat, boolean simulate) {
            int min = this.amount - heat;
            if (min < 0) {
                if (!simulate) {
                    this.amount = 0;
                }
                return heat + min;
            }
            if (!simulate) {
                this.amount = min;
            }
            return heat;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
            this.amount = Math.min(this.amount, capacity);
        }

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("capacity", this.capacity);
            nbt.putInt("amount", this.amount);
            return nbt;
        }

        public void fromNbt(CompoundTag nbt) {
            this.capacity = nbt.getInt("capacity");
            this.amount = nbt.getInt("amount");
        }

        public int getAmount() {
            return this.amount;
        }

        public String toString() {
            return "{" + this.amount + "/" + this.capacity + "}";
        }
    }

    private record CostHeatResult(int heat, int superHeatCount) {
    }
}

