/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.api.anvilCraft;

import com.ffsupver.createheat.api.BlockStateTester;
import com.ffsupver.createheat.compat.anvilCraft.AnvilCraft;
import com.ffsupver.createheat.util.DataUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.dubhe.anvilcraft.api.heat.HeatTier;
import dev.dubhe.anvilcraft.api.heat.HeatTierLine;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.block.state.BlockState;

public class HeatableBlockHeatTransferProcesserData {
    public static Codec<HeatableBlockHeatTransferProcesserData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.list(HeatTierLineData.CODEC).fieldOf("heat_tier_line").forGetter(HeatableBlockHeatTransferProcesserData::heatTierLineBuilderData), (App)Codec.list(BlockStateTester.CODEC).fieldOf("blocks").forGetter(HeatableBlockHeatTransferProcesserData::testers)).apply((Applicative)i, HeatableBlockHeatTransferProcesserData::new));
    private final List<HeatTierLineData> heatTierLineBuilderData;
    private final List<BlockStateTester> testers;
    private final HeatTierLine heatTierLine;

    public HeatableBlockHeatTransferProcesserData(List<HeatTierLineData> heatTierLineBuilderData, List<BlockStateTester> testers) {
        this.heatTierLineBuilderData = heatTierLineBuilderData;
        this.testers = testers;
        this.heatTierLine = HeatableBlockHeatTransferProcesserData.buildHeatTierLine(heatTierLineBuilderData);
    }

    public List<BlockStateTester> testers() {
        return this.testers;
    }

    public List<HeatTierLineData> heatTierLineBuilderData() {
        return this.heatTierLineBuilderData;
    }

    public HeatTierLine heatTierLine() {
        return this.heatTierLine;
    }

    public static Optional<Holder.Reference<HeatableBlockHeatTransferProcesserData>> getFromBlockState(BlockState state, RegistryAccess registryAccess) {
        return DataUtil.getLastMatchData(AnvilCraft.HEATABLE_BLOCK_HTP_DATA, registryAccess, h -> ((HeatableBlockHeatTransferProcesserData)h.value()).testers().stream().anyMatch(tester -> tester.test(state)));
    }

    private static HeatTierLine buildHeatTierLine(List<HeatTierLineData> dataList) {
        HeatTierLine.LineBuilder builder = HeatTierLine.builder();
        dataList.forEach(data -> builder.addPoint(data.toNext, data.heatTier, data.duration));
        return builder.build();
    }

    public record HeatTierLineData(HeatTier heatTier, int toNext, int duration) {
        public static Codec<HeatTierLineData> CODEC = RecordCodecBuilder.create(i -> i.group((App)HeatTier.LOWER_NAME_CODEC.fieldOf("heat_tier").forGetter(HeatTierLineData::heatTier), (App)Codec.INT.optionalFieldOf("to_next", (Object)Integer.MAX_VALUE).forGetter(HeatTierLineData::toNext), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(HeatTierLineData::duration)).apply((Applicative)i, HeatTierLineData::new));
    }
}

