/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.dragonFireInput;

import com.ffsupver.createheat.api.iceAndFire.DragonHeater;
import com.ffsupver.createheat.block.HeatProvider;
import com.ffsupver.createheat.block.dragonFireInput.DragonFireInputBlock;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.util.DragonTypeProvider;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DragonFireInputBlockEntity
extends SmartBlockEntity
implements HeatProvider {
    public int lastDragonFlameTimer = 0;
    public boolean isHitByFrame;
    private static final int COOL_DOWN = 60;
    private int lastStage;
    private DragonType dragonType;
    private DragonHeater dragonHeater;
    private UUID lastDragonUUID;
    private static final float RADIUS = 25.0f;

    public DragonFireInputBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        assert (this.level != null);
        this.checkAssembled();
        this.lureDragons(this.dragonType);
        if (!this.assembled()) {
            this.lastStage = 0;
            this.lastDragonFlameTimer = 0;
            if (this.getBurning()) {
                this.setBurning(false);
            }
            return;
        }
        RegistryAccess registryAccess = this.level.registryAccess();
        Optional<Holder.Reference<DragonHeater>> dragonHeaterReferenceOp = DragonHeater.getFromDragonType(registryAccess, this.dragonType);
        if (dragonHeaterReferenceOp.isPresent()) {
            this.dragonHeater = (DragonHeater)dragonHeaterReferenceOp.get().value();
            if (this.lastDragonFlameTimer > 0) {
                --this.lastDragonFlameTimer;
            } else if (this.lastDragonFlameTimer == 0) {
                if (this.isHitByFrame) {
                    this.lastDragonFlameTimer = 60;
                    this.isHitByFrame = false;
                } else if (this.lastStage != 0) {
                    this.lastStage = 0;
                }
            }
        }
        this.updateBurning();
    }

    private void checkAssembled() {
        DragonType dragonTypeToCheck = null;
        for (Direction facing : Direction.values()) {
            BlockPos pos = this.getBlockPos().relative(facing);
            assert (this.level != null);
            BlockState state = this.level.getBlockState(pos);
            Block block = state.getBlock();
            if (!(block instanceof DragonTypeProvider)) continue;
            DragonTypeProvider provider = (DragonTypeProvider)block;
            dragonTypeToCheck = provider.getDragonType();
            break;
        }
        this.dragonType = dragonTypeToCheck;
    }

    private boolean assembled() {
        return this.dragonType != null;
    }

    private boolean canLungDragon(DragonType dragonType, Level level) {
        return DragonHeater.getFromDragonType(level.registryAccess(), dragonType).isPresent();
    }

    public void onHitByFrame(int stage) {
        if (this.assembled()) {
            this.setLastStage(stage);
            this.isHitByFrame = true;
            this.lastDragonFlameTimer = Math.min(this.lastDragonFlameTimer + 60, 300);
            this.notifyUpdate();
        }
    }

    private void setLastStage(int stage) {
        int tmpLastStage = this.lastStage;
        this.lastStage = stage;
        if (tmpLastStage != this.lastStage) {
            this.setBurning(!this.getBurning());
        }
    }

    private void setBurning(boolean burning) {
        this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(DragonFireInputBlock.BURNING, (Comparable)Boolean.valueOf(burning)), 3);
        this.notifyUpdate();
    }

    private boolean getBurning() {
        return (Boolean)this.getBlockState().getValue(DragonFireInputBlock.BURNING);
    }

    private void updateBurning() {
        boolean newBurning;
        boolean bl = newBurning = this.lastStage != 0;
        if (this.getBurning() != newBurning) {
            this.setBurning(newBurning);
        }
    }

    protected void lureDragons(DragonType dragonType) {
        boolean canLungType = this.canLungDragon(dragonType, this.level);
        Vec3 targetPosition = new Vec3((double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f));
        AABB searchArea = new AABB((double)this.worldPosition.getX() - 25.0, (double)this.worldPosition.getY() - 25.0, (double)this.worldPosition.getZ() - 25.0, (double)this.worldPosition.getX() + 25.0, (double)this.worldPosition.getY() + 25.0, (double)this.worldPosition.getZ() + 25.0);
        boolean dragonSelected = false;
        DragonBaseEntity backUpDragon = null;
        for (DragonBaseEntity dragon : this.level.getEntitiesOfClass(DragonBaseEntity.class, searchArea)) {
            boolean targetThis;
            boolean noTarget = dragon.burningTarget == null;
            boolean isLastOne = dragon.getUUID().equals(this.lastDragonUUID);
            boolean bl = targetThis = !noTarget && dragon.burningTarget.equals((Object)this.worldPosition);
            if (canLungType && this.assembled() && dragon.dragonType.equals((Object)dragonType) && this.canSeeInput(dragon, targetPosition) && (noTarget || isLastOne)) {
                if (backUpDragon == null) {
                    backUpDragon = dragon;
                }
                if (!isLastOne) continue;
                if (!noTarget && !targetThis) {
                    this.lastDragonUUID = null;
                    continue;
                }
                backUpDragon = dragon;
                dragonSelected = true;
                continue;
            }
            if (!targetThis) continue;
            dragon.burningTarget = null;
        }
        if (backUpDragon != null) {
            backUpDragon.burningTarget = this.worldPosition;
            if (!dragonSelected) {
                this.lastDragonUUID = backUpDragon.getUUID();
            }
        }
    }

    private boolean canSeeInput(DragonBaseEntity dragon, Vec3 target) {
        if (target != null) {
            assert (this.level != null);
            BlockHitResult rayTrace = this.level.clip(new ClipContext(dragon.getHeadPosition(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dragon));
            double distance = dragon.getHeadPosition().distanceTo(rayTrace.getLocation());
            return distance < (double)(10.0f + dragon.getBbWidth() * 2.0f);
        }
        return false;
    }

    public void destroy() {
        this.lureDragons(null);
        super.destroy();
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.lastDragonFlameTimer = tag.getInt("frame_timer");
        this.isHitByFrame = tag.getBoolean("hit_by_frame");
        this.lastStage = tag.getInt("stage");
        if (tag.contains("dragon_type", 8)) {
            this.dragonType = (DragonType)IafRegistries.DRAGON_TYPE.get(ResourceLocation.parse((String)tag.getString("dragon_type")));
        }
        if (tag.contains("last_dragon", 11)) {
            this.lastDragonUUID = tag.getUUID("last_dragon");
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putInt("frame_timer", this.lastDragonFlameTimer);
        tag.putBoolean("hit_by_frame", this.isHitByFrame);
        tag.putInt("stage", this.lastStage);
        if (this.dragonType != null) {
            tag.putString("dragon_type", IafRegistries.DRAGON_TYPE.getKey((Object)this.dragonType).toString());
        }
        if (this.lastDragonUUID != null) {
            tag.putUUID("last_dragon", this.lastDragonUUID);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    private HeatProvider getHeatProvider() {
        if (!this.assembled() || this.dragonHeater == null) {
            return DragonHeater.NO_HEAT_PROVIDER;
        }
        return this.dragonHeater.heatProviderByStage().apply(this.lastStage);
    }

    @Override
    public int getHeatPerTick() {
        return this.getHeatProvider().getHeatPerTick();
    }

    @Override
    public int getSupperHeatCount() {
        return this.getHeatProvider().getSupperHeatCount();
    }
}

